/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.util.Arrays;
import java.util.Map;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicExpression;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class BasicOperator
extends BasicExpression
implements Operator {
    protected VariableOperand result = null;
    protected boolean verified = false;
    protected Expression[] expressions;

    public BasicOperator() {
    }

    public BasicOperator(Expression[] expressions) {
        this.expressions = expressions;
    }

    public BasicOperator(PType type) {
        super(type);
    }

    public BasicOperator(PType type, Expression[] expressions) {
        super(type);
        this.expressions = expressions;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        BasicOperator bo = (BasicOperator)clone;
        bo.result = (VariableOperand)BasicOperator.getClone(this.result, obj2clone);
        bo.verified = this.verified;
        if (this.expressions != null) {
            bo.expressions = new Expression[this.expressions.length];
            for (int i = 0; i < this.expressions.length; ++i) {
                if (this.expressions[i] == null) continue;
                bo.expressions[i] = (Expression)BasicOperator.getClone(this.expressions[i], obj2clone);
            }
        }
        return clone;
    }

    protected int checkOperands(PType[][] expectedTypes) throws MalformedExpressionException {
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (expectedTypes[i].length != this.expressions.length) continue;
            boolean match = true;
            for (int j = 0; match && j < expectedTypes[i].length; ++j) {
                if (this.expressions[j] == null) {
                    throw new MalformedExpressionException("Null Parameter " + j + " not expected: ");
                }
                if (this.expressions[j].getType().isa(expectedTypes[i][j])) continue;
                match = false;
            }
            if (!match) continue;
            return i;
        }
        throw new MalformedExpressionException("Not expected parameter " + Arrays.asList(this.expressions));
    }

    protected void compileOperands() throws ExpressionException, MalformedExpressionException {
        for (int i = 0; i < this.expressions.length; ++i) {
            if (this.expressions[i] == null) continue;
            this.expressions[i].compileExpression();
        }
    }

    public Expression getExpression(int i) {
        if (this.expressions == null) {
            this.logger.log(BasicLevel.FATAL, (Object)("Operand of the operaor " + this.getOperatorString()), (Throwable)new NullPointerException());
        }
        return this.expressions[i];
    }

    public synchronized void setExpression(int idx, Expression e) {
        if (this.expressions == null) {
            this.expressions = new Expression[idx + 1];
            this.logger.log(BasicLevel.WARN, (Object)("Allocation of the operand array (" + idx + ") for the operator " + this.getOperatorString()));
        } else if (idx >= this.expressions.length) {
            Expression[] neo = new Expression[idx + 1];
            System.arraycopy(this.expressions, 0, neo, 0, this.expressions.length);
            this.expressions = neo;
            this.logger.log(BasicLevel.WARN, (Object)("Reallocation " + this.expressions.length + " to " + idx + "of the operand array for the operator " + this.getOperatorString()));
        }
        this.expressions[idx] = e;
    }

    public int getOperandNumber() {
        return this.expressions.length;
    }
}

