/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import java.text.DecimalFormat;

public class BinaryDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12, 8, 4, 0};

    public static String dump(byte[] data, long offset, int index) {
        if (index < 0 || index >= data.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + index + ", length=" + data.length);
        }
        long display_offset = offset + (long)index;
        StringBuffer buffer = new StringBuffer(74);
        for (int j = index; j < data.length; j += 16) {
            int k;
            int chars_read = data.length - j;
            if (chars_read > 16) {
                chars_read = 16;
            }
            buffer.append(BinaryDump.dump(display_offset)).append(' ');
            for (k = 0; k < 16; ++k) {
                if (k < chars_read) {
                    buffer.append(BinaryDump.dump(data[k + j]));
                } else {
                    buffer.append("  ");
                }
                buffer.append(' ');
            }
            for (k = 0; k < chars_read; ++k) {
                if (data[k + j] >= 32 && data[k + j] < 127) {
                    buffer.append((char)data[k + j]);
                    continue;
                }
                buffer.append('.');
            }
            buffer.append(EOL);
            display_offset += (long)chars_read;
        }
        return buffer.toString();
    }

    private static String dump(long value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        for (int j = 0; j < 8; ++j) {
            buf.append(_hexcodes[(int)(value >> _shifts[j + _shifts.length - 8]) & 0xF]);
        }
        return buf.toString();
    }

    private static String dump(byte value) {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        for (int j = 0; j < 2; ++j) {
            buf.append(_hexcodes[value >> _shifts[j + 6] & 0xF]);
        }
        return buf.toString();
    }

    public static String toHex(byte[] value) {
        return BinaryDump.toHex(value, 0, value.length);
    }

    public static String toHex(byte[] value, int offset, int length) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('[');
        for (int i = offset; i < offset + length; ++i) {
            strbuf.append(BinaryDump.toHex(value[i]));
            strbuf.append(", ");
        }
        strbuf.append(']');
        return strbuf.toString();
    }

    public static String toHex(byte[] value, int bytesPerLine) {
        int digits = (int)Math.round(Math.log(value.length) / Math.log(10.0) + 0.5);
        StringBuffer formatString = new StringBuffer();
        for (int i = 0; i < digits; ++i) {
            formatString.append('0');
        }
        formatString.append(": ");
        DecimalFormat format = new DecimalFormat(formatString.toString());
        StringBuffer retVal = new StringBuffer();
        retVal.append(format.format(0L));
        int i = -1;
        for (int x = 0; x < value.length; ++x) {
            if (++i == bytesPerLine) {
                retVal.append('\n');
                retVal.append(format.format(x));
                i = 0;
            }
            retVal.append(BinaryDump.toHex(value[x]));
            retVal.append(", ");
        }
        return retVal.toString();
    }

    public static String toHex(byte value) {
        return BinaryDump.toHex(value, 2);
    }

    private static String toHex(long value, int digits) {
        StringBuffer result = new StringBuffer(digits);
        for (int j = 0; j < digits; ++j) {
            result.append(_hexcodes[(int)(value >> _shifts[j + (16 - digits)] & 0xFL)]);
        }
        return result.toString();
    }
}

