/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.TimerDaemon;
import fr.dyade.aaa.util.TimerTask;
import java.util.Vector;

public class Timer {
    private boolean cancelled = false;
    TimerDaemon daemon;
    Vector tasks = new Vector();

    public Timer() {
        this.daemon = new TimerDaemon(this);
    }

    public synchronized void schedule(TimerTask task, long delay) throws Exception {
        if (this.cancelled) {
            throw new IllegalStateException("Timer has been cancelled.");
        }
        if (this.tasks.contains(task)) {
            throw new IllegalStateException("Task is already scheduled.");
        }
        if (task.cancelled) {
            throw new IllegalStateException("Task has been cancelled.");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("Invalid negative delay: " + delay);
        }
        long wakeupTime = System.currentTimeMillis() + delay;
        this.insertTask(task, wakeupTime);
        if (!this.daemon.started) {
            this.daemon.start();
        }
        this.notify();
    }

    public synchronized void cancel() {
        this.cancelled = true;
        if (!this.daemon.started) {
            return;
        }
        this.tasks.removeAllElements();
        this.daemon.running = false;
        this.daemon.shutdown();
    }

    private void insertTask(TimerTask task, long wakeupTime) {
        int i;
        task.timer = this;
        task.wakeupTime = wakeupTime;
        for (i = 0; i < this.tasks.size(); ++i) {
            TimerTask currentTask = (TimerTask)this.tasks.elementAt(i);
            if (currentTask.wakeupTime <= wakeupTime) continue;
            this.tasks.insertElementAt(task, i);
            break;
        }
        if (i == this.tasks.size()) {
            this.tasks.addElement(task);
        }
    }
}

