/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.configuration.spring.AbstractSpringBeanMap;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanMap<V>
extends AbstractSpringBeanMap<String, V> {
    @Override
    protected void processBeans(ApplicationContext beanFactory) {
        if (beanFactory == null) {
            return;
        }
        String[] beanNames = beanFactory.getBeanNamesForType(this.type);
        ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)beanFactory;
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanNames[i]);
            if (!def.isSingleton() || def.isAbstract()) continue;
            try {
                ArrayList<String> ids = null;
                PropertyValue pv = def.getPropertyValues().getPropertyValue(this.idsProperty);
                if (pv != null) {
                    Object value = pv.getValue();
                    if (!(value instanceof Collection)) {
                        throw new RuntimeException("The property " + this.idsProperty + " must be a collection!");
                    }
                    if (value instanceof Mergeable) {
                        if (!((Mergeable)value).isMergeEnabled()) {
                            ids = (Collection)value;
                        }
                    } else {
                        ids = (ArrayList<String>)value;
                    }
                }
                if (ids == null && (ids = this.getIds(ctxt.getBean(beanNames[i]))) == null) continue;
                if (ids instanceof ManagedSet || ids instanceof ManagedList) {
                    ArrayList<String> newIds = new ArrayList<String>();
                    for (String o : ids) {
                        if (o instanceof TypedStringValue) {
                            newIds.add(((TypedStringValue)((Object)o)).getValue());
                            continue;
                        }
                        newIds.add(o);
                    }
                    ids = newIds;
                }
                for (String id : ids) {
                    this.getBeanListForId(id.toString()).add(beanNames[i]);
                }
                continue;
            }
            catch (BeanIsAbstractException e) {
                // empty catch block
            }
        }
        this.processBeans(ctxt.getParent());
    }
}

