/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.invoker.ApplicationScopePolicy;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.ScopePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSMethodInvoker
extends FactoryInvoker {
    public JAXWSMethodInvoker(final Object bean) {
        super(new Factory(){

            public Object create() {
                return bean;
            }
        }, ApplicationScopePolicy.instance());
    }

    public JAXWSMethodInvoker(Factory factory) {
        super(factory, ApplicationScopePolicy.instance());
    }

    public JAXWSMethodInvoker(Factory factory, ScopePolicy scope) {
        super(factory, scope);
    }

    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (ex instanceof SOAPFaultException) {
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            return this.findSoapFaultException(ex.getCause());
        }
        return null;
    }

    @Override
    protected Fault createFault(Throwable ex, Method m, List<Object> params, boolean checked) {
        SOAPFaultException sfe = this.findSoapFaultException(ex);
        if (sfe != null) {
            SoapFault fault = new SoapFault(sfe.getFault().getFaultString(), ex, sfe.getFault().getFaultCodeAsQName());
            fault.setRole(sfe.getFault().getFaultActor());
            fault.setDetail(sfe.getFault().getDetail());
            return fault;
        }
        return super.createFault(ex, m, params, checked);
    }

    @Override
    protected Object invoke(Exchange exchange, Object serviceObject, Method m, List<Object> params) {
        MessageContext ctx = ContextPropertiesMapping.createWebServiceContext(exchange);
        Map scopes = CastUtils.cast((Map)ctx.get(WrappedMessageContext.SCOPES));
        HashMap handlerScopedStuff = new HashMap();
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                handlerScopedStuff.put(scope.getKey(), ctx.get(scope.getKey()));
            }
            for (String key : handlerScopedStuff.keySet()) {
                ctx.remove(key);
            }
        }
        WebServiceContextImpl.setMessageContext(ctx);
        List res = CastUtils.cast((List)super.invoke(exchange, serviceObject, m, params));
        for (Map.Entry key : handlerScopedStuff.entrySet()) {
            ctx.put(key.getKey(), key.getValue());
            ctx.setScope((String)key.getKey(), MessageContext.Scope.HANDLER);
        }
        ContextPropertiesMapping.updateWebServiceContext(exchange, ctx);
        WebServiceContextImpl.clear();
        return res;
    }
}

