/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.util.Config;

class PhoneTable {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$datastore$jdbc$PhoneTable == null ? (class$org$apache$juddi$datastore$jdbc$PhoneTable = PhoneTable.class$("org.apache.juddi.datastore.jdbc.PhoneTable")) : class$org$apache$juddi$datastore$jdbc$PhoneTable);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static String tablePrefix = Config.getStringProperty("juddi.tablePrefix", "");
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$PhoneTable;

    PhoneTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, int contactID, Vector phoneList, Connection connection) throws SQLException {
        if (phoneList == null || phoneList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            int listSize = phoneList.size();
            for (int phoneID = 0; phoneID < listSize; ++phoneID) {
                Phone phone = (Phone)phoneList.elementAt(phoneID);
                statement.setInt(3, phoneID);
                statement.setString(4, phone.getUseType());
                statement.setString(5, phone.getValue());
                if (log.isDebugEnabled()) {
                    log.debug("insert into " + tablePrefix + "PHONE table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t PHONE_ID=" + phoneID + "\n\t USE_TYPE=" + phone.getUseType() + "\n\t PHONE_NUMBER=" + phone.getValue() + "\n");
                }
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, int contactID, Connection connection) throws SQLException {
        Vector<Phone> phoneList = new Vector<Phone>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            if (log.isDebugEnabled()) {
                log.debug("select from " + tablePrefix + "PHONE table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n");
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Phone phone = new Phone();
                phone.setUseType(resultSet.getString(1));
                phone.setValue(resultSet.getString(2));
                phoneList.add(phone);
            }
            Vector<Phone> vector = phoneList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            if (log.isDebugEnabled()) {
                log.debug("delete from the " + tablePrefix + "PHONE table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n");
            }
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ").append(tablePrefix).append("PHONE (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("PHONE_ID,");
        sql.append("USE_TYPE,");
        sql.append("PHONE_NUMBER) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("USE_TYPE,");
        sql.append("PHONE_NUMBER, ");
        sql.append("PHONE_ID ");
        sql.append("FROM ").append(tablePrefix).append("PHONE ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND CONTACT_ID=? ");
        sql.append("ORDER BY PHONE_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ").append(tablePrefix).append("PHONE ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

