/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeleteBinding;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class DeleteBindingFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$DeleteBindingFunction == null ? (class$org$apache$juddi$function$DeleteBindingFunction = DeleteBindingFunction.class$("org.apache.juddi.function.DeleteBindingFunction")) : class$org$apache$juddi$function$DeleteBindingFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$DeleteBindingFunction;

    public DeleteBindingFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        DeleteBinding request = (DeleteBinding)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector bindingKeyVector = request.getBindingKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            String bindingKey;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (i = 0; i < bindingKeyVector.size(); ++i) {
                bindingKey = (String)bindingKeyVector.elementAt(i);
                if (bindingKey == null || bindingKey.length() == 0 || !dataStore.isValidBindingKey(bindingKey)) {
                    throw new InvalidKeyPassedException("delete_binding: bindingKey=" + bindingKey);
                }
                if (dataStore.isBindingPublisher(bindingKey, publisherID)) continue;
                throw new UserMismatchException("delete_binding: userID=" + publisherID + ", " + "bindingKey=" + bindingKey);
            }
            for (i = 0; i < bindingKeyVector.size(); ++i) {
                bindingKey = (String)bindingKeyVector.elementAt(i);
                dataStore.deleteBinding(bindingKey);
                log.info("Publisher '" + publisherID + "' deleted BindingTemplate with key: " + bindingKey);
            }
            dataStore.commit();
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(keyex.getMessage());
            throw keyex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(umex.getMessage());
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        Result result = new Result(0);
        result.setErrCode(Result.lookupErrCode(0));
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(result);
        return dispRpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            GetAuthToken authTokenRequest = new GetAuthToken("sviens", "password");
            AuthToken authToken = (AuthToken)reg.execute(authTokenRequest);
            AuthInfo authInfo = authToken.getAuthInfo();
            DeleteBinding request = new DeleteBinding();
            request.setAuthInfo(authInfo);
            DispositionReport response = (DispositionReport)reg.execute(request);
            System.out.println("errno: " + response.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

