/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.GetTModelDetail;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetTModelDetailFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$GetTModelDetailFunction == null ? (class$org$apache$juddi$function$GetTModelDetailFunction = GetTModelDetailFunction.class$("org.apache.juddi.function.GetTModelDetailFunction")) : class$org$apache$juddi$function$GetTModelDetailFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$GetTModelDetailFunction;

    public GetTModelDetailFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetTModelDetail request = (GetTModelDetail)regObject;
        String generic = request.getGeneric();
        Vector keyVector = request.getTModelKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            for (int i = 0; i < keyVector.size(); ++i) {
                String tModelKey = (String)keyVector.elementAt(i);
                if (tModelKey != null && tModelKey.length() != 0 && dataStore.isValidTModelKey(tModelKey)) continue;
                throw new InvalidKeyPassedException("get_tModelDetail: tModelKey=" + tModelKey);
            }
            Vector<TModel> tModelVector = new Vector<TModel>();
            for (int i = 0; i < keyVector.size(); ++i) {
                String tModelKey = (String)keyVector.elementAt(i);
                tModelVector.add(dataStore.fetchTModel(tModelKey));
            }
            dataStore.commit();
            TModelDetail detail = new TModelDetail();
            detail.setGeneric(generic);
            detail.setTModelVector(tModelVector);
            detail.setOperator(Config.getOperator());
            TModelDetail tModelDetail = detail;
            return tModelDetail;
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(keyex.getMessage());
            throw keyex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

