/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ResultHandler
extends AbstractHandler {
    public static final String TAG_NAME = "result";
    private HandlerMaker maker = null;

    protected ResultHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Result obj = new Result();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setErrno(element.getAttribute("errno"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "errInfo");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("errInfo");
            obj.setErrInfo((ErrInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Result result = (Result)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("errno", String.valueOf(result.getErrno()));
        ErrInfo errInfo = result.getErrInfo();
        if (errInfo != null) {
            handler = this.maker.lookup("errInfo");
            handler.marshal(errInfo, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        ErrInfo errInfo = new ErrInfo();
        errInfo.setErrCode("E_accountLimitExceeded");
        errInfo.setErrMsg("Authentication token information has timed out.");
        Result result = new Result();
        result.setErrno(10160);
        result.setErrInfo(errInfo);
        System.out.println();
        RegistryObject regObject = result;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

