/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.ws.scout.registry.infomodel.ExtensibleObjectImpl;
import org.apache.ws.scout.registry.infomodel.ExternalIdentifierImpl;
import org.apache.ws.scout.registry.infomodel.ExternalLinkImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.OrganizationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryObjectImpl
extends ExtensibleObjectImpl
implements RegistryObject {
    private final LifeCycleManager lifeCycleManager;
    private Key key;
    private InternationalString name = new InternationalStringImpl();
    private InternationalString desc = new InternationalStringImpl();
    private Set<Classification> classifications = new HashSet<Classification>();
    private Set<Association> associations = new HashSet<Association>();
    private Set<ExternalIdentifier> externalIds = new HashSet<ExternalIdentifier>();
    private Set<ExternalLink> externalLinks = new HashSet<ExternalLink>();
    private OrganizationImpl submittingOrganization;

    public RegistryObjectImpl(LifeCycleManager lifeCycleManager) {
        this.lifeCycleManager = lifeCycleManager;
    }

    public RegistryObjectImpl(LifeCycleManager lifeCycleManager, InternationalString n) {
        this.lifeCycleManager = lifeCycleManager;
        this.name = n;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public InternationalString getDescription() {
        return this.desc;
    }

    @Override
    public void setDescription(InternationalString description) {
        this.desc = description;
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    @Override
    public void setName(InternationalString name) {
        this.name = name;
    }

    @Override
    public void setKey(Key k) {
        this.key = k;
    }

    @Override
    public String toXML() throws JAXRException {
        throw new UnsupportedCapabilityException("toXML is not supported");
    }

    @Override
    public void addClassification(Classification classification) {
        this.classifications.add(classification);
    }

    @Override
    public void addClassifications(Collection collection) {
        if (collection != null) {
            for (Classification classification : collection) {
                this.classifications.add(classification);
            }
        }
    }

    @Override
    public void removeClassification(Classification classification) {
        this.classifications.remove(classification);
    }

    public void removeClassifications(Collection<Classification> collection) {
        this.classifications.removeAll(collection);
    }

    @Override
    public Collection getClassifications() {
        return Collections.unmodifiableSet(this.classifications);
    }

    public void setClassifications(Collection<Classification> collection) {
        HashSet<Classification> newClassifications = new HashSet<Classification>(collection.size());
        for (Classification classification : collection) {
            newClassifications.add(classification);
        }
        this.classifications = newClassifications;
    }

    @Override
    public void addAssociation(Association association) throws JAXRException {
        this.associations.add(association);
        association.setSourceObject(this);
    }

    @Override
    public void addAssociations(Collection collection) throws JAXRException {
        for (Association association : collection) {
            this.addAssociation(association);
        }
    }

    @Override
    public Collection<Association> getAssociations() throws JAXRException {
        return Collections.unmodifiableSet(this.associations);
    }

    @Override
    public void setAssociations(Collection collection) {
        HashSet<Association> newAssociations = new HashSet<Association>(collection.size());
        for (Association association : collection) {
            newAssociations.add(association);
        }
        this.associations = newAssociations;
    }

    @Override
    public void removeAssociation(Association association) {
        this.associations.remove(association);
    }

    @Override
    public void removeAssociations(Collection collection) {
        this.associations.removeAll(collection);
    }

    @Override
    public void addExternalIdentifier(ExternalIdentifier externalIdentifier) {
        this.externalIds.add(externalIdentifier);
        ((ExternalIdentifierImpl)externalIdentifier).setRegistryObject(this);
    }

    @Override
    public void addExternalIdentifiers(Collection collection) {
        if (collection != null) {
            for (ExternalIdentifier externalId : collection) {
                this.externalIds.add(externalId);
                ((ExternalIdentifierImpl)externalId).setRegistryObject(this);
            }
        }
    }

    @Override
    public void removeExternalIdentifier(ExternalIdentifier externalIdentifier) {
        this.externalIds.remove(externalIdentifier);
        ((ExternalIdentifierImpl)externalIdentifier).setRegistryObject(null);
    }

    @Override
    public void removeExternalIdentifiers(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter != null && iter.hasNext()) {
            ExternalIdentifier externalId = (ExternalIdentifier)iter.next();
            ((ExternalIdentifierImpl)externalId).setRegistryObject(null);
        }
        this.externalIds.removeAll(collection);
    }

    @Override
    public Collection<ExternalIdentifier> getExternalIdentifiers() {
        return Collections.unmodifiableSet(this.externalIds);
    }

    public void setExternalIdentifiers(Collection<ExternalIdentifier> collection) {
        HashSet<ExternalIdentifier> newExternalIds = new HashSet<ExternalIdentifier>(collection.size());
        for (ExternalIdentifier externalId : collection) {
            newExternalIds.add(externalId);
        }
        this.externalIds = newExternalIds;
    }

    @Override
    public void addExternalLink(ExternalLink externalLink) {
        this.externalLinks.add(externalLink);
        ((ExternalLinkImpl)externalLink).addLinkedObject(this);
    }

    public void addExternalLinks(Collection<ExternalLink> collection) {
        for (ExternalLink externalLink : collection) {
            this.externalLinks.add(externalLink);
            ((ExternalLinkImpl)externalLink).addLinkedObject(this);
        }
    }

    @Override
    public void removeExternalLink(ExternalLink externalLink) {
        ((ExternalLinkImpl)externalLink).removeLinkedObject(this);
        this.externalLinks.remove(externalLink);
    }

    @Override
    public void removeExternalLinks(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter != null && iter.hasNext()) {
            ExternalLink externalLink = (ExternalLink)iter.next();
            ((ExternalLinkImpl)externalLink).removeLinkedObject(this);
        }
        this.externalLinks.removeAll(collection);
    }

    @Override
    public Collection<ExternalLink> getExternalLinks() {
        return Collections.unmodifiableSet(this.externalLinks);
    }

    public void setExternalLinks(Collection<ExternalLink> collection) {
        HashSet<ExternalLink> newExternalLinks = new HashSet<ExternalLink>(collection.size());
        for (ExternalLink externalLink : collection) {
            newExternalLinks.add(externalLink);
        }
        this.externalLinks = newExternalLinks;
    }

    @Override
    public Organization getSubmittingOrganization() {
        return this.submittingOrganization;
    }

    @Override
    public LifeCycleManager getLifeCycleManager() {
        return this.lifeCycleManager;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RegistryObjectImpl other = (RegistryObjectImpl)obj;
        return this.key != null && this.key.equals(other.key);
    }

    public int hashCode() {
        return this.key == null ? 0 : this.key.hashCode();
    }

    @Override
    public Collection getAuditTrail() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    @Override
    public Collection getAssociatedObjects() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    @Override
    public Concept getObjectType() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    @Override
    public Collection getRegistryPackages() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }
}

