/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import org.apache.ws.scout.registry.infomodel.RegistryObjectImpl;
import org.apache.ws.scout.registry.infomodel.SpecificationLinkImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingImpl
extends RegistryObjectImpl
implements ServiceBinding {
    private Collection<SpecificationLink> links = new ArrayList<SpecificationLink>();
    private String accessuri = null;
    private Service service = null;
    private ServiceBinding targetbinding = null;
    private boolean validateuri = false;

    public ServiceBindingImpl(LifeCycleManager lifeCycleManager) {
        super(lifeCycleManager);
    }

    public ServiceBindingImpl(LifeCycleManager lifeCycleManager, InternationalString n) {
        super(lifeCycleManager, n);
    }

    @Override
    public void addSpecificationLink(SpecificationLink sl) throws JAXRException {
        this.links.add(sl);
        ((SpecificationLinkImpl)sl).setServiceBinding(this);
    }

    @Override
    public void addSpecificationLinks(Collection col) throws JAXRException {
        try {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.addSpecificationLink((SpecificationLink)iter.next());
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException();
        }
    }

    @Override
    public String getAccessURI() throws JAXRException {
        return this.accessuri;
    }

    @Override
    public Service getService() throws JAXRException {
        return this.service;
    }

    @Override
    public Collection getSpecificationLinks() throws JAXRException {
        return this.links;
    }

    @Override
    public ServiceBinding getTargetBinding() throws JAXRException {
        return this.targetbinding;
    }

    @Override
    public void removeSpecificationLink(SpecificationLink link) throws JAXRException {
        this.links.remove(link);
    }

    public void removeSpecificationLinks(Collection<SpecificationLink> col) throws JAXRException {
        this.links.removeAll(col);
    }

    @Override
    public void setAccessURI(String s) throws JAXRException {
        if (this.targetbinding != null) {
            throw new InvalidRequestException("There is already a Target Binding defined");
        }
        this.accessuri = s;
    }

    @Override
    public void setTargetBinding(ServiceBinding sb) throws JAXRException {
        if (this.accessuri != null) {
            throw new InvalidRequestException("There is already an Access URI defined");
        }
        this.targetbinding = sb;
    }

    @Override
    public boolean getValidateURI() throws JAXRException {
        return this.validateuri;
    }

    @Override
    public void setValidateURI(boolean b) throws JAXRException {
        this.validateuri = b;
    }

    public void setService(Service s) {
        this.service = s;
    }
}

