/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.tree.ClassNode;
import org.eclipse.persistence.internal.libraries.asm.tree.FieldNode;
import org.eclipse.persistence.internal.libraries.asm.tree.InnerClassNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TreeCodeAdapter;

public class TreeClassAdapter
extends ClassAdapter {
    public ClassNode classNode;

    public TreeClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version2, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.classNode = new ClassNode(version2, access, name, superName, interfaces, sourceFile);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        InnerClassNode icn = new InnerClassNode(name, outerName, innerName, access);
        this.classNode.innerClasses.add(icn);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        FieldNode fn = new FieldNode(access, name, desc, value, attrs);
        this.classNode.fields.add(fn);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        MethodNode mn = new MethodNode(access, name, desc, exceptions, attrs);
        this.classNode.methods.add(mn);
        return new TreeCodeAdapter(mn);
    }

    public void visitAttribute(Attribute attr) {
        attr.next = this.classNode.attrs;
        this.classNode.attrs = attr;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.classNode.accept(this.cv);
        }
    }
}

