/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.eclipse.persistence.oxm.XMLBinder;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.documentpreservation.IgnoreNewElementsOrderingPolicy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAXBBinder
extends Binder {
    private XMLContext xmlContext;
    private XMLBinder xmlBinder;

    public JAXBBinder(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
        this.xmlBinder = this.xmlContext.createBinder();
        this.xmlBinder.getDocumentPreservationPolicy().setNodeOrderingPolicy(new IgnoreNewElementsOrderingPolicy());
    }

    public void marshal(Object obj, Object xmlNode) {
    }

    public Object updateXML(Object obj) {
        this.xmlBinder.updateXML(obj);
        return this.xmlBinder.getXMLNode(obj);
    }

    public Object updateXML(Object obj, Object xmlNode) {
        if (!(xmlNode instanceof Node)) {
            return null;
        }
        this.xmlBinder.updateXML(obj, (Element)xmlNode);
        return xmlNode;
    }

    public void setSchema(Schema schema) {
    }

    public Schema getSchema() {
        return null;
    }

    public JAXBElement getJAXBNode(Object obj) {
        Element elem = (Element)this.xmlBinder.getXMLNode(obj);
        return new JAXBElement<Object>(new QName(elem.getNamespaceURI(), elem.getLocalName()), obj.getClass(), obj);
    }

    public void setEventHandler(ValidationEventHandler handler) {
    }

    public ValidationEventHandler getEventHandler() {
        return null;
    }

    public Object updateJAXB(Object obj) {
        if (!(obj instanceof Node)) {
            return null;
        }
        this.xmlBinder.updateObject((Node)obj);
        return this.xmlBinder.getObject((Node)obj);
    }

    public Object getProperty(String propName) {
        return null;
    }

    public void setProperty(String propName, Object value) {
    }

    public Object getXMLNode(Object obj) {
        return null;
    }

    public Object unmarshal(Object obj) {
        if (!(obj instanceof Node)) {
            return null;
        }
        return this.xmlBinder.unmarshal((Node)obj);
    }

    public JAXBElement unmarshal(Object obj, Class javaClass) {
        if (!(obj instanceof Node)) {
            return null;
        }
        XMLRoot xmlRoot = this.xmlBinder.unmarshal((Node)obj, javaClass);
        return new JAXBElement<Object>(new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName()), javaClass, xmlRoot.getObject());
    }
}

