/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.jaxb.DomHandlerConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.XMLJavaTypeConverter;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLRootConverter;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingsGenerator {
    private static String WRAPPER_CLASS = "org.eclipse.persistence.jaxb.generated";
    private static int wrapperCounter = 0;
    String outputDir = ".";
    private int nextNamespaceNumber = 0;
    private HashMap userDefinedSchemaTypes;
    private Helper helper;
    private JavaClass jotArrayList;
    private JavaClass jotHashSet;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<Class, QName> generatedClassesToQNames;
    private HashMap<QName, ElementDeclaration> globalElements;

    public MappingsGenerator(Helper helper) {
        this.helper = helper;
        this.jotArrayList = helper.getJavaClass(ArrayList.class);
        this.jotHashSet = helper.getJavaClass(HashSet.class);
        this.generatedClassesToQNames = new HashMap();
    }

    public Project generateProject(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap userDefinedSchemaTypes, HashMap<String, NamespaceInfo> packageToNamespaceMappings, HashMap<QName, ElementDeclaration> globalElements) throws Exception {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToNamespaceMappings = packageToNamespaceMappings;
        this.globalElements = globalElements;
        Project project = new Project();
        for (JavaClass next : typeInfoClasses) {
            if (next.isEnum()) continue;
            this.generateDescriptor(next, project);
        }
        this.generateMappings();
        this.processGlobalElements(project);
        return project;
    }

    public void generateDescriptor(JavaClass javaClass, Project project) {
        String namespace;
        String elementName;
        String jClassName = javaClass.getQualifiedName();
        TypeInfo info = this.typeInfo.get(jClassName);
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackage().getQualifiedName());
        String packageNamespace = namespaceInfo.getNamespace();
        XmlRootElement rootElem = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
        if (rootElem == null) {
            elementName = Introspector.decapitalize(jClassName.substring(jClassName.lastIndexOf(".") + 1));
            namespace = packageNamespace;
        } else {
            elementName = rootElem.name();
            if (elementName.equals("##default")) {
                elementName = Introspector.decapitalize(jClassName.substring(jClassName.lastIndexOf(".") + 1));
            }
            namespace = rootElem.namespace();
        }
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClassName(jClassName);
        if (namespace.equals("##default")) {
            namespace = namespaceInfo.getNamespace();
        }
        if (namespace.equals("")) {
            descriptor.setDefaultRootElement(elementName);
        } else {
            String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver());
            descriptor.setDefaultRootElement(prefix + ":" + elementName);
        }
        descriptor.setNamespaceResolver(namespaceInfo.getNamespaceResolver());
        project.addDescriptor(descriptor);
        info.setDescriptor(descriptor);
    }

    public void generateMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        if (property.getAdapterClass() != null) {
            JavaClass adapterClass = property.getAdapterClass();
            JavaClass valueType = this.helper.getJavaClass(Object.class);
            for (JavaMethod method : new ArrayList(adapterClass.getDeclaredMethods())) {
                JavaClass returnType;
                if (!method.getName().equals("marshal") || (returnType = method.getReturnType()).getQualifiedName().equals(valueType.getQualifiedName())) continue;
                valueType = returnType;
                break;
            }
            if (this.typeInfo.containsKey(valueType.getQualifiedName())) {
                if (this.isCollectionType(property)) {
                    this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, valueType).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                } else {
                    this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, valueType).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
                }
            } else if (this.isCollectionType(property)) {
                this.generateDirectCollectionMapping(property, descriptor, namespaceInfo).setValueConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, descriptor, namespaceInfo).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            } else {
                this.generateDirectMapping(property, descriptor, namespaceInfo).setConverter(new XMLJavaTypeConverter(adapterClass.getQualifiedName()));
            }
            return;
        }
        if (property.isChoice()) {
            if (this.isCollectionType(property)) {
                this.generateChoiceCollectionMapping(property, descriptor, namespaceInfo);
            } else {
                this.generateChoiceMapping(property, descriptor, namespaceInfo);
            }
        } else if (property.isAny()) {
            this.generateAnyCollectionMapping(property, descriptor, namespaceInfo);
        } else if (property.isReference()) {
            if (this.isCollectionType(property)) {
                this.generateCollectionMappingForReferenceProperty((ReferenceProperty)property, descriptor, namespaceInfo);
            } else {
                this.generateMappingForReferenceProperty((ReferenceProperty)property, descriptor, namespaceInfo);
            }
        } else if (this.isMapType(property) && this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
            this.generateAnyAttributeMapping(property, descriptor, namespaceInfo);
        } else if (this.isCollectionType(property)) {
            this.generateCollectionMapping(property, descriptor, namespaceInfo);
        } else {
            JavaClass referenceClass = property.getType();
            TypeInfo reference = this.typeInfo.get(referenceClass.getQualifiedName());
            if (reference != null) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    this.generateXMLObjectReferenceMapping(property, descriptor, namespaceInfo, referenceClass);
                } else if (reference.isEnumerationType()) {
                    this.generateDirectEnumerationMapping(property, descriptor, namespaceInfo, (EnumTypeInfo)reference);
                } else {
                    this.generateCompositeObjectMapping(property, descriptor, namespaceInfo, referenceClass);
                }
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, descriptor, namespaceInfo);
            } else {
                this.generateDirectMapping(property, descriptor, namespaceInfo);
            }
        }
    }

    public XMLChoiceObjectMapping generateChoiceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        ChoiceProperty prop = (ChoiceProperty)property;
        XMLChoiceObjectMapping mapping = new XMLChoiceObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        Iterator<Property> choiceProperties = prop.getChoiceProperties().iterator();
        while (choiceProperties.hasNext()) {
            Property next;
            JavaClass type = (next = choiceProperties.next()).getType();
            XMLField xpath = this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()));
            mapping.addChoiceElement(xpath.getName(), type.getQualifiedName(), false);
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLChoiceCollectionMapping generateChoiceCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespace) {
        JavaClass collectionType;
        ChoiceProperty prop = (ChoiceProperty)property;
        XMLChoiceCollectionMapping mapping = new XMLChoiceCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        if (this.areEquals(collectionType = property.getType(), Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        Iterator<Property> choiceProperties = prop.getChoiceProperties().iterator();
        while (choiceProperties.hasNext()) {
            Property next;
            JavaClass type = (next = choiceProperties.next()).getType();
            XMLField xpath = this.getXPathForField(next, namespace, !this.typeInfo.containsKey(type.getQualifiedName()));
            mapping.addChoiceElement(xpath.getName(), type.getQualifiedName());
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLMapping generateMappingForReferenceProperty(ReferenceProperty property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceObjectMapping mapping = new XMLChoiceObjectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        ArrayList<ElementDeclaration> referencedElements = property.getReferencedElements();
        boolean hasJAXBElements = false;
        AttributeAccessor mappingAccessor = mapping.getAttributeAccessor();
        for (ElementDeclaration element : referencedElements) {
            QName elementName = element.getElementName();
            XMLField xmlField = this.getXPathForElement("", elementName, namespaceInfo, !this.typeInfo.containsKey(element.getJavaTypeName()));
            mapping.addChoiceElement(xmlField, element.getJavaTypeName());
            if (!element.isXmlRootElement()) {
                XMLRootConverter converter = new XMLRootConverter(xmlField);
                mapping.addConverter(xmlField, converter);
            }
            if (!(hasJAXBElements = hasJAXBElements || !element.isXmlRootElement())) continue;
            mapping.setAttributeAccessor(new JAXBElementAttributeAccessor(mappingAccessor));
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLMapping generateCollectionMappingForReferenceProperty(ReferenceProperty property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceCollectionMapping mapping = new XMLChoiceCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        ArrayList<ElementDeclaration> referencedElements = property.getReferencedElements();
        boolean hasJAXBElements = false;
        AttributeAccessor mappingAccessor = mapping.getAttributeAccessor();
        for (ElementDeclaration element : referencedElements) {
            QName elementName = element.getElementName();
            XMLField xmlField = this.getXPathForElement("", elementName, namespaceInfo, !this.typeInfo.containsKey(element.getJavaTypeName()));
            mapping.addChoiceElement(xmlField, element.getJavaTypeName());
            if (!element.isXmlRootElement()) {
                XMLRootConverter converter = new XMLRootConverter(xmlField);
                mapping.addConverter(xmlField, converter);
            }
            hasJAXBElements = hasJAXBElements || !element.isXmlRootElement();
        }
        if (hasJAXBElements) {
            mapping.setAttributeAccessor(new JAXBElementAttributeAccessor(mappingAccessor, mapping.getContainerPolicy()));
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLAnyCollectionMapping generateAnyCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        AnyProperty prop = (AnyProperty)property;
        XMLAnyCollectionMapping mapping = new XMLAnyCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (prop.isLax()) {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            mapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        if (prop.getDomHandlerClass() != null) {
            DomHandlerConverter converter = new DomHandlerConverter(prop.getDomHandlerClass());
            mapping.setConverter(converter);
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLCompositeObjectMapping generateCompositeObjectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        mapping.setXPath(this.getXPathForField(property, namespaceInfo, false).getXPath());
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLDirectMapping generateDirectMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        mapping.setField(this.getXPathForField(property, namespaceInfo, true));
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLBinaryDataMapping generateBinaryMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        mapping.setField(this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            mapping.setSwaRef(true);
        } else if (property.isMtomAttachment()) {
            ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class)) {
            mapping.setShouldInlineBinaryData(true);
        }
        mapping.setMimeTypePolicy(new FixedMimeTypePolicy(property.getMimeType()));
        descriptor.addMapping(mapping);
        return mapping;
    }

    public void generateDirectEnumerationMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumInfo) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        JAXBEnumTypeConverter converter = new JAXBEnumTypeConverter(mapping, enumInfo.getClassName(), false);
        mapping.setConverter(converter);
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        mapping.setField(this.getXPathForField(property, namespaceInfo, true));
        HashMap<Object, String> enumValuesMap = enumInfo.getObjectValuesToFieldValues();
        for (Object o : enumValuesMap.keySet()) {
            String fieldValue = enumValuesMap.get(o);
            converter.addConversionValue(fieldValue, o);
        }
        descriptor.addMapping(mapping);
    }

    public void generateCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XmlElement xmlElement;
        JavaClass javaClass = null;
        if (property.getGenericType() != null) {
            javaClass = property.getGenericType();
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class) && (xmlElement = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).type() != XmlElement.DEFAULT.class) {
            javaClass = this.helper.getJavaClass(xmlElement.type());
        }
        if (javaClass != null && this.typeInfo.get(javaClass.getQualifiedName()) != null) {
            TypeInfo referenceInfo = this.typeInfo.get(javaClass.getQualifiedName());
            if (referenceInfo.isEnumerationType()) {
                this.generateEnumCollectionMapping(property, (EnumTypeInfo)referenceInfo, descriptor, namespaceInfo);
            } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                this.generateXMLCollectionReferenceMapping(property, descriptor, namespaceInfo, javaClass);
            } else {
                this.generateCompositeCollectionMapping(property, descriptor, namespaceInfo, javaClass);
            }
        } else {
            this.generateDirectCollectionMapping(property, descriptor, namespaceInfo);
        }
    }

    public void generateEnumCollectionMapping(Property property, EnumTypeInfo info, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        JAXBEnumTypeConverter converter = new JAXBEnumTypeConverter(mapping, info.getClassName(), false);
        HashMap<Object, String> enumValuesMap = info.getObjectValuesToFieldValues();
        for (Object o : enumValuesMap.keySet()) {
            String fieldValue = enumValuesMap.get(o);
            converter.addConversionValue(fieldValue, o);
        }
        mapping.setValueConverter(converter);
        JavaClass collectionType = property.getType();
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, true);
        mapping.setField(xmlField);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            mapping.setUsesSingleNode(true);
        }
        descriptor.addMapping(mapping);
    }

    public void generateAnyAttributeMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        XMLAnyAttributeMapping mapping = new XMLAnyAttributeMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        descriptor.addMapping(mapping);
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    public XMLCompositeCollectionMapping generateCompositeCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        JavaClass collectionType = property.getType();
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, false);
        mapping.setXPath(xmlField.getXPath());
        descriptor.addMapping(mapping);
        return mapping;
    }

    public XMLCompositeDirectCollectionMapping generateDirectCollectionMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        JavaClass collectionType;
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            mapping.setGetMethodName(property.getGetMethodName());
            mapping.setSetMethodName(property.getSetMethodName());
        }
        if (this.areEquals(collectionType = property.getType(), Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        XMLField xmlField = this.getXPathForField(property, namespaceInfo, true);
        mapping.setField(xmlField);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            mapping.setUsesSingleNode(true);
        }
        descriptor.addMapping(mapping);
        return mapping;
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver) {
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        String prefix = "ns" + this.nextNamespaceNumber;
        ++this.nextNamespaceNumber;
        namespaceResolver.put(prefix, URI2);
        return prefix;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    public void generateMappings() {
        for (String next : this.typeInfo.keySet()) {
            JavaClass javaClass = this.helper.getJavaClass(next);
            TypeInfo info = this.typeInfo.get(next);
            NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
            if (info.isEnumerationType()) continue;
            XMLDescriptor descriptor = info.getDescriptor();
            TypeInfo parentInfo = this.typeInfo.get(javaClass.getSuperclass().getQualifiedName());
            if (parentInfo != null) {
                this.generateMappings(parentInfo, descriptor, namespaceInfo);
            }
            this.generateMappings(info, descriptor, namespaceInfo);
        }
    }

    public void generateMappings(TypeInfo info, XMLDescriptor descriptor, NamespaceInfo namespaceInfo) {
        String[] propOrder = info.getPropOrder();
        if (propOrder.length == 0 || propOrder[0].equals("")) {
            ArrayList<String> propertyNames = info.getPropertyNames();
            for (int i = 0; i < propertyNames.size(); ++i) {
                String nextPropertyKey = propertyNames.get(i);
                Property next = info.getProperties().get(nextPropertyKey);
                this.generateMapping(next, descriptor, namespaceInfo);
            }
        } else {
            for (int i = 0; i < propOrder.length; ++i) {
                Property next = info.getProperties().get(propOrder[i]);
                if (next == null) continue;
                this.generateMapping(next, descriptor, namespaceInfo);
            }
        }
    }

    public void generateXMLCollectionReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLField srcXPath = this.getXPathForField(property, namespaceInfo, true);
        XMLCollectionReferenceMapping mapping = new XMLCollectionReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        JavaClass collectionType = property.getType();
        if (this.areEquals(collectionType, Collection.class) || this.areEquals(collectionType, List.class)) {
            collectionType = this.jotArrayList;
        } else if (this.areEquals(collectionType, Set.class)) {
            collectionType = this.jotHashSet;
        }
        mapping.useCollectionClassName(collectionType.getRawName());
        TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
        if (referenceType.isIDSet()) {
            Property prop;
            XMLField tgtXPath = this.getXPathForField(prop, namespaceInfo, !this.helper.isAnnotationPresent((prop = referenceType.getIDProperty()).getElement(), XmlAttribute.class));
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath.getXPath());
        }
        descriptor.addMapping(mapping);
    }

    public void generateXMLObjectReferenceMapping(Property property, XMLDescriptor descriptor, NamespaceInfo namespaceInfo, JavaClass referenceClass) {
        XMLField srcXPath = this.getXPathForField(property, namespaceInfo, true);
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        mapping.setAttributeName(property.getPropertyName());
        mapping.setReferenceClassName(referenceClass.getQualifiedName());
        TypeInfo referenceType = this.typeInfo.get(referenceClass.getQualifiedName());
        if (referenceType.isIDSet()) {
            Property prop;
            XMLField tgtXPath = this.getXPathForField(prop, namespaceInfo, !this.helper.isAnnotationPresent((prop = referenceType.getIDProperty()).getElement(), XmlAttribute.class));
            mapping.addSourceToTargetKeyFieldAssociation(srcXPath.getXPath(), tgtXPath.getXPath());
        }
        descriptor.addMapping(mapping);
    }

    public XMLField getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean isTextMapping) {
        QName schemaType;
        String namespace;
        String xPath = "";
        XMLField xmlField = null;
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
            XmlElementWrapper wrapper = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
            namespace = wrapper.namespace();
            if (namespace.equals("##default")) {
                namespace = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
            }
            xPath = namespace.equals("") ? xPath + wrapper.name() + "/" : xPath + this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver()) + ":" + wrapper.name() + "/";
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
            QName name = property.getSchemaName();
            namespace = "";
            if (namespaceInfo.isAttributeFormQualified()) {
                namespace = namespaceInfo.getNamespace();
            }
            if (!name.getNamespaceURI().equals("")) {
                namespace = name.getNamespaceURI();
            }
            if (namespace.equals("")) {
                xPath = xPath + "@" + name.getLocalPart();
            } else {
                String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver());
                xPath = xPath + "@" + prefix + ":" + name.getLocalPart();
            }
            QName schemaType2 = (QName)this.userDefinedSchemaTypes.get(property.getClass());
            if (property.getSchemaType() != null) {
                schemaType2 = property.getSchemaType();
            }
            if (schemaType2 == null) {
                schemaType2 = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType().getRawName());
            }
            XMLField field = new XMLField(xPath);
            field.setSchemaType(schemaType2);
            return field;
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            xPath = "text()";
            XMLField field = new XMLField(xPath);
            schemaType = (QName)this.userDefinedSchemaTypes.get(property.getType());
            if (property.getSchemaType() != null) {
                schemaType = property.getSchemaType();
            }
            if (schemaType == null) {
                schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
            }
            field.setSchemaType(schemaType);
            return field;
        }
        QName elementName = property.getSchemaName();
        xmlField = this.getXPathForElement(xPath, elementName, namespaceInfo, isTextMapping);
        schemaType = (QName)this.userDefinedSchemaTypes.get(property.getType());
        if (property.getSchemaType() != null) {
            schemaType = property.getSchemaType();
        }
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
        }
        xmlField.setSchemaType(schemaType);
        return xmlField;
    }

    public XMLField getXPathForElement(String path, QName elementName, NamespaceInfo namespaceInfo, boolean isText) {
        String namespace = "";
        if (namespaceInfo.isElementFormQualified()) {
            namespace = namespaceInfo.getNamespace();
        }
        if (!elementName.getNamespaceURI().equals("")) {
            namespace = elementName.getNamespaceURI();
        }
        if (namespace.equals("")) {
            path = path + elementName.getLocalPart();
            if (isText) {
                path = path + "/text()";
            }
        } else {
            String prefix = this.getPrefixForNamespace(namespace, namespaceInfo.getNamespaceResolver());
            path = path + prefix + ":" + elementName.getLocalPart();
            if (isText) {
                path = path + "/text()";
            }
        }
        XMLField xmlField = new XMLField(path);
        return xmlField;
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> properties) {
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlValue.class)) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlAnyAttribute.class)) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass cls, TypeInfo info) {
        if (info.getAccessType() == XmlAccessType.FIELD) {
            return this.getFieldPropertiesForClass(cls, info, false);
        }
        if (info.getAccessType() == XmlAccessType.PROPERTY) {
            return this.getPropertyPropertiesForClass(cls, info, false);
        }
        if (info.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            return this.getPublicMemberPropertiesForClass(cls, info);
        }
        return this.getNoAccessTypePropertiesForClass(cls, info);
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (JavaField nextField : new ArrayList(cls.getDeclaredFields())) {
            if (this.helper.isAnnotationPresent(nextField, XmlTransient.class) || (!Modifier.isPublic(nextField.getModifiers()) || !onlyPublic) && onlyPublic) continue;
            Property property = new Property();
            property.setPropertyName(nextField.getName());
            property.setElement(nextField);
            property.setType(this.helper.getType(nextField));
            property.setGenericType(this.helper.getGenericType(nextField));
            properties.add(property);
        }
        return properties;
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<JavaMethod> getMethods = new ArrayList<JavaMethod>();
        for (JavaMethod next : new ArrayList(cls.getDeclaredMethods())) {
            if (!next.getName().startsWith("get") && (!this.areEquals(next.getReturnType(), Boolean.class) && !this.areEquals(next.getReturnType(), Boolean.TYPE) || !next.getName().startsWith("is")) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
            getMethods.add(next);
        }
        for (JavaMethod getMethod : new ArrayList(cls.getDeclaredMethods())) {
            String propertyName = "";
            if (getMethod.getName().startsWith("get")) {
                propertyName = getMethod.getName().substring(3);
            } else if (getMethod.getName().startsWith("is")) {
                propertyName = getMethod.getName().substring(2);
            }
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            Property property = new Property(this.helper);
            property.setPropertyName(propertyName);
            property.setType(getMethod.getReturnType());
            property.setGenericType(this.helper.getGenericReturnType(getMethod));
            String setMethodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            JavaClass[] paramTypes = new JavaClass[]{getMethod.getReturnType()};
            JavaMethod setMethod = cls.getMethod(setMethodName, paramTypes);
            if (setMethod != null && !setMethod.getAnnotations().isEmpty()) {
                property.setElement(setMethod);
            } else if (!this.helper.isAnnotationPresent(getMethod, XmlTransient.class)) {
                property.setElement(getMethod);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) continue;
            properties.add(property);
        }
        return properties;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> publicFieldProperties = this.getFieldPropertiesForClass(cls, info, true);
        ArrayList<Property> publicMethodProperties = this.getPropertyPropertiesForClass(cls, info, true);
        if (publicFieldProperties.size() >= 0 && publicMethodProperties.size() == 0) {
            return publicFieldProperties;
        }
        if (publicMethodProperties.size() > 0 && publicFieldProperties.size() == 0) {
            return publicMethodProperties;
        }
        HashMap fieldPropertyMap = this.getPropertyMapFromArrayList(publicFieldProperties);
        for (int i = 0; i < publicMethodProperties.size(); ++i) {
            Property next = publicMethodProperties.get(i);
            if (fieldPropertyMap.get(next.getPropertyName()) != null) continue;
            publicFieldProperties.add(next);
        }
        return publicFieldProperties;
    }

    public HashMap getPropertyMapFromArrayList(ArrayList<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>(props.size());
        for (Property next : props) {
            propMap.put(next.getPropertyName(), next);
        }
        return propMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass cls, TypeInfo info) {
        JavaHasAnnotations elem;
        Property next;
        int i;
        ArrayList<Property> list = new ArrayList<Property>();
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        for (i = 0; i < fieldProperties.size(); ++i) {
            next = fieldProperties.get(i);
            elem = next.getElement();
            if (!this.helper.isAnnotationPresent(elem, XmlElement.class) && !this.helper.isAnnotationPresent(elem, XmlAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlAnyAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlAnyElement.class) && !this.helper.isAnnotationPresent(elem, XmlValue.class)) continue;
            list.add(next);
        }
        for (i = 0; i < methodProperties.size(); ++i) {
            next = methodProperties.get(i);
            elem = next.getElement();
            if (!this.helper.isAnnotationPresent(elem, XmlElement.class) && !this.helper.isAnnotationPresent(elem, XmlAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlAnyAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlAnyElement.class) && !this.helper.isAnnotationPresent(elem, XmlValue.class)) continue;
            list.add(next);
        }
        return list;
    }

    public void processSchemaType(XmlSchemaType type) {
        String schemaTypeName = type.name();
        Class javaType = type.type();
        if (javaType == null) {
            return;
        }
        QName typeQName = new QName("http://www.w3.org/2001/XMLSchema-instance", schemaTypeName);
        this.userDefinedSchemaTypes.put(javaType, typeQName);
    }

    public ArrayList getEnumerationFacetsFor(EnumTypeInfo info) {
        Collection<String> valuesCollection = info.getObjectValuesToFieldValues().values();
        return new ArrayList<String>(valuesCollection);
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = Introspector.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        return typeName;
    }

    public boolean isMapType(Property property) {
        JavaClass mapCls = this.helper.getJavaClass(Map.class);
        return mapCls.isAssignableFrom(property.getType());
    }

    public void processGlobalElements(Project project) {
        if (this.globalElements == null) {
            return;
        }
        for (QName next : this.globalElements.keySet()) {
            String prefix;
            NamespaceResolver resolver2;
            ElementDeclaration nextElement = this.globalElements.get(next);
            String nextClassName = nextElement.getJavaTypeName();
            TypeInfo type = this.typeInfo.get(nextClassName);
            if (type != null) {
                if (next.getNamespaceURI() == null || next.getNamespaceURI().equals("")) {
                    type.getDescriptor().addRootElement(next.getLocalPart());
                    continue;
                }
                XMLDescriptor descriptor = type.getDescriptor();
                String uri = next.getNamespaceURI();
                String prefix2 = descriptor.getNamespaceResolver().resolveNamespaceURI(uri);
                if (prefix2 == null) {
                    prefix2 = descriptor.getNamespaceResolver().generatePrefix();
                    descriptor.getNamespaceResolver().put(prefix2, uri);
                }
                descriptor.addRootElement(prefix2 + ":" + next.getLocalPart());
                continue;
            }
            if (!this.helper.isBuiltInJavaType(this.helper.getJavaClass(nextClassName))) continue;
            String namespaceUri = next.getNamespaceURI();
            if (namespaceUri == null || namespaceUri.equals("##default")) {
                namespaceUri = "";
            }
            Class generatedClass = this.generateWrapperClass(WRAPPER_CLASS + wrapperCounter++, nextClassName);
            this.generatedClassesToQNames.put(generatedClass, next);
            XMLDescriptor desc = new XMLDescriptor();
            desc.setJavaClass(generatedClass);
            XMLDirectMapping mapping = new XMLDirectMapping();
            mapping.setAttributeName("value");
            mapping.setXPath("text()");
            if (nextClassName.equals("[B") || nextClassName.equals("[Ljava.lang.Byte;")) {
                ((XMLField)mapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            desc.addMapping(mapping);
            NamespaceInfo info = this.getNamespaceInfoForURI(namespaceUri);
            if (info != null) {
                resolver2 = info.getNamespaceResolver();
                prefix = resolver2.resolveNamespaceURI(namespaceUri);
                desc.setNamespaceResolver(resolver2);
                desc.setDefaultRootElement(prefix + ":" + next.getLocalPart());
            } else if (namespaceUri.equals("")) {
                desc.setDefaultRootElement(next.getLocalPart());
            } else {
                resolver2 = new NamespaceResolver();
                prefix = resolver2.generatePrefix();
                resolver2.put(prefix, namespaceUri);
                desc.setNamespaceResolver(resolver2);
                desc.setDefaultRootElement(prefix + ":" + next.getLocalPart());
            }
            project.addDescriptor(desc);
        }
    }

    private NamespaceInfo getNamespaceInfoForURI(String namespaceUri) {
        for (NamespaceInfo next : this.packageToNamespaceMappings.values()) {
            if (!next.getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    private String getPackageNameForURI(String namespaceUri) {
        for (String next : this.packageToNamespaceMappings.keySet()) {
            if (!this.packageToNamespaceMappings.get(next).getNamespace().equals(namespaceUri)) continue;
            return next;
        }
        return null;
    }

    public HashMap<Class, QName> getGeneratedClassesToQName() {
        return this.generatedClassesToQNames;
    }

    public Class generateWrapperClass(String className, String attributeType) {
        ClassWriter classWriter = new ClassWriter(false);
        classWriter.visit(49, 1, className.replace(".", "/"), Type.getType(Object.class).getInternalName(), new String[]{Type.getType(WrappedValue.class).getInternalName()}, null);
        CodeVisitor mv = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getType(Object.class).getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        String fieldType = attributeType.replace(".", "/");
        if (!fieldType.startsWith("[")) {
            fieldType = "L" + fieldType + ";";
        }
        classWriter.visitField(1, "value", fieldType, null, null);
        Type objectType = Type.getType(Object.class);
        mv = classWriter.visitMethod(1, "getWrappedValue", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className.replace(".", "/"), "value", fieldType);
        mv.visitInsn(Type.getType(Object.class).getOpcode(172));
        mv.visitMaxs(1 + objectType.getSize(), 1);
        classWriter.visitEnd();
        byte[] classBytes = classWriter.toByteArray();
        JaxbClassLoader loader = (JaxbClassLoader)this.helper.getClassLoader();
        Class generatedClass = loader.generateClass(className, classBytes);
        return generatedClass;
    }
}

