/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLCollectionReferenceMapping
extends XMLObjectReferenceMapping
implements ContainerMapping {
    protected ContainerPolicy containerPolicy;
    private static final String SPACE = " ";
    private boolean usesSingleNode;

    public XMLCollectionReferenceMapping() {
        this.sourceToTargetKeyFieldAssociations = new HashMap();
        this.sourceToTargetKeys = new Vector();
        this.containerPolicy = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
        this.usesSingleNode = false;
    }

    public Object buildFieldValue(Object targetObject, XMLField xmlFld, AbstractSession session) {
        if (targetObject == null || this.getReferenceClass() == null) {
            return null;
        }
        ClassDescriptor descriptor = this.getReferenceDescriptor();
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Vector pks = objectBuilder.extractPrimaryKeyFromObject(targetObject, session);
        XMLField tgtXMLField = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xmlFld);
        int idx = descriptor.getPrimaryKeyFields().indexOf(tgtXMLField);
        if (idx == -1) {
            return null;
        }
        return pks.get(idx);
    }

    public void buildReference(UnmarshalRecord record, XMLField xmlField, Object object, AbstractSession session) {
        Vector pks;
        ReferenceResolver resolver2 = ReferenceResolver.getInstance(session);
        if (resolver2 == null) {
            return;
        }
        Object srcObject = record.getCurrentObject();
        Reference reference = resolver2.getReference(this, srcObject);
        if (reference == null) {
            reference = new Reference((XMLMapping)this, srcObject, this.getReferenceClass(), new HashMap());
            resolver2.addReference(reference);
        }
        XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xmlField);
        String tgtXPath = tgtFld.getXPath();
        HashMap primaryKeyMap = reference.getPrimaryKeyMap();
        if (primaryKeyMap.containsKey(tgtXPath)) {
            pks = (Vector)primaryKeyMap.get(tgtXPath);
        } else {
            pks = new Vector();
            primaryKeyMap.put(tgtXPath, pks);
        }
        ClassDescriptor descriptor = session.getClassDescriptor(this.getReferenceClass());
        Class type = descriptor.getTypedField(tgtFld).getType();
        XMLConversionManager xmlConversionManager = (XMLConversionManager)session.getDatasourcePlatform().getConversionManager();
        StringTokenizer stok = new StringTokenizer((String)object);
        while (stok.hasMoreTokens()) {
            Object value = xmlConversionManager.convertObject(stok.nextToken(), type);
            if (value == null) continue;
            pks.add(value);
        }
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp != null && cp.getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
            cp.setContainerClass(cls);
        }
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ClassDescriptor descriptor = sourceQuery.getSession().getClassDescriptor(this.getReferenceClass());
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<String> pkFieldNames = this.referenceDescriptor.getPrimaryKeyFieldNames();
        Vector primaryKeyValues = new Vector();
        primaryKeyValues.setSize(pkFieldNames.size());
        HashMap primaryKeyMap = new HashMap();
        for (XMLField fld : this.getFields()) {
            XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(fld);
            Object fieldValue = databaseRow.getValues(fld);
            if (fieldValue == null || fieldValue instanceof String || !(fieldValue instanceof Vector)) {
                return cp.containerInstance();
            }
            XMLConversionManager xmlConversionManager = (XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager();
            Vector<Object> newValues = new Vector<Object>();
            Iterator valIt = ((Vector)fieldValue).iterator();
            while (valIt.hasNext()) {
                StringTokenizer stok = new StringTokenizer((String)valIt.next());
                while (stok.hasMoreTokens()) {
                    Object value = xmlConversionManager.convertObject(stok.nextToken(), descriptor.getTypedField(tgtFld).getType());
                    if (value == null) continue;
                    newValues.add(value);
                }
            }
            primaryKeyMap.put(tgtFld.getXPath(), newValues);
        }
        ReferenceResolver resolver2 = ReferenceResolver.getInstance(sourceQuery.getSession());
        if (resolver2 != null) {
            resolver2.addReference(new Reference((XMLMapping)this, targetObject, this.referenceClass, primaryKeyMap));
        }
        return null;
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        if (this.containerPolicy instanceof MapContainerPolicy) {
            ((MapContainerPolicy)this.containerPolicy).setElementClass(this.getReferenceClass());
        }
    }

    public void useCollectionClass(Class concreteContainerClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteContainerClass));
    }

    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    public void useMapClass(Class concreteContainerClass, String methodName) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteContainerClass);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }

    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    public void setUsesSingleNode(boolean useSingleNode) {
        this.usesSingleNode = useSingleNode;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        for (XMLField xmlField : this.getFields()) {
            QName schemaType;
            Object fieldValue;
            Object objectValue;
            ContainerPolicy cp = this.getContainerPolicy();
            Object collection = this.getAttributeAccessor().getAttributeValueFromObject(object);
            if (collection == null) {
                return;
            }
            String stringValue = "";
            Object iterator = cp.iteratorFor(collection);
            if (this.usesSingleNode()) {
                while (cp.hasNext(iterator)) {
                    String newValue;
                    objectValue = cp.next(iterator, session);
                    fieldValue = this.buildFieldValue(objectValue, xmlField, session);
                    if (fieldValue == null || (newValue = this.getValueToWrite(schemaType = this.getSchemaType(xmlField, fieldValue, session), fieldValue, session)) == null) continue;
                    stringValue = stringValue + newValue;
                    if (!cp.hasNext(iterator)) continue;
                    stringValue = stringValue + SPACE;
                }
                if (stringValue.equals("")) continue;
                row.put(xmlField, (Object)stringValue);
                continue;
            }
            ArrayList<String> keyValues = new ArrayList<String>();
            while (cp.hasNext(iterator)) {
                objectValue = cp.next(iterator, session);
                fieldValue = this.buildFieldValue(objectValue, xmlField, session);
                if (fieldValue == null) continue;
                schemaType = this.getSchemaType(xmlField, fieldValue, session);
                stringValue = this.getValueToWrite(schemaType, fieldValue, session);
                keyValues.add(stringValue);
            }
            row.put(xmlField, (Object)keyValues);
        }
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        for (XMLField xmlField : this.getFields()) {
            Object fieldValue = this.buildFieldValue(value, xmlField, session);
            if (fieldValue == null) continue;
            QName schemaType = this.getSchemaType(xmlField, fieldValue, session);
            String stringValue = this.getValueToWrite(schemaType, fieldValue, session);
            row.add(xmlField, stringValue);
        }
    }
}

