/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class ConstructorReportItem
extends ReportItem {
    protected Class[] constructorArgTypes;
    protected List constructorMappings;
    protected List reportItems;
    protected Constructor constructor;

    public ConstructorReportItem() {
    }

    public ConstructorReportItem(String name) {
        super(name, null);
    }

    public void addAttribute(Expression attributeExpression) {
        ReportItem item = new ReportItem(this.getName() + this.getReportItems().size(), attributeExpression);
        this.getReportItems().add(item);
    }

    public void addAttribute(String attributeName, Expression attributeExpression, List joinedExpressions) {
        ReportItem item = new ReportItem(attributeName, attributeExpression);
        item.getJoinedAttributeManager().setJoinedAttributeExpressions_(joinedExpressions);
        this.getReportItems().add(item);
    }

    public void addItem(ReportItem item) {
        this.getReportItems().add(item);
    }

    public Class[] getConstructorArgTypes() {
        return this.constructorArgTypes;
    }

    public List getConstructorMappings() {
        return this.constructorMappings;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public List getReportItems() {
        if (this.reportItems == null) {
            this.reportItems = new ArrayList();
        }
        return this.reportItems;
    }

    public void initialize(ReportQuery query) throws QueryException {
        int size = this.getReportItems().size();
        ArrayList<DatabaseMapping> mappings = new ArrayList<DatabaseMapping>();
        for (int index = 0; index < size; ++index) {
            ReportItem item = (ReportItem)this.reportItems.get(index);
            item.initialize(query);
            mappings.add(item.getMapping());
        }
        this.setConstructorMappings(mappings);
        int numberOfItems = this.getReportItems().size();
        if (this.getConstructorArgTypes() == null) {
            this.setConstructorArgTypes(new Class[numberOfItems]);
        }
        Class[] constructorArgTypes = this.getConstructorArgTypes();
        for (int index = 0; index < numberOfItems; ++index) {
            if (constructorArgTypes[index] != null) continue;
            ReportItem argumentItem = (ReportItem)this.getReportItems().get(index);
            constructorArgTypes[index] = mappings.get(index) != null ? ((DatabaseMapping)this.constructorMappings.get(index)).getAttributeClassification() : (argumentItem.getResultType() != null ? argumentItem.getResultType() : (argumentItem.getDescriptor() != null ? argumentItem.getDescriptor().getJavaClass() : ClassConstants.OBJECT));
        }
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getResultType(), constructorArgTypes, true));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(exception.getException(), query);
                }
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getResultType(), constructorArgTypes, true);
            }
            this.setConstructor(constructor);
        }
        catch (NoSuchMethodException exception) {
            throw QueryException.exceptionWhileUsingConstructorExpression(exception, query);
        }
    }

    public boolean isConstructorItem() {
        return true;
    }

    public void setConstructorArgTypes(Class[] constructorArgTypes) {
        this.constructorArgTypes = constructorArgTypes;
    }

    public void setConstructorMappings(List constructorMappings) {
        this.constructorMappings = constructorMappings;
    }

    public void setReportItems(List reportItems) {
        this.reportItems = reportItems;
    }

    public String toString() {
        String string = "ConstructorReportItem(" + this.getName() + " -> [";
        if (this.reportItems != null) {
            int size = this.reportItems.size();
            for (int i = 0; i < size; ++i) {
                string = string + this.reportItems.get(i).toString();
            }
        }
        return string + "])";
    }
}

