/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.AbstractTransactionController;
import org.eclipse.persistence.transaction.JTASynchronizationListener;

public class JTATransactionController
extends AbstractTransactionController {
    protected TransactionManager transactionManager;
    static String[] codes = new String[]{"STATUS_ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};

    public JTATransactionController() {
        this.listenerFactory = new JTASynchronizationListener();
        try {
            this.transactionManager = this.acquireTransactionManager();
        }
        catch (Exception ex) {
            throw TransactionException.errorObtainingTransactionManager(ex);
        }
    }

    protected void registerSynchronization_impl(AbstractSynchronizationListener listener, Object txn) throws Exception {
        ((Transaction)txn).registerSynchronization((Synchronization)((Object)listener));
    }

    protected Object getTransaction_impl() throws Exception {
        return this.getTransactionManager().getTransaction();
    }

    protected Object getTransactionKey_impl(Object transaction) throws Exception {
        return transaction;
    }

    protected Object getTransactionStatus_impl() throws Exception {
        return new Integer(this.getTransactionManager().getStatus());
    }

    protected void beginTransaction_impl() throws Exception {
        this.getTransactionManager().begin();
    }

    protected void commitTransaction_impl() throws Exception {
        this.getTransactionManager().commit();
    }

    protected void rollbackTransaction_impl() throws Exception {
        this.getTransactionManager().rollback();
    }

    protected void markTransactionForRollback_impl() throws Exception {
        this.getTransactionManager().setRollbackOnly();
    }

    protected boolean canBeginTransaction_impl(Object status) {
        return this.getIntStatus(status) == 6;
    }

    protected boolean canCommitTransaction_impl(Object status) {
        return this.getIntStatus(status) == 0;
    }

    protected boolean canRollbackTransaction_impl(Object status) {
        return this.getIntStatus(status) == 0;
    }

    protected boolean canIssueSQLToDatabase_impl(Object status) {
        int stat = this.getIntStatus(status);
        return stat == 0 || stat == 7;
    }

    protected boolean canMergeUnitOfWork_impl(Object status) {
        return this.getIntStatus(status) == 3;
    }

    public boolean isRolledBack_impl(Object status) {
        return this.getIntStatus(status) == 4;
    }

    protected TransactionManager acquireTransactionManager() throws Exception {
        return null;
    }

    protected int getIntStatus(Object status) {
        return (Integer)status;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager mgr) {
        this.transactionManager = mgr;
    }

    protected String statusToString_impl(Object status) {
        int statusCode = this.getIntStatus(status);
        return codes[statusCode];
    }
}

