/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.String2FieldBridgeAdaptor;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.BigDecimalBridge;
import org.hibernate.search.bridge.builtin.BigIntegerBridge;
import org.hibernate.search.bridge.builtin.BooleanBridge;
import org.hibernate.search.bridge.builtin.ClassBridge;
import org.hibernate.search.bridge.builtin.DateBridge;
import org.hibernate.search.bridge.builtin.DoubleBridge;
import org.hibernate.search.bridge.builtin.EnumBridge;
import org.hibernate.search.bridge.builtin.FloatBridge;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.bridge.builtin.ShortBridge;
import org.hibernate.search.bridge.builtin.UriBridge;
import org.hibernate.search.bridge.builtin.UrlBridge;

public class BridgeFactory {
    private static Map<String, FieldBridge> builtInBridges = new HashMap<String, FieldBridge>();
    public static final TwoWayFieldBridge DOUBLE = new TwoWayString2FieldBridgeAdaptor(new DoubleBridge());
    public static final TwoWayFieldBridge FLOAT = new TwoWayString2FieldBridgeAdaptor(new FloatBridge());
    public static final TwoWayFieldBridge SHORT = new TwoWayString2FieldBridgeAdaptor(new ShortBridge());
    public static final TwoWayFieldBridge INTEGER = new TwoWayString2FieldBridgeAdaptor(new IntegerBridge());
    public static final TwoWayFieldBridge LONG = new TwoWayString2FieldBridgeAdaptor(new LongBridge());
    public static final TwoWayFieldBridge BIG_INTEGER = new TwoWayString2FieldBridgeAdaptor(new BigIntegerBridge());
    public static final TwoWayFieldBridge BIG_DECIMAL = new TwoWayString2FieldBridgeAdaptor(new BigDecimalBridge());
    public static final TwoWayFieldBridge STRING = new TwoWayString2FieldBridgeAdaptor(new org.hibernate.search.bridge.builtin.StringBridge());
    public static final TwoWayFieldBridge BOOLEAN = new TwoWayString2FieldBridgeAdaptor(new BooleanBridge());
    public static final TwoWayFieldBridge CLAZZ = new TwoWayString2FieldBridgeAdaptor(new ClassBridge());
    public static final TwoWayFieldBridge Url = new TwoWayString2FieldBridgeAdaptor(new UrlBridge());
    public static final TwoWayFieldBridge Uri = new TwoWayString2FieldBridgeAdaptor(new UriBridge());
    public static final FieldBridge DATE_YEAR = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_YEAR);
    public static final FieldBridge DATE_MONTH = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_MONTH);
    public static final FieldBridge DATE_DAY = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_DAY);
    public static final FieldBridge DATE_HOUR = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_HOUR);
    public static final FieldBridge DATE_MINUTE = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_MINUTE);
    public static final FieldBridge DATE_SECOND = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_SECOND);
    public static final TwoWayFieldBridge DATE_MILLISECOND = new TwoWayString2FieldBridgeAdaptor(DateBridge.DATE_MILLISECOND);

    private BridgeFactory() {
    }

    public static FieldBridge extractType(org.hibernate.search.annotations.ClassBridge cb) {
        Class impl;
        FieldBridge bridge = null;
        if (cb != null && (impl = cb.impl()) != null) {
            try {
                Object instance = impl.newInstance();
                if (FieldBridge.class.isAssignableFrom(impl)) {
                    bridge = (FieldBridge)instance;
                } else if (TwoWayStringBridge.class.isAssignableFrom(impl)) {
                    bridge = new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)instance);
                } else if (StringBridge.class.isAssignableFrom(impl)) {
                    bridge = new String2FieldBridgeAdaptor((StringBridge)instance);
                } else {
                    throw new SearchException("@ClassBridge implementation implements none of the field bridge interfaces: " + impl);
                }
                if (cb.params().length > 0 && ParameterizedBridge.class.isAssignableFrom(impl)) {
                    HashMap<String, String> params = new HashMap<String, String>(cb.params().length);
                    for (Parameter param : cb.params()) {
                        params.put(param.name(), param.value());
                    }
                    ((ParameterizedBridge)instance).setParameterValues(params);
                }
            }
            catch (Exception e) {
                throw new HibernateException("Unable to instantiate FieldBridge for " + org.hibernate.search.annotations.ClassBridge.class.getName(), e);
            }
        }
        if (bridge == null) {
            throw new SearchException("Unable to guess FieldBridge for " + org.hibernate.search.annotations.ClassBridge.class.getName());
        }
        return bridge;
    }

    public static FieldBridge guessType(Field field, XMember member, ReflectionManager reflectionManager) {
        FieldBridge bridge;
        org.hibernate.search.annotations.FieldBridge bridgeAnn = field != null && Void.TYPE != field.bridge().impl() ? field.bridge() : member.getAnnotation(org.hibernate.search.annotations.FieldBridge.class);
        String memberName = member.getName();
        if (bridgeAnn != null) {
            bridge = BridgeFactory.doExtractType(bridgeAnn, memberName);
        } else if (member.isAnnotationPresent(org.hibernate.search.annotations.DateBridge.class)) {
            Resolution resolution = member.getAnnotation(org.hibernate.search.annotations.DateBridge.class).resolution();
            bridge = BridgeFactory.getDateField(resolution);
        } else {
            XClass returnType = member.getType();
            bridge = builtInBridges.get(returnType.getName());
            if (bridge == null && returnType.isEnum()) {
                bridge = new TwoWayString2FieldBridgeAdaptor(new EnumBridge(reflectionManager.toClass(returnType)));
            }
        }
        if (bridge == null) {
            throw new SearchException("Unable to guess FieldBridge for " + memberName);
        }
        return bridge;
    }

    private static FieldBridge doExtractType(org.hibernate.search.annotations.FieldBridge bridgeAnn, String memberName) {
        FieldBridge bridge;
        assert (bridgeAnn != null) : "doExtractType assume bridge instance not null";
        Class impl = bridgeAnn.impl();
        if (impl == Void.TYPE) {
            throw new SearchException("@FieldBridge with no implementation class defined in: " + memberName);
        }
        try {
            Object instance = impl.newInstance();
            if (FieldBridge.class.isAssignableFrom(impl)) {
                bridge = (FieldBridge)instance;
            } else if (TwoWayStringBridge.class.isAssignableFrom(impl)) {
                bridge = new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)instance);
            } else if (StringBridge.class.isAssignableFrom(impl)) {
                bridge = new String2FieldBridgeAdaptor((StringBridge)instance);
            } else {
                throw new SearchException("@FieldBridge implementation implements none of the field bridge interfaces: " + impl + " in " + memberName);
            }
            if (bridgeAnn.params().length > 0 && ParameterizedBridge.class.isAssignableFrom(impl)) {
                HashMap<String, String> params = new HashMap<String, String>(bridgeAnn.params().length);
                for (Parameter param : bridgeAnn.params()) {
                    params.put(param.name(), param.value());
                }
                ((ParameterizedBridge)instance).setParameterValues(params);
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to instanciate FieldBridge for " + memberName, e);
        }
        return bridge;
    }

    public static FieldBridge getDateField(Resolution resolution) {
        switch (resolution) {
            case YEAR: {
                return DATE_YEAR;
            }
            case MONTH: {
                return DATE_MONTH;
            }
            case DAY: {
                return DATE_DAY;
            }
            case HOUR: {
                return DATE_HOUR;
            }
            case MINUTE: {
                return DATE_MINUTE;
            }
            case SECOND: {
                return DATE_SECOND;
            }
            case MILLISECOND: {
                return DATE_MILLISECOND;
            }
        }
        throw new AssertionFailure("Unknown Resolution: " + (Object)((Object)resolution));
    }

    public static TwoWayFieldBridge extractTwoWayType(org.hibernate.search.annotations.FieldBridge fieldBridge) {
        FieldBridge fb = BridgeFactory.extractType(fieldBridge);
        if (fb instanceof TwoWayFieldBridge) {
            return (TwoWayFieldBridge)fb;
        }
        throw new SearchException("FieldBridge passed in is not an instance of " + TwoWayFieldBridge.class.getSimpleName());
    }

    public static FieldBridge extractType(org.hibernate.search.annotations.FieldBridge fieldBridgeAnnotation) {
        FieldBridge bridge = null;
        if (fieldBridgeAnnotation != null) {
            bridge = BridgeFactory.doExtractType(fieldBridgeAnnotation, null);
        }
        if (bridge == null) {
            throw new SearchException("Unable to guess FieldBridge for " + org.hibernate.search.annotations.FieldBridge.class.getName());
        }
        return bridge;
    }

    static {
        builtInBridges.put(Double.class.getName(), DOUBLE);
        builtInBridges.put(Double.TYPE.getName(), DOUBLE);
        builtInBridges.put(Float.class.getName(), FLOAT);
        builtInBridges.put(Float.TYPE.getName(), FLOAT);
        builtInBridges.put(Short.class.getName(), SHORT);
        builtInBridges.put(Short.TYPE.getName(), SHORT);
        builtInBridges.put(Integer.class.getName(), INTEGER);
        builtInBridges.put(Integer.TYPE.getName(), INTEGER);
        builtInBridges.put(Long.class.getName(), LONG);
        builtInBridges.put(Long.TYPE.getName(), LONG);
        builtInBridges.put(BigInteger.class.getName(), BIG_INTEGER);
        builtInBridges.put(BigDecimal.class.getName(), BIG_DECIMAL);
        builtInBridges.put(String.class.getName(), STRING);
        builtInBridges.put(Boolean.class.getName(), BOOLEAN);
        builtInBridges.put(Boolean.TYPE.getName(), BOOLEAN);
        builtInBridges.put(Class.class.getName(), CLAZZ);
        builtInBridges.put(URL.class.getName(), Url);
        builtInBridges.put(URI.class.getName(), Uri);
        builtInBridges.put(Date.class.getName(), DATE_MILLISECOND);
    }
}

