/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class View
extends Table {
    Select viewSelect;
    SubQuery viewSubQuery;
    private String statement;
    private HsqlNameManager.HsqlName[] colList;
    HsqlNameManager.HsqlName compileTimeSchema;
    SubQuery[] viewSubqueries;

    View(Session session, Database database, HsqlNameManager.HsqlName hsqlName, String string, HsqlNameManager.HsqlName[] hsqlNameArray) throws HsqlException {
        super(database, hsqlName, 7);
        this.isReadOnly = true;
        this.colList = hsqlNameArray;
        this.statement = View.trimStatement(string);
        this.compileTimeSchema = session.getSchemaHsqlName(null);
        this.compile(session);
        HsqlNameManager.HsqlName[] hsqlNameArray2 = this.getSchemas();
        for (int i = 0; i < hsqlNameArray2.length; ++i) {
            if (database.schemaManager.isSystemSchema(hsqlNameArray2[i]) || hsqlNameArray2[i].equals(hsqlName.schema)) continue;
            throw Trace.error(227);
        }
    }

    static String trimStatement(String string) throws HsqlException {
        int n;
        String string2;
        Tokenizer tokenizer = new Tokenizer(string);
        do {
            n = tokenizer.getPosition();
        } while ((string2 = tokenizer.getString()).length() != 0 || tokenizer.wasValue());
        return string.substring(0, n).trim();
    }

    void compile(Session session) throws HsqlException {
        Parser parser2 = new Parser(session, this.database, new Tokenizer(this.statement));
        int n = parser2.parseOpenBracketsSelect();
        this.viewSubQuery = parser2.parseSubquery(n, this.colList, true, 115);
        parser2.setAsView(this);
        this.viewSubqueries = parser2.getSortedSubqueries();
        this.viewSelect = this.viewSubQuery.select;
        this.viewSelect.prepareResult(session);
        Result.ResultMetaData resultMetaData = this.viewSelect.resultMetaData;
        int n2 = this.viewSelect.iResultLen;
        if (this.columnCount == 0) {
            super.addColumns(resultMetaData, n2);
        }
    }

    String getStatement() {
        return this.statement;
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        throw Trace.error(55);
    }

    HsqlNameManager.HsqlName[] getSchemas() {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            Select select = this.viewSubqueries[i].select;
            while (select != null) {
                TableFilter[] tableFilterArray = select.tFilter;
                for (int j = 0; j < tableFilterArray.length; ++j) {
                    hsqlArrayList.add(tableFilterArray[j].filterTable.tableName.schema);
                }
                select = select.unionSelect;
            }
        }
        return (HsqlNameManager.HsqlName[])hsqlArrayList.toArray(new HsqlNameManager.HsqlName[hsqlArrayList.size()]);
    }

    boolean hasView(View view) {
        if (view == this) {
            return false;
        }
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            if (this.viewSubqueries[i].view != view) continue;
            return true;
        }
        return false;
    }

    boolean hasTable(Table table) {
        for (int i = 0; i < this.viewSubqueries.length; ++i) {
            Select select = this.viewSubqueries[i].select;
            while (select != null) {
                TableFilter[] tableFilterArray = select.tFilter;
                for (int j = 0; j < tableFilterArray.length; ++j) {
                    if (!table.equals(tableFilterArray[j].filterTable.tableName)) continue;
                    return true;
                }
                select = select.unionSelect;
            }
        }
        return false;
    }

    boolean hasColumn(Table table, String string) {
        if (this.hasTable(table)) {
            Expression.Collector collector = new Expression.Collector();
            collector.addAll(this.viewSubqueries[this.viewSubqueries.length - 1].select, 2);
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (!string.equals(expression.getBaseColumnName()) || !table.equals(expression.getTableHsqlName())) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasSequence(NumberSequence numberSequence) {
        Expression.Collector collector = new Expression.Collector();
        collector.addAll(this.viewSubqueries[this.viewSubqueries.length - 1].select, 71);
        Iterator iterator = collector.iterator();
        while (iterator.hasNext()) {
            Expression expression = (Expression)iterator.next();
            if (expression.valueData != numberSequence) continue;
            return true;
        }
        return false;
    }
}

