/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.OutboundProducer;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundPublisher
extends OutboundProducer
implements TopicPublisher {
    OutboundPublisher(MessageProducer producer, OutboundSession session) {
        super(producer, session);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundPublisher(" + producer + ", " + session + ")"));
        }
    }

    public Topic getTopic() throws JMSException {
        this.checkValidity();
        return (Topic)this.producer.getDestination();
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " publish(" + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Message message) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " publish(" + message + ")"));
        }
        this.checkValidity();
        this.producer.send(message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " publish(" + topic + ", " + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send(topic, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " publish(" + topic + ", " + message + ")"));
        }
        this.checkValidity();
        this.producer.send(topic, message);
    }
}

