/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.XATopicConnectionFactory;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.XAConnectionFactory;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminMessage;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.JoramSaxWrapper;
import org.objectweb.joram.client.jms.admin.NameAlreadyUsedException;
import org.objectweb.joram.client.jms.admin.Server;
import org.objectweb.joram.client.jms.admin.ServerIdAlreadyUsedException;
import org.objectweb.joram.client.jms.admin.StartFailureException;
import org.objectweb.joram.client.jms.admin.UnknownServerException;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.ha.local.TopicHALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.TopicHATcpConnectionFactory;
import org.objectweb.joram.client.jms.local.TopicLocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.admin.AddDomainRequest;
import org.objectweb.joram.shared.admin.AddServerRequest;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.GetConfigRequest;
import org.objectweb.joram.shared.admin.GetDomainNames;
import org.objectweb.joram.shared.admin.GetDomainNamesRep;
import org.objectweb.joram.shared.admin.GetLocalServer;
import org.objectweb.joram.shared.admin.GetLocalServerRep;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettings;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettingsRep;
import org.objectweb.joram.shared.admin.Monitor_GetDestinations;
import org.objectweb.joram.shared.admin.Monitor_GetDestinationsRep;
import org.objectweb.joram.shared.admin.Monitor_GetServersIds;
import org.objectweb.joram.shared.admin.Monitor_GetServersIdsRep;
import org.objectweb.joram.shared.admin.Monitor_GetUsers;
import org.objectweb.joram.shared.admin.Monitor_GetUsersRep;
import org.objectweb.joram.shared.admin.RemoveDomainRequest;
import org.objectweb.joram.shared.admin.RemoveServerRequest;
import org.objectweb.joram.shared.admin.SetDefaultDMQ;
import org.objectweb.joram.shared.admin.SetDefaultThreshold;
import org.objectweb.joram.shared.admin.StopServerRequest;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;

public class AdminModule {
    public static final String ADM_NAME_PROPERTY = "JoramAdminXML";
    public static final String DEFAULT_ADM_NAME = "default";
    public static final String REQUEST_TIMEOUT_PROP = "org.objectweb.joram.client.jms.admin.requestTimeout";
    public static final long DEFAULT_REQUEST_TIMEOUT = 120000L;
    private static int localServer;
    protected static String localHost;
    protected static int localPort;
    private static TopicConnection cnx;
    private static AdminRequestor requestor;
    private static AdminMessage requestMsg;
    private static AdminMessage replyMsg;
    protected static AdminReply reply;
    private static long requestTimeout;
    private static boolean isHa;

    public static void main(String[] args) {
        try {
            AdminModule.executeXMLAdmin(args[0]);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static void connect(TopicConnectionFactory cnxFact, String name, String password) throws ConnectException, AdminException {
        AdminModule.connect(cnxFact, name, password, SimpleIdentity.class.getName());
    }

    public static void connect(TopicConnectionFactory cnxFact, String name, String password, String identityClass) throws ConnectException, AdminException {
        if (cnx != null) {
            return;
        }
        ((AbstractConnectionFactory)((Object)cnxFact)).setIdentityClassName(identityClass);
        try {
            cnx = cnxFact.createTopicConnection(name, password);
            requestor = new AdminRequestor(cnx);
            cnx.start();
            FactoryParameters params = null;
            params = cnxFact instanceof XATopicConnectionFactory ? ((XAConnectionFactory)((Object)cnxFact)).getParameters() : ((ConnectionFactory)((Object)cnxFact)).getParameters();
            localHost = params.getHost();
            localPort = params.getPort();
            localServer = requestor.getLocalServerId();
        }
        catch (JMSSecurityException exc) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            throw new AdminException(exc.getMessage());
        }
        catch (JMSException exc) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            throw new ConnectException("Connecting failed: " + exc);
        }
    }

    public static void connect(String hostName, int port, String name, String password, int cnxTimer) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.connect(hostName, port, name, password, cnxTimer, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public static void connect(String hostName, int port, String name, String password, int cnxTimer, String reliableClass) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.connect(hostName, port, name, password, cnxTimer, reliableClass, SimpleIdentity.class.getName());
    }

    public static void connect(String hostName, int port, String name, String password, int cnxTimer, String reliableClass, String identityClass) throws UnknownHostException, ConnectException, AdminException {
        TopicConnectionFactory cnxFact = null;
        if (isHa) {
            String urlHa = "hajoram://" + hostName + ":" + port;
            cnxFact = TopicHATcpConnectionFactory.create(urlHa);
        } else {
            cnxFact = TopicTcpConnectionFactory.create(hostName, port, reliableClass);
        }
        ((ConnectionFactory)((Object)cnxFact)).getParameters().connectingTimer = cnxTimer;
        AdminModule.connect(cnxFact, name, password, identityClass);
    }

    public static void connect(String name, String password, int cnxTimer) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.connect("localhost", 16010, name, password, cnxTimer);
    }

    public static void connect(String name, String password, int cnxTimer, String reliableClass) throws UnknownHostException, ConnectException, AdminException {
        AdminModule.connect("localhost", 16010, name, password, cnxTimer, reliableClass);
    }

    public static void collocatedConnect(String name, String password) throws ConnectException, AdminException {
        AdminModule.collocatedConnect(name, password, SimpleIdentity.class.getName());
    }

    public static void collocatedConnect(String name, String password, String identityClass) throws ConnectException, AdminException {
        JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("isHa=" + isHa));
        if (isHa) {
            AdminModule.connect(TopicHALocalConnectionFactory.create(), name, password, identityClass);
        } else {
            AdminModule.connect(TopicLocalConnectionFactory.create(), name, password, identityClass);
        }
    }

    public static void disconnect() {
        try {
            if (cnx == null) {
                return;
            }
            cnx.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        cnx = null;
    }

    public static void stopServer(int serverId) throws ConnectException, AdminException {
        try {
            AdminModule.doRequest(new StopServerRequest(serverId));
            if (serverId == localServer) {
                cnx = null;
            }
        }
        catch (ConnectException exc) {
            if (serverId != localServer) {
                throw exc;
            }
            cnx = null;
        }
    }

    public static void stopServer() throws ConnectException, AdminException {
        AdminModule.stopServer(localServer);
    }

    public static void addServer(int sid, String hostName, String domainName, int port, String serverName) throws ConnectException, AdminException {
        AdminModule.addServer(sid, hostName, domainName, port, serverName, new String[0], new String[0]);
    }

    public static void addServer(int sid, String hostName, String domainName, int port, String serverName, String[] serviceNames, String[] serviceArgs) throws ConnectException, AdminException {
        if (serviceNames != null && serviceArgs != null) {
            if (serviceNames.length != serviceArgs.length) {
                throw new AdminException("Same number of service names and arguments expected");
            }
        } else {
            if (serviceNames == null) {
                throw new AdminException("Expected service names");
            }
            if (serviceArgs == null) {
                throw new AdminException("Expected service arguments");
            }
        }
        AdminModule.doRequest(new AddServerRequest(sid, hostName, domainName, port, serverName, serviceNames, serviceArgs));
    }

    public static void removeServer(int sid) throws ConnectException, AdminException {
        AdminModule.doRequest(new RemoveServerRequest(sid));
    }

    public static void addDomain(String domainName, int sid, int port) throws ConnectException, AdminException {
        AdminModule.doRequest(new AddDomainRequest(domainName, sid, port));
    }

    public static void addDomain(String domainName, String network, int sid, int port) throws ConnectException, AdminException {
        AdminModule.doRequest(new AddDomainRequest(domainName, network, sid, port));
    }

    public static void removeDomain(String domainName) throws ConnectException, AdminException {
        AdminModule.doRequest(new RemoveDomainRequest(domainName));
    }

    public static String getConfiguration() throws ConnectException, AdminException {
        return AdminModule.doRequest(new GetConfigRequest()).getInfo();
    }

    public static void setDefaultDMQ(int serverId, DeadMQueue dmq) throws ConnectException, AdminException {
        if (dmq != null) {
            AdminModule.doRequest(new SetDefaultDMQ(serverId, dmq.getName()));
        }
    }

    public static void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        AdminModule.doRequest(new SetDefaultDMQ(serverId, dmqId));
    }

    public static void setDefaultDMQ(DeadMQueue dmq) throws ConnectException, AdminException {
        AdminModule.setDefaultDMQ(localServer, dmq);
    }

    public static void setDefaultDMQId(String dmqId) throws ConnectException, AdminException {
        AdminModule.setDefaultDMQId(localServer, dmqId);
    }

    public static void setDefaultThreshold(int serverId, int threshold) throws ConnectException, AdminException {
        AdminModule.doRequest(new SetDefaultThreshold(serverId, threshold));
    }

    public static void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        AdminModule.setDefaultThreshold(localServer, threshold);
    }

    public static List getServersIds() throws ConnectException, AdminException {
        return AdminModule.getServersIds(null);
    }

    public static List getServersIds(String domainName) throws ConnectException, AdminException {
        Monitor_GetServersIds request = new Monitor_GetServersIds(AdminModule.getLocalServerId(), domainName);
        Monitor_GetServersIdsRep reply = (Monitor_GetServersIdsRep)AdminModule.doRequest(request);
        int[] serverIds = reply.getIds();
        Vector<Integer> res = new Vector<Integer>();
        for (int i = 0; i < serverIds.length; ++i) {
            res.addElement(new Integer(serverIds[i]));
        }
        return res;
    }

    public static Server[] getServers() throws ConnectException, AdminException {
        return AdminModule.getServers(null);
    }

    public static Server[] getServers(String domainName) throws ConnectException, AdminException {
        Monitor_GetServersIds request = new Monitor_GetServersIds(AdminModule.getLocalServerId(), domainName);
        Monitor_GetServersIdsRep reply = (Monitor_GetServersIdsRep)AdminModule.doRequest(request);
        int[] serverIds = reply.getIds();
        String[] serverNames = reply.getNames();
        String[] serverHostNames = reply.getHostNames();
        Server[] servers = new Server[serverIds.length];
        for (int i = 0; i < serverIds.length; ++i) {
            servers[i] = new Server(serverIds[i], serverNames[i], serverHostNames[i]);
        }
        return servers;
    }

    public static Server getLocalServer() throws ConnectException, AdminException {
        GetLocalServerRep reply = (GetLocalServerRep)AdminModule.doRequest(new GetLocalServer());
        return new Server(reply.getId(), reply.getName(), reply.getHostName());
    }

    public static String[] getDomainNames(int serverId) throws ConnectException, AdminException {
        GetDomainNames request = new GetDomainNames(serverId);
        GetDomainNamesRep reply = (GetDomainNamesRep)AdminModule.doRequest(request);
        return reply.getDomainNames();
    }

    public static DeadMQueue getDefaultDMQ(int serverId) throws ConnectException, AdminException {
        String reply = AdminModule.getDefaultDMQId(serverId);
        if (reply == null) {
            return null;
        }
        return new DeadMQueue(reply);
    }

    public static DeadMQueue getDefaultDMQ() throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQ(localServer);
    }

    public static String getDefaultDMQId() throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQId(localServer);
    }

    public static String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(serverId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)AdminModule.doRequest(request);
        if (reply.getDMQName() == null) {
            return null;
        }
        return reply.getDMQName();
    }

    public static int getDefaultThreshold(int serverId) throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(serverId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)AdminModule.doRequest(request);
        if (reply.getThreshold() == null) {
            return -1;
        }
        return reply.getThreshold();
    }

    public static int getDefaultThreshold() throws ConnectException, AdminException {
        return AdminModule.getDefaultThreshold(localServer);
    }

    public static List getDestinations(int serverId) throws ConnectException, AdminException {
        Monitor_GetDestinations request = new Monitor_GetDestinations(serverId);
        Monitor_GetDestinationsRep reply = (Monitor_GetDestinationsRep)AdminModule.doRequest(request);
        Vector<Destination> list = new Vector<Destination>();
        String[] ids = reply.getIds();
        String[] names = reply.getNames();
        String[] types = reply.getTypes();
        for (int i = 0; i < types.length; ++i) {
            list.addElement(Destination.newInstance(ids[i], names[i], types[i]));
        }
        return list;
    }

    public static List getDestinations() throws ConnectException, AdminException {
        return AdminModule.getDestinations(localServer);
    }

    public static List getDestinations(int serverId, long delay) throws ConnectException, AdminException {
        Monitor_GetDestinations request = new Monitor_GetDestinations(serverId);
        Monitor_GetDestinationsRep reply = (Monitor_GetDestinationsRep)AdminModule.doRequest(request, delay);
        Vector<Destination> list = new Vector<Destination>();
        String[] ids = reply.getIds();
        String[] names = reply.getNames();
        String[] types = reply.getTypes();
        for (int i = 0; i < types.length; ++i) {
            list.addElement(Destination.newInstance(ids[i], names[i], types[i]));
        }
        return list;
    }

    public static List getUsers(int serverId) throws ConnectException, AdminException {
        Monitor_GetUsers request = new Monitor_GetUsers(serverId);
        Monitor_GetUsersRep reply = (Monitor_GetUsersRep)AdminModule.doRequest(request);
        Vector<User> list = new Vector<User>();
        Hashtable users = reply.getUsers();
        Enumeration names = users.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list.add(new User(name, (String)users.get(name)));
        }
        return list;
    }

    public static List getUsers(int serverId, long delay) throws ConnectException, AdminException {
        Monitor_GetUsers request = new Monitor_GetUsers(serverId);
        Monitor_GetUsersRep reply = (Monitor_GetUsersRep)AdminModule.doRequest(request, delay);
        Vector<User> list = new Vector<User>();
        Hashtable users = reply.getUsers();
        Enumeration names = users.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list.add(new User(name, (String)users.get(name)));
        }
        return list;
    }

    public static List getUsers() throws ConnectException, AdminException {
        return AdminModule.getUsers(localServer);
    }

    public static int getLocalServerId() throws ConnectException {
        if (cnx == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return localServer;
    }

    public static String getLocalHost() throws ConnectException {
        if (cnx == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return localHost;
    }

    public static int getLocalPort() throws ConnectException {
        if (cnx == null) {
            throw new ConnectException("Administrator not connected.");
        }
        return localPort;
    }

    public static AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        return AdminModule.doRequest(request, requestTimeout);
    }

    public static AdminReply doRequest(AdminRequest request, long timeout) throws AdminException, ConnectException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("AdminModule.doRequest(" + request + ')'));
        }
        if (cnx == null) {
            throw new ConnectException("Admin connection not established.");
        }
        if (timeout < 1L) {
            timeout = requestTimeout;
        }
        try {
            replyMsg = (AdminMessage)requestor.request(request, timeout);
            reply = (AdminReply)replyMsg.getAdminMessage();
            if (!reply.succeeded()) {
                switch (reply.getErrorCode()) {
                    case 0: {
                        throw new NameAlreadyUsedException(reply.getInfo());
                    }
                    case 1: {
                        throw new StartFailureException(reply.getInfo());
                    }
                    case 2: {
                        throw new ServerIdAlreadyUsedException(reply.getInfo());
                    }
                    case 3: {
                        throw new UnknownServerException(reply.getInfo());
                    }
                }
                throw new AdminException(reply.getInfo());
            }
            return reply;
        }
        catch (JMSException exc) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            throw new ConnectException("Connection failed: " + exc.getMessage());
        }
        catch (ClassCastException exc) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            throw new AdminException("Invalid server reply: " + exc.getMessage());
        }
    }

    public static void abortRequest() throws JMSException {
        if (requestor == null) {
            throw new JMSException("Not connected");
        }
        requestor.abort();
    }

    public static boolean executeXMLAdmin(String cfgDir, String cfgFileName) throws Exception {
        return AdminModule.executeXMLAdmin(new File(cfgDir, cfgFileName).getPath());
    }

    public static boolean executeXMLAdmin(String path) throws Exception {
        if (JoramTracing.dbgAdmin.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgAdmin.log(BasicLevel.DEBUG, (Object)("executeXMLAdmin(" + path + ")"));
        }
        boolean res = false;
        FileReader reader = null;
        File cfgFile = new File(path);
        try {
            if (!cfgFile.exists() || !cfgFile.isFile() || cfgFile.length() == 0L) {
                throw new IOException();
            }
            reader = new FileReader(cfgFile);
        }
        catch (IOException exc) {
            if (JoramTracing.dbgAdmin.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgAdmin.log(BasicLevel.DEBUG, (Object)("Unable to find Joram Admin configuration file \"" + cfgFile.getPath() + "\"."));
            }
            reader = null;
        }
        if (reader == null) {
            ClassLoader classLoader = null;
            InputStream is = null;
            try {
                classLoader = AdminModule.class.getClassLoader();
                if (classLoader != null) {
                    if (JoramTracing.dbgAdmin.isLoggable(BasicLevel.DEBUG)) {
                        JoramTracing.dbgAdmin.log(BasicLevel.DEBUG, (Object)("Trying to find [" + path + "] using " + classLoader + " class loader."));
                    }
                    is = classLoader.getResourceAsStream(path);
                }
            }
            catch (Throwable t) {
                if (JoramTracing.dbgAdmin.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgAdmin.log(BasicLevel.DEBUG, (Object)("Can't find [" + path + "] using " + classLoader + " class loader."), t);
                }
                is = null;
            }
            if (is == null) {
                if (JoramTracing.dbgAdmin.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgAdmin.log(BasicLevel.DEBUG, (Object)("Trying to find [" + path + "] using ClassLoader.getSystemResource()."));
                }
                is = ClassLoader.getSystemResourceAsStream(path);
            }
            if (is != null) {
                res = AdminModule.executeAdmin(new InputStreamReader(is));
            }
        } else {
            res = AdminModule.executeAdmin(reader);
        }
        if (!res) {
            throw new FileNotFoundException("xml Joram Admin configuration file not found.");
        }
        return res;
    }

    public static boolean executeAdmin(Reader reader) throws Exception {
        if (JoramTracing.dbgAdmin.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgAdmin.log(BasicLevel.DEBUG, (Object)("executeAdmin(" + reader + ")"));
        }
        String cfgName = System.getProperty(ADM_NAME_PROPERTY, DEFAULT_ADM_NAME);
        JoramSaxWrapper wrapper = new JoramSaxWrapper();
        return wrapper.parse(reader, cfgName);
    }

    public static void setHa(boolean isHa) {
        AdminModule.isHa = isHa;
    }

    static {
        cnx = null;
        requestTimeout = Long.getLong(REQUEST_TIMEOUT_PROP, 120000L);
        isHa = false;
    }

    public static class AdminRequestor {
        private TopicSession sess;
        private Topic topic;
        private TemporaryTopic tmpTopic;
        private MessageProducer producer;
        private MessageConsumer consumer;

        public AdminRequestor(TopicConnection cnx) throws JMSException {
            this.sess = cnx.createTopicSession(false, 1);
            this.topic = this.sess.createTopic("#AdminTopic");
            this.producer = this.sess.createProducer(this.topic);
            this.tmpTopic = this.sess.createTemporaryTopic();
            this.consumer = this.sess.createConsumer(this.tmpTopic);
        }

        public Message request(AdminRequest request, long timeout) throws JMSException {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("AdminModule.AdminRequestor.request(" + request + ',' + timeout + ')'));
            }
            requestMsg = new AdminMessage();
            requestMsg.setAdminMessage(request);
            requestMsg.setJMSReplyTo(this.tmpTopic);
            this.producer.send(requestMsg);
            String correlationId = requestMsg.getJMSMessageID();
            while (true) {
                Message reply;
                if ((reply = this.consumer.receive(timeout)) == null) {
                    throw new JMSException("Interrupted request");
                }
                if (correlationId.equals(reply.getJMSCorrelationID())) {
                    return reply;
                }
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) continue;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("reply id (" + reply.getJMSCorrelationID() + ") != request id (" + correlationId + ")"));
            }
        }

        public void abort() throws JMSException {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"AdminModule.AdminRequestor.abort()");
            }
            this.consumer.close();
            this.consumer = this.sess.createConsumer(this.tmpTopic);
        }

        public int getLocalServerId() {
            try {
                String topicName = this.topic.getTopicName();
                int ind0 = topicName.indexOf(".");
                int ind1 = topicName.indexOf(".", ind0 + 1);
                return Integer.parseInt(topicName.substring(ind0 + 1, ind1));
            }
            catch (JMSException exc) {
                return -1;
            }
        }

        public void close() throws JMSException {
            this.consumer.close();
            this.producer.close();
            this.tmpTopic.delete();
            this.sess.close();
        }
    }
}

