/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mi2xml.lib;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.xerces.dom.DocumentImpl;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.GenClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.NameRef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.mi2xml.api.DomtreeBuilder;
import org.objectweb.jorm.mi2xml.api.MappingDomtreeBuilder;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicDomtreeBuilder
implements DomtreeBuilder,
Loggable {
    public static final String ID = "ID";
    public static final String REF = "REF";
    public static final String IDVALUE_SEP = ".";
    public static final String JORM = "jorm";
    public static final String PACKAGE = "package";
    public static final String CLASS = "class";
    public static final String MAPPING = "mapping";
    public static final String COMPOSITE_NAME = "composite-name";
    public static final String FIELD = "field";
    public static final String SCALAR_FIELD = "scalar-field";
    public static final String EXTENSION = "extension";
    public static final String NAME_DEF = "name-def";
    public static final String PRIMITIVE_TYPE = "primitive-type";
    public static final String CLASS_REF = "class-ref";
    public static final String GEN_CLASS_REF = "gen-class-ref";
    public static final String FIELD_REF = "field-ref";
    public static final String SCALAR_TYPE = "scalar-type";
    public static final String NULL_VALUE = "null-value";
    public static final String GEN_CLASS = "gen-class";
    public static final String INDEX = "index";
    public static final String SYSTEM = "system";
    public static final String COMPOSITE_NAME_REF = "composite-name-ref";
    public static final String COMPOSITE_NAME_FIELD_PROJECTION = "composite-name-field-projection";
    private Map mappingDomtreeBuilders;
    private Logger logger;
    private LoggerFactory loggerFactory;
    private Map metaobject2idvalue = new Hashtable();

    public BasicDomtreeBuilder() {
        this.mappingDomtreeBuilders = new HashMap();
    }

    public void addMappingDomtreeBuilder(String mapperName, MappingDomtreeBuilder mdb) {
        if (this.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.getLogger().log(BasicLevel.DEBUG, (Object)("Add a MappingDomtreeBuilder (" + mapperName + ") for the current builder"));
        }
        if (!this.mappingDomtreeBuilders.containsKey(mapperName)) {
            this.mappingDomtreeBuilders.put(mapperName, mdb);
        }
    }

    private MappingDomtreeBuilder getMappingDomtreeBuilder(String mapperName) throws PException {
        MappingDomtreeBuilder mdb = (MappingDomtreeBuilder)this.mappingDomtreeBuilders.get(mapperName);
        if (mdb == null) {
            throw new PExceptionCompiler("<" + mapperName + ">DomtreeBuilder has not been created.");
        }
        return mdb;
    }

    public Document build(MetaObject metaObject) throws PException {
        DocumentImpl document = new DocumentImpl();
        Element rootElement = document.createElement(JORM);
        String packageName = ((Package)metaObject.getParent()).getName();
        Element packageElement = document.createElement(PACKAGE);
        packageElement.appendChild(document.createTextNode(packageName));
        rootElement.appendChild(packageElement);
        if (metaObject instanceof Class) {
            Class clazz = (Class)metaObject;
            String className = clazz.getName();
            Element classElement = document.createElement(CLASS);
            classElement.setAttribute("name", className);
            classElement.setAttribute("abstract", ("" + clazz.isAbstract()).toUpperCase());
            rootElement.appendChild(classElement);
            this.processClass((Document)document, classElement, clazz);
            if (!clazz.getClassProjects().isEmpty()) {
                this.processMappings((Document)document, rootElement, clazz);
            }
        } else {
            CompositeName compositeName = (CompositeName)metaObject;
            Element compositeNameElement = document.createElement(COMPOSITE_NAME);
            compositeNameElement.setAttribute("name", compositeName.getName());
            rootElement.appendChild(compositeNameElement);
            this.processCompositeName((Document)document, compositeNameElement, compositeName);
        }
        document.appendChild(rootElement);
        return document;
    }

    private void processClass(Document document, Element classElement, Class clazz) {
        Iterator fieldIterator = clazz.getFields().iterator();
        while (fieldIterator.hasNext()) {
            String fieldName;
            TypedElement typedElement = (TypedElement)fieldIterator.next();
            String idValue = fieldName = typedElement.getName();
            Element fieldElement = document.createElement(FIELD);
            fieldElement.setAttribute("name", fieldName);
            classElement.appendChild(fieldElement);
            if (typedElement instanceof PrimitiveElement) {
                Element ptElement = document.createElement(PRIMITIVE_TYPE);
                ptElement.setAttribute("type", typedElement.getType().getJormName());
                fieldElement.appendChild(ptElement);
                continue;
            }
            if (typedElement instanceof ClassRef) {
                Element crElement = document.createElement(CLASS_REF);
                crElement.setAttribute("class-name", ((ClassRef)typedElement).getMOClass().getFQName());
                fieldElement.appendChild(crElement);
                this.processClassRef(document, crElement, (ClassRef)typedElement, idValue);
                continue;
            }
            if (!(typedElement instanceof GenClassRef)) continue;
            Element gcrElement = document.createElement(GEN_CLASS_REF);
            fieldElement.appendChild(gcrElement);
            this.processGenClassRef(document, gcrElement, (GenClassRef)typedElement, idValue);
        }
        Iterator sfIterator = clazz.getHiddenFields().iterator();
        while (sfIterator.hasNext()) {
            String name;
            ScalarField scalarField = (ScalarField)sfIterator.next();
            String idValue = name = scalarField.getName();
            Element sfElement = document.createElement(SCALAR_FIELD);
            sfElement.setAttribute("name", name);
            classElement.appendChild(sfElement);
            this.processScalarField(document, sfElement, scalarField, idValue);
        }
        Iterator superIterator = clazz.getSuperClasses().iterator();
        while (superIterator.hasNext()) {
            Class superClazz = (Class)superIterator.next();
            Element extElement = document.createElement(EXTENSION);
            extElement.setAttribute("name", superClazz.getFQName());
            classElement.appendChild(extElement);
        }
        Iterator ndIterator = clazz.getNameDefs().iterator();
        while (ndIterator.hasNext()) {
            NameDef nameDef = (NameDef)ndIterator.next();
            Element ndElement = document.createElement(NAME_DEF);
            ndElement.setAttribute("name", nameDef.getName());
            classElement.appendChild(ndElement);
            this.processNameDef(document, ndElement, nameDef);
        }
    }

    private void processClassRef(Document document, Element crElement, ClassRef classRef, String parentIdValue) {
        Iterator ndIterator = classRef.getRefNameDef().iterator();
        while (ndIterator.hasNext()) {
            NameDef nameDef = (NameDef)ndIterator.next();
            Element ndElement = document.createElement(NAME_DEF);
            ndElement.setAttribute("name", nameDef.getName());
            crElement.appendChild(ndElement);
            this.processNameDef(document, ndElement, nameDef);
        }
    }

    private void processGenClassRef(Document document, Element gcrElement, GenClassRef genClassRef, String parentIdValue) {
        Element gcElement = document.createElement(GEN_CLASS);
        gcElement.setAttribute("gen-class-name", genClassRef.getGenClassName());
        gcrElement.appendChild(gcElement);
        this.metaobject2idvalue.put(genClassRef, genClassRef.getGenClassId());
        this.processGenClass(document, gcElement, genClassRef, "");
        Iterator ndIterator = genClassRef.getRefNameDef().iterator();
        while (ndIterator.hasNext()) {
            NameDef nameDef = (NameDef)ndIterator.next();
            Element ndElement = document.createElement(NAME_DEF);
            ndElement.setAttribute("name", nameDef.getName());
            gcrElement.appendChild(ndElement);
            this.processNameDef(document, ndElement, nameDef);
        }
    }

    private void processScalarField(Document document, Element sfElement, ScalarField scalarField, String idValue) {
        Element stElement = document.createElement(SCALAR_TYPE);
        stElement.setAttribute("type", scalarField.getType().getJormName());
        sfElement.appendChild(stElement);
        if (scalarField.getNullValue() != null) {
            Element nvElement = document.createElement(NULL_VALUE);
            nvElement.setAttribute("value", scalarField.getNullValue());
            stElement.appendChild(nvElement);
        }
    }

    private void processNameDef(Document document, Element ndElement, NameDef nameDef) {
        if (nameDef.isSystem()) {
            Element systemElement = document.createElement(SYSTEM);
            ndElement.appendChild(systemElement);
        } else if (nameDef.getFieldName() != null) {
            Element frElement = document.createElement(FIELD_REF);
            frElement.setAttribute("field-name", nameDef.getFieldName());
            ndElement.appendChild(frElement);
        } else if (nameDef.isNameRef()) {
            NameRef nameRef = nameDef.getNameRef();
            Element cnrElement = document.createElement(COMPOSITE_NAME_REF);
            cnrElement.setAttribute("composite-name-name", nameRef.getCNPackageName() + IDVALUE_SEP + nameRef.getName());
            ndElement.appendChild(cnrElement);
            this.processCompositeNameRef(document, cnrElement, nameRef);
        }
    }

    private void processCompositeNameRef(Document document, Element cnrElement, NameRef nameRef) {
        Iterator projIterator = nameRef.getProjection().keySet().iterator();
        while (projIterator.hasNext()) {
            String fieldName = (String)projIterator.next();
            String classFieldName = nameRef.getClassFieldName(fieldName);
            Element cnfpElement = document.createElement(COMPOSITE_NAME_FIELD_PROJECTION);
            cnfpElement.setAttribute("composite-name-field-name", fieldName);
            cnfpElement.setAttribute("class-field-name", classFieldName);
            cnrElement.appendChild(cnfpElement);
        }
    }

    private void processGenClass(Document document, Element gcElement, GenClassRef genClassRef, String parentIdValue) {
        Iterator sfIterator = genClassRef.getHiddenFields().iterator();
        while (sfIterator.hasNext()) {
            ScalarField scalarField = (ScalarField)sfIterator.next();
            Element sfElement = document.createElement(SCALAR_FIELD);
            sfElement.setAttribute("name", scalarField.getName());
            gcElement.appendChild(sfElement);
            this.processScalarField(document, sfElement, scalarField, "");
        }
        Iterator ndIterator = genClassRef.getIdNameDef().iterator();
        while (ndIterator.hasNext()) {
            NameDef nameDef = (NameDef)ndIterator.next();
            Element ndElement = document.createElement(NAME_DEF);
            ndElement.setAttribute("name", nameDef.getName());
            gcElement.appendChild(ndElement);
            this.processNameDef(document, ndElement, nameDef);
        }
        Iterator frIterator = genClassRef.getIndexFields().iterator();
        if (frIterator.hasNext()) {
            Element indexElement = document.createElement(SCALAR_FIELD);
            gcElement.appendChild(indexElement);
            while (frIterator.hasNext()) {
                ScalarField scalarField = (ScalarField)frIterator.next();
                String name = scalarField.getName();
                Element frElement = document.createElement(FIELD_REF);
                frElement.setAttribute("name", name);
                indexElement.appendChild(frElement);
            }
        }
        if (genClassRef.isPrimitive()) {
            PrimitiveElement primitiveElement = genClassRef.getPrimitiveElement();
            String fieldName = primitiveElement.getName();
            Element ptElement = document.createElement(PRIMITIVE_TYPE);
            ptElement.setAttribute("type", primitiveElement.getType().getJormName());
            gcElement.appendChild(ptElement);
        } else if (genClassRef.isClassRef()) {
            ClassRef classRef = genClassRef.getClassRef();
            Element crElement = document.createElement(CLASS_REF);
            crElement.setAttribute("name", classRef.getClassName());
            gcElement.appendChild(crElement);
            this.processClassRef(document, crElement, classRef, parentIdValue);
        } else if (genClassRef.isGenClassRef()) {
            GenClassRef subGenClassRef = genClassRef.getGenClassRef();
            Element gcrElement = document.createElement(GEN_CLASS_REF);
            gcElement.appendChild(gcrElement);
            this.processGenClassRef(document, gcrElement, subGenClassRef, parentIdValue);
        }
    }

    private void processCompositeName(Document document, Element cnElement, CompositeName compositeName) {
        Iterator sfIterator = compositeName.getFields().iterator();
        while (sfIterator.hasNext()) {
            ScalarField scalarField = (ScalarField)sfIterator.next();
            String name = scalarField.getName();
            Element sfElement = document.createElement(SCALAR_FIELD);
            sfElement.setAttribute("name", name);
            cnElement.appendChild(sfElement);
            this.processScalarField(document, sfElement, scalarField, name);
        }
        Iterator icnIterator = compositeName.getSuperCompositeNames().iterator();
        while (icnIterator.hasNext()) {
            CompositeName aCompositeName = (CompositeName)icnIterator.next();
            Element extensionElement = document.createElement(EXTENSION);
            extensionElement.appendChild(document.createTextNode(aCompositeName.getName()));
            cnElement.appendChild(extensionElement);
        }
    }

    private void processMappings(Document document, Element rootElement, Class clazz) throws PException {
        MappingDomtreeBuilder mdb = null;
        Iterator cpIterator = clazz.getClassProjects().iterator();
        while (cpIterator.hasNext()) {
            ClassProject classProject = (ClassProject)cpIterator.next();
            String projectName = classProject.getProjectName();
            Element mappingElement = document.createElement(MAPPING);
            mappingElement.setAttribute("project-name", projectName);
            rootElement.appendChild(mappingElement);
            Iterator mappingIterator = classProject.getMappings().iterator();
            while (mappingIterator.hasNext()) {
                Mapping mapping = (Mapping)mappingIterator.next();
                String mapperName = mapping.getMapperName();
                mdb = this.getMappingDomtreeBuilder(mapperName);
                ((Loggable)((Object)mdb)).setLogger(this.logger);
                mdb.setCurrentClass(clazz);
                mdb.setmetaobject2idvalue(this.metaobject2idvalue);
                ClassMapping classMapping = mapping.getClassMapping();
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("current class =<" + clazz.getName() + ">"));
                    this.logger.log(BasicLevel.DEBUG, (Object)("current project =<" + projectName + ">"));
                    this.logger.log(BasicLevel.DEBUG, (Object)("current mapping =<" + mapperName + ">"));
                }
                mdb.processClassMapping(document, mappingElement, classMapping);
                Iterator gcmIterator = mapping.getGenClassMappings().iterator();
                while (gcmIterator.hasNext()) {
                    GenClassMapping genClassMapping = (GenClassMapping)gcmIterator.next();
                    mdb.processGenClassMapping(document, mappingElement, genClassMapping);
                }
            }
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerFactory(LoggerFactory loggerfactory) {
        this.loggerFactory = loggerfactory;
        if (this.logger == null && this.loggerFactory != null) {
            this.logger = this.loggerFactory.getLogger("org.objectweb.jorm.mi2xml.rdb");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }
}

