/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.rdb.lib;

import java.util.ArrayList;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.QueryLeafException;
import org.objectweb.medor.datasource.api.DataStore;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.query.api.NestQueryNode;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Nest;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.medor.query.rdb.api.RdbQueryLeaf;
import org.objectweb.medor.query.rdb.lib.BasicRdbExpQueryLeaf;

public class AggregateRdbQueryNode
extends Nest
implements RdbQueryLeaf,
NestQueryNode {
    private static final long serialVersionUID = 1185797036981033368L;
    protected DataStore ds;
    protected RdbExpField groupByField;
    protected RdbExpQueryLeaf subRdbQL;
    protected String query = null;
    private boolean isSubquery = false;

    public AggregateRdbQueryNode() {
    }

    public AggregateRdbQueryNode(QueryTreeField[] groupedFields, String groupedFieldName, QueryTreeField[] groupByFields, BasicRdbExpQueryLeaf subQL, DataStore ds, String nodeName) throws MedorException {
        super(groupedFields, groupedFieldName, groupByFields, nodeName);
        this.ds = ds;
        this.subRdbQL = subQL;
        this.removeField(groupedFieldName);
        for (int i = 0; i < groupByFields.length; ++i) {
            subQL.addGroupBy((RdbExpField)groupByFields[i]);
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        AggregateRdbQueryNode a = (AggregateRdbQueryNode)clone;
        a.ds = this.ds;
        a.groupByField = (RdbExpField)AggregateRdbQueryNode.getClone(this.groupByField, obj2clone);
        a.subRdbQL = (RdbExpQueryLeaf)AggregateRdbQueryNode.getClone(this.subRdbQL, obj2clone);
        a.query = this.query;
        a.isSubquery = this.isSubquery;
        return clone;
    }

    public String getSqlRequest(ParameterOperand[] pos, ArrayList al, boolean rangeStartAt, boolean rangeSize) throws MedorException, ExpressionException {
        if (al == null) {
            return this.getSqlRequest(pos, rangeStartAt, rangeSize);
        }
        throw new MedorException("Request with selectList not supported");
    }

    public String getSqlRequest(ParameterOperand[] pos, boolean rangeStartAt, boolean rangeSize) throws MedorException, ExpressionException {
        ArrayList<Field> selectFields = new ArrayList<Field>();
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i) instanceof NestedField) continue;
            if (this.fields.get(i) instanceof PropagatedField) {
                selectFields.add(((PropagatedField)this.fields.get(i)).getPreviousFields()[0]);
                continue;
            }
            selectFields.add((Field)this.fields.get(i));
        }
        if (this.query != null) {
            return this.query;
        }
        if (this.subRdbQL.isSubquery()) {
            boolean subRdbQLDistinct = this.subRdbQL.getDistinct();
            this.subRdbQL.setDistinct(this.getDistinct());
            StringBuffer sb = new StringBuffer();
            sb.append(this.subRdbQL.getSelectList("SELECT ", selectFields, false));
            this.subRdbQL.setDistinct(subRdbQLDistinct);
            this.subRdbQL.setNoGroupBy(true);
            sb.append(" FROM (");
            sb.append(this.subRdbQL.getSqlRequest(pos, null, rangeStartAt, rangeSize));
            sb.append(")");
            if (this.subRdbQL.getRdbAdapter() != null) {
                String subQueryAlias = this.subRdbQL.getRdbAdapter().getSubqueryAlias();
                if (subQueryAlias == null) {
                    sb.append(this.subRdbQL.getGroupBy());
                } else {
                    this.subRdbQL.getRdbAdapter().writeTableAlias(subQueryAlias, sb);
                    sb.append(this.subRdbQL.getGroupBy(subQueryAlias));
                }
            }
            this.query = sb.toString();
        } else {
            this.query = this.subRdbQL.getSqlRequest(pos, selectFields, rangeStartAt, rangeSize);
        }
        return this.query;
    }

    public String getSqlDelete(ParameterOperand[] pos) {
        return null;
    }

    public String getSqlUpdate(ParameterOperand[] pos, Expression updateExpression) {
        return null;
    }

    public String getSelectList(String selectList, ArrayList selectFields, boolean qualified) throws MedorException {
        throw new QueryLeafException("Unsupported method getSelectList for AggregateRdbQueryNode");
    }

    public DataStore getDataStore() {
        return this.ds;
    }

    public void setIsSubquery(boolean subquery) {
        this.isSubquery = subquery;
    }

    public boolean isSubquery() {
        return this.isSubquery;
    }

    public Expression getQueryFilter() {
        if (this.subRdbQL != null) {
            return this.subRdbQL.getQueryFilter();
        }
        return null;
    }
}

