/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import javax.ejb.EJBHome;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.ejb2_1.pool.EJBObjectFactory;
import org.ow2.cmi.ejb2_1.rpc.EJBHomeInvocationHandler;
import org.ow2.cmi.ejb2_1.rpc.ha.HAEJBHomeInvocationHandler;
import org.ow2.cmi.pool.StubOrProxyFactory;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.rpc.CMIInvocationHandler;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.cmi.rpc.CMIProxyFactoryException;
import org.ow2.cmi.rpc.POJOInvocationHandler;
import org.ow2.cmi.rpc.StatefulPOJOInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.impl.JPool;

@ThreadSafe
public final class CMIProxyFactory {
    private static final Log LOGGER = LogFactory.getLog(CMIProxyFactory.class);

    private CMIProxyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMIProxy newCMIProxy(ClusterViewManager clusterViewManager, String objectName, String protocolName) throws CMIProxyFactoryException, ObjectNotFoundException {
        CMIInvocationHandler invocationHandler;
        ClusterViewManager clusterViewManager2;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> itfClass = clusterViewManager.getInterface(objectName);
        if (!clusterViewManager.hasState(objectName) && !clusterViewManager.isReplicated(objectName)) {
            if (Arrays.asList(itfClass.getInterfaces()).contains(EJBHome.class)) {
                LOGGER.debug("Object with name {0} is a stateless ejb2", new Object[0]);
                clusterViewManager2 = clusterViewManager;
                synchronized (clusterViewManager2) {
                    if (clusterViewManager.getPool(objectName) == null) {
                        LOGGER.debug("First lookup on {0}: creation of the pool for its stubs for EJBObject", objectName);
                        JPool pool = new JPool(new EJBObjectFactory(clusterViewManager));
                        IPoolConfiguration poolConfiguration = clusterViewManager.getPoolConfiguration(objectName);
                        if (poolConfiguration != null) {
                            pool.setPoolConfiguration(poolConfiguration);
                        }
                        clusterViewManager.setPool(objectName, pool);
                    }
                }
                invocationHandler = new EJBHomeInvocationHandler(classLoader, clusterViewManager, objectName, protocolName, itfClass);
            } else {
                clusterViewManager2 = clusterViewManager;
                synchronized (clusterViewManager2) {
                    if (clusterViewManager.getPool(objectName) == null) {
                        LOGGER.debug("First lookup on {0}: creation of the pool for its mandatories", objectName);
                        JPool pool = new JPool(new StubOrProxyFactory(clusterViewManager));
                        IPoolConfiguration poolConfiguration = clusterViewManager.getPoolConfiguration(objectName);
                        if (poolConfiguration != null) {
                            pool.setPoolConfiguration(poolConfiguration);
                        }
                        clusterViewManager.setPool(objectName, pool);
                    }
                }
                invocationHandler = new POJOInvocationHandler(classLoader, clusterViewManager, objectName, protocolName, itfClass);
            }
        } else if (Arrays.asList(itfClass.getInterfaces()).contains(EJBHome.class)) {
            LOGGER.debug("Object with name {0} is a stateful ejb2 or an entity bean: the HA module will be used", new Object[0]);
            clusterViewManager2 = clusterViewManager;
            synchronized (clusterViewManager2) {
                if (clusterViewManager.getPool(objectName) == null) {
                    LOGGER.debug("First lookup on {0}: creation of the pool for its stubs for EJBHome", objectName);
                    JPool pool = new JPool(new StubOrProxyFactory(clusterViewManager));
                    IPoolConfiguration poolConfiguration = clusterViewManager.getPoolConfiguration(objectName);
                    if (poolConfiguration != null) {
                        pool.setPoolConfiguration(poolConfiguration);
                    }
                    clusterViewManager.setPool(objectName, pool);
                }
            }
            invocationHandler = new HAEJBHomeInvocationHandler(classLoader, clusterViewManager, objectName, protocolName, itfClass);
        } else {
            LOGGER.debug("Object with name {0} is a stateful POJO", objectName);
            invocationHandler = new StatefulPOJOInvocationHandler(classLoader, clusterViewManager, objectName, protocolName, itfClass, clusterViewManager.getSessionId());
        }
        Object cmiProxy = Proxy.newProxyInstance(classLoader, new Class[]{itfClass, CMIProxy.class}, (InvocationHandler)invocationHandler);
        return (CMIProxy)cmiProxy;
    }
}

