/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.remotejndiresolver;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.EmbeddedManager;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.remotejndiresolver.JNDIResolverRemoteImpl;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class RemoteJNDIResolverComponent
implements EZBComponent {
    private Log logger = LogFactory.getLog(RemoteJNDIResolverComponent.class);
    private static final String DEFAULT_JNDI_NAME = "EZB_Remote_JNDIResolver";
    private EZBRemoteJNDIResolver jndiResolver = null;

    public void init() throws EZBComponentException {
    }

    public void start() throws EZBComponentException {
        EZBServer server = EmbeddedManager.getEmbedded(0);
        try {
            this.jndiResolver = new JNDIResolverRemoteImpl(server);
        }
        catch (RemoteException e) {
            throw new EZBComponentException("Cannot create the JNDI Resolver.", e);
        }
        try {
            new InitialContext().bind(DEFAULT_JNDI_NAME, (Object)this.jndiResolver);
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot bind the JNDI Resolver", e);
        }
    }

    public void stop() throws EZBComponentException {
        try {
            new InitialContext().unbind(DEFAULT_JNDI_NAME);
        }
        catch (NamingException e) {
            this.logger.error("Cannot unbind the JNDI Resolver", e);
        }
        try {
            PortableRemoteObject.unexportObject((Remote)this.jndiResolver);
        }
        catch (NoSuchObjectException e) {
            this.logger.error("Cannot unexport the JNDI Resolver", e);
        }
    }
}

