/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansSB;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.container.AbsFactory;
import org.ow2.easybeans.container.info.SessionBeanInfo;
import org.ow2.easybeans.container.session.EasyBeansSessionContext;
import org.ow2.easybeans.event.bean.AbstractEventBeanInvocation;
import org.ow2.easybeans.event.bean.EventBeanInvocationBegin;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.proxy.client.ClientRPCInvocationHandler;
import org.ow2.easybeans.rpc.EJBLocalRequestImpl;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBRemoteRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionFactory<PoolType extends EasyBeansSB<PoolType>>
extends AbsFactory<PoolType> {
    private static final boolean RECREATE_DYNAMIC_PROXY = Boolean.getBoolean("easybeans.recreate.dynamic.proxy");
    private static Log logger = LogFactory.getLog(SessionFactory.class);
    private SessionBeanInfo sessionBeanInfo = null;
    private InheritableThreadLocal<String> invokedBusinessInterfaceNameThreadLocal = new InheritableThreadLocal();

    public SessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.getPool().stop();
        }
        catch (PoolException e) {
            logger.error("Problem when stopping the factory", e);
        }
    }

    @Override
    public IBeanInfo getBeanInfo() {
        return this.sessionBeanInfo;
    }

    public SessionBeanInfo getSessionBeanInfo() {
        return this.sessionBeanInfo;
    }

    public void setSessionBeanInfo(SessionBeanInfo sessionBeanInfo) {
        this.sessionBeanInfo = sessionBeanInfo;
    }

    protected abstract Long getId(Long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolType create(Long clue) throws PoolException {
        EasyBeansSB instance = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            try {
                instance = (EasyBeansSB)this.getBeanClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new PoolException("Cannot create a new instance", e);
            }
            catch (IllegalAccessException e) {
                throw new PoolException("Cannot create a new instance", e);
            }
            catch (Exception e) {
                throw new PoolException("Cannot create a new instance", e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        instance.setEasyBeansFactory(this);
        instance.setEasyBeansInvocationContextFactory(this.getInvocationContextFactory());
        EasyBeansSessionContext<SessionFactory> sessionContext = new EasyBeansSessionContext<SessionFactory>(this);
        instance.setEasyBeansContext(sessionContext);
        oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            this.injectResources(instance);
            this.postConstruct(instance);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return (PoolType)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBResponse rpcInvoke(EJBRemoteRequest request) {
        Method calledMethod = this.getHashes().get(request.getMethodHash());
        if (calledMethod == null) {
            logger.debug("Requested method {0} is not present on the bean class ''{1}''", request.getMethodName(), this.getBeanClass());
            return new JEJBResponse();
        }
        String methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(calledMethod);
        Object[] args = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            args = request.getMethodArgs();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        AbstractEventBeanInvocation event = new EventBeanInvocationBegin(methodEventProviderId, args);
        long number = event.getInvocationNumber();
        this.getEventDispatcher().dispatch(event);
        try {
            Object value;
            EJBLocalRequestImpl localRequest = new EJBLocalRequestImpl(request.getMethodHash(), args, request.getBeanId(), request.getInvokedBusinessInterfaceName());
            EJBResponse result = this.localCall(localRequest);
            event = new EventBeanInvocationEnd(methodEventProviderId, number, result);
            if (RECREATE_DYNAMIC_PROXY && (value = result.getValue()) != null) {
                try {
                    InvocationHandler handler = Proxy.getInvocationHandler(value);
                    if (handler instanceof ClientRPCInvocationHandler && ((ClientRPCInvocationHandler)handler).isBusinessObjectMode()) {
                        result.setValue(handler);
                        EJBResponse eJBResponse = result;
                        return eJBResponse;
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Not a proxy instance", e);
                }
            }
            EJBResponse eJBResponse = result;
            return eJBResponse;
        }
        catch (Exception ex) {
            event = new EventBeanInvocationError(methodEventProviderId, number, ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.getEventDispatcher().dispatch(event);
        }
    }

    protected abstract PoolType getBean(Long var1) throws IllegalArgumentException;

    @Override
    public abstract EJBResponse localCall(EJBLocalRequest var1);

    protected InheritableThreadLocal<String> getInvokedBusinessInterfaceNameThreadLocal() {
        return this.invokedBusinessInterfaceNameThreadLocal;
    }
}

