/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.container.EZBEJBContext;
import org.ow2.easybeans.api.interceptor.EZBInterceptorManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansInterceptorManager
implements EZBInterceptorManager {
    private static Log logger = LogFactory.getLog(EasyBeansInterceptorManager.class);
    private Map<String, Object> interceptorInstances;
    private ClassLoader classLoader = null;
    private EZBEJBContext<?> easyBeansContext;

    public EasyBeansInterceptorManager(List<String> classnameList, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.interceptorInstances = new HashMap<String, Object>();
        this.initInterceptors(classnameList);
    }

    protected void initInterceptors(List<String> classnameList) {
        for (String classname : classnameList) {
            Class<?> interceptorClass = null;
            try {
                interceptorClass = this.classLoader.loadClass(classname.replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The class '" + classname + "' was not found.", e);
            }
            try {
                this.interceptorInstances.put(classname, interceptorClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Unable to build an instance of the class '" + classname + "'.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to build an instance of the class '" + classname + "'.", e);
            }
        }
    }

    @Override
    public void injectedByEasyBeans() {
        for (Object interceptor : this.interceptorInstances.values()) {
            Method setEZBContextMethod = null;
            try {
                setEZBContextMethod = interceptor.getClass().getDeclaredMethod("setEasyBeansContext", EZBEJBContext.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Unable to get setEasyBeansContext method", e);
            }
            catch (NoSuchMethodException e) {
                logger.debug("Unable to get setEasyBeansContext method", e);
            }
            if (setEZBContextMethod != null) {
                try {
                    setEZBContextMethod.invoke(interceptor, this.getEasyBeansContext());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unable to call setEasyBeansContext method", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unable to call setEasyBeansContext method", e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Unable to call setEasyBeansContext method", e);
                }
            }
            Method injectedByEasyBeansMethod = null;
            try {
                injectedByEasyBeansMethod = interceptor.getClass().getDeclaredMethod("injectedByEasyBeans", new Class[0]);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Unable to get injectedByEasyBeans method", e);
            }
            catch (NoSuchMethodException e) {
                logger.debug("Unable to get injectedByEasyBeans method", e);
            }
            if (injectedByEasyBeansMethod == null) continue;
            try {
                injectedByEasyBeansMethod.invoke(interceptor, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to call injectedByEasyBeans method", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to call injectedByEasyBeans method", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Unable to call injectedByEasyBeans method", e);
            }
        }
    }

    @Override
    public EZBEJBContext<?> getEasyBeansContext() {
        return this.easyBeansContext;
    }

    @Override
    public void setEasyBeansContext(EZBEJBContext<?> ezbejbcontext) {
        this.easyBeansContext = ezbejbcontext;
    }

    @Override
    public Object getInterceptor(String classname) {
        Object o = this.interceptorInstances.get(classname);
        if (o == null) {
            throw new IllegalStateException("Unable to find the interceptor with the classname '" + classname + "'");
        }
        return o;
    }
}

