/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.lib;

import java.util.LinkedList;
import java.util.List;
import org.ow2.easybeans.asm.AnnotationVisitor;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.enhancer.lib.AnnotationEnumerationValue;
import org.ow2.easybeans.enhancer.lib.AnnotationPrimitiveValue;
import org.ow2.easybeans.enhancer.lib.ArrayAnnotationRecorder;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class AnnotationRecorder
implements AnnotationVisitor {
    private Log logger = LogFactory.getLog(AnnotationRecorder.class);
    private String name = null;
    private String desc = null;
    private boolean visible = false;
    private List<AnnotationPrimitiveValue> primitiveValues = null;
    private List<AnnotationEnumerationValue> enumerationValues = null;
    private List<AnnotationRecorder> nestedValues = null;
    private List<ArrayAnnotationRecorder> arrayValues = null;

    public AnnotationRecorder(String name, boolean visible) {
        this(name);
        this.visible = visible;
    }

    public AnnotationRecorder(String name, String desc) {
        this(name);
        this.desc = desc;
    }

    public AnnotationRecorder(String name) {
        this.name = name;
        this.primitiveValues = new LinkedList<AnnotationPrimitiveValue>();
        this.enumerationValues = new LinkedList<AnnotationEnumerationValue>();
        this.nestedValues = new LinkedList<AnnotationRecorder>();
        this.arrayValues = new LinkedList<ArrayAnnotationRecorder>();
    }

    public void visit(String name, Object value) {
        this.primitiveValues.add(new AnnotationPrimitiveValue(name, value));
    }

    public void visitEnum(String name, String desc, String value) {
        this.enumerationValues.add(new AnnotationEnumerationValue(name, desc, value));
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationRecorder annotationRecorder = new AnnotationRecorder(name, desc);
        this.nestedValues.add(annotationRecorder);
        return annotationRecorder;
    }

    public AnnotationVisitor visitArray(String name) {
        ArrayAnnotationRecorder arrayAnnotationRecorder = new ArrayAnnotationRecorder(name);
        this.arrayValues.add(arrayAnnotationRecorder);
        return arrayAnnotationRecorder;
    }

    public void visitEnd() {
    }

    public void replay(MethodVisitor methodVisitor) {
        AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation(this.name, this.visible);
        this.logger.debug("AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation({0}, {1});", this.name, this.visible);
        this.replayInner(annotationVisitor);
        annotationVisitor.visitEnd();
        this.logger.debug("annotationVisitor.visitEnd();", new Object[0]);
    }

    public void replay(AnnotationVisitor annotationVisitor) {
        AnnotationVisitor av = annotationVisitor.visitAnnotation(this.name, this.desc);
        this.logger.debug("AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation({0}, {1});", this.name, this.desc);
        this.replayInner(av);
        av.visitEnd();
        this.logger.debug("annotationVisitor.visitEnd()", new Object[0]);
    }

    protected void replayInner(AnnotationVisitor annotationVisitor) {
        for (AnnotationPrimitiveValue primitiveValue : this.primitiveValues) {
            primitiveValue.visit(annotationVisitor);
        }
        for (AnnotationEnumerationValue enumerationValue : this.enumerationValues) {
            enumerationValue.visit(annotationVisitor);
        }
        for (AnnotationRecorder nestedAnnotation : this.nestedValues) {
            nestedAnnotation.replay(annotationVisitor);
        }
        for (ArrayAnnotationRecorder arrayAnnotationRecorder : this.arrayValues) {
            arrayAnnotationRecorder.replay(annotationVisitor);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public Log getLogger() {
        return this.logger;
    }
}

