/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.easybeans.component.itf.RegistryComponent;
import org.ow2.easybeans.jmx.JMXRemoteException;
import org.ow2.easybeans.jmx.MBeanServerHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JMXRemoteHelper {
    private static Log logger = LogFactory.getLog(JMXRemoteHelper.class);
    private static JMXConnectorServer jmxConnectorServer = null;
    private static final String PREFIX_URL_SERVICE = "service:jmx:";
    private static final String SUFFIX_URL_SERVICE = ":///jndi/";
    private static final String DEFAULT_RMI = "rmi://localhost:1099";
    private static final String SUFFIX_URL = "/EasyBeansConnector";
    private static final String DEFAULT_NAME_CONNECTOR = "connectors:name=JMXRemoteConnector";

    private JMXRemoteHelper() {
    }

    private static void init(RegistryComponent registryComponent) throws JMXRemoteException {
        HashMap<String, String> environment = new HashMap<String, String>();
        JMXServiceURL jmxServiceURL = null;
        StringBuilder sb = new StringBuilder(PREFIX_URL_SERVICE);
        URI providerURI = null;
        if (registryComponent != null) {
            try {
                providerURI = new URI(registryComponent.getProviderURL());
            }
            catch (URISyntaxException e) {
                throw new JMXRemoteException("Cannot get URL from registry component", e);
            }
        }
        try {
            providerURI = new URI(DEFAULT_RMI);
        }
        catch (URISyntaxException e) {
            throw new JMXRemoteException("Cannot get URL from 'rmi://localhost:1099'", e);
        }
        String protocol = providerURI.getScheme();
        String protocolName = "rmi";
        if ("iiop".equals(protocol)) {
            protocolName = "iiop";
        }
        sb.append(protocolName);
        sb.append(SUFFIX_URL_SERVICE);
        sb.append(protocolName);
        sb.append("://localhost:");
        sb.append(providerURI.getPort());
        sb.append(SUFFIX_URL);
        String url = sb.toString();
        try {
            jmxServiceURL = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            throw new JMXRemoteException("Cannot create jmxservice url with url '" + url + "'.", e);
        }
        environment.put("jmx.remote.jndi.rebind", "true");
        try {
            jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceURL, environment, MBeanServerHelper.getMBeanServerServer());
        }
        catch (IOException e) {
            throw new JMXRemoteException("Cannot create new JMX Connector", e);
        }
        logger.info("Creating JMXRemote connector with URL ''{0}''", url);
    }

    public static synchronized void startConnector(RegistryComponent registryComponent) throws JMXRemoteException {
        if (jmxConnectorServer == null) {
            JMXRemoteHelper.init(registryComponent);
        }
        ObjectName connectorServerName = JMXRemoteHelper.getConnectorObjectName();
        try {
            MBeanServerHelper.getMBeanServerServer().registerMBean(jmxConnectorServer, connectorServerName);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new JMXRemoteException("Cannot register Mbean with the name '" + connectorServerName + "'", e);
        }
        catch (MBeanRegistrationException e) {
            throw new JMXRemoteException("Cannot register Mbean with the name '" + connectorServerName + "'", e);
        }
        catch (NotCompliantMBeanException e) {
            throw new JMXRemoteException("Cannot register Mbean with the name '" + connectorServerName + "'", e);
        }
        try {
            jmxConnectorServer.start();
        }
        catch (IOException e) {
            throw new JMXRemoteException("Cannot start the jmx connector", e);
        }
    }

    public static synchronized void stopConnector() throws JMXRemoteException {
        if (jmxConnectorServer != null) {
            ObjectName connectorServerName = JMXRemoteHelper.getConnectorObjectName();
            try {
                jmxConnectorServer.stop();
                MBeanServerHelper.getMBeanServerServer().unregisterMBean(connectorServerName);
                jmxConnectorServer = null;
            }
            catch (InstanceNotFoundException e) {
                throw new JMXRemoteException("Cannot unregister JMX Connector with name '" + connectorServerName + "'", e);
            }
            catch (MBeanRegistrationException e) {
                throw new JMXRemoteException("Cannot unregister JMX Connector with name '" + connectorServerName + "'", e);
            }
            catch (IOException e) {
                throw new JMXRemoteException("Cannot Stop JMX Connector with name '" + connectorServerName + "'", e);
            }
        }
    }

    private static ObjectName getConnectorObjectName() throws JMXRemoteException {
        ObjectName connectorServerName = null;
        String objName = null;
        try {
            objName = DEFAULT_NAME_CONNECTOR;
            connectorServerName = new ObjectName(objName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXRemoteException("Cannot create ObjectName with name '" + objName + "'", e);
        }
        catch (NullPointerException e) {
            throw new JMXRemoteException("Cannot create ObjectName with name '" + objName + "'", e);
        }
        return connectorServerName;
    }
}

