/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.db.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.hsqldb.Server;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.db.DBService;
import org.ow2.jonas.db.base.AbsDBServiceImpl;
import org.ow2.jonas.db.base.AbsDBServiceImplMBean;
import org.ow2.jonas.db.base.User;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDBServiceImpl
extends AbsDBServiceImpl
implements DBService,
AbsDBServiceImplMBean {
    private List<User> users = null;
    private String databaseName = null;
    private static final String DEFAULT_PORT = "9001";
    private static final int SLEEP_VALUE = 100;
    private static final int MAX_RETRY_NB = 20;
    private String portNumber = null;
    private Server server = null;

    @Override
    protected void initServer(List<User> users, String databaseName, String portNumber) {
        this.users = users;
        this.portNumber = portNumber != null ? portNumber : DEFAULT_PORT;
        this.databaseName = databaseName;
        String jBase = JProp.getJonasBase();
        this.server = new Server();
        if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) {
            this.server.setLogWriter(null);
            this.server.setErrWriter(null);
            this.server.setSilent(true);
            this.server.setTrace(false);
            this.server.setLogWriter(null);
        } else {
            this.server.setSilent(false);
            this.server.setTrace(true);
        }
        String baseDir = jBase + File.separator + "work" + File.separator + "hsqldb" + File.separator + databaseName;
        String pString = "";
        if (portNumber != null) {
            pString = ";port=" + portNumber;
        }
        String serverProps = "database.0=" + baseDir + ";dbname.0=" + databaseName + pString;
        this.server.putPropertiesFromString(serverProps);
    }

    @Override
    protected void doStart() throws ServiceException {
        block16: {
            super.doStart();
            if (HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.INFO)) {
                HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)("Starting " + this.server.getProductName() + " " + this.server.getProductVersion() + " on port " + this.portNumber));
            }
            if (HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) {
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("serverState=" + this.server.getState()));
            }
            this.server.start();
            int retryNb = 0;
            while (this.server.getState() != 1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    HsqlDBServiceImpl.getLogger().log(BasicLevel.ERROR, (Object)"Can't wait that the service is online", (Throwable)ie);
                }
                if (this.server.getState() == 16 && ++retryNb >= 20) {
                    Throwable t = this.server.getServerError();
                    throw new ServiceException("The server was shutdown :", t);
                }
                if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) continue;
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("retry=" + retryNb + ", serverState=" + this.server.getState()));
            }
            HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)(this.server.getProductName() + " started."));
            Connection conn = null;
            Statement st = null;
            try {
                Class.forName("org.hsqldb.jdbcDriver");
                conn = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost:" + this.portNumber + "/" + this.databaseName, "sa", "");
                st = conn.createStatement();
            }
            catch (Exception e) {
                throw new ServiceException("Cannot access to HSQL", e);
            }
            User user2 = null;
            String userName = null;
            String password = null;
            ResultSet rs = null;
            for (User user2 : this.users) {
                try {
                    block15: {
                        password = user2.getPassword();
                        userName = user2.getUserName();
                        HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)("Dropping and adding user '" + userName + "' with password '" + password + "'."));
                        try {
                            rs = st.executeQuery("DROP USER " + userName);
                        }
                        catch (Exception ee) {
                            if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) break block15;
                            HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)("User '" + userName + "' doesn't exists"), (Throwable)ee);
                        }
                    }
                    rs = st.executeQuery("Create USER " + userName + " PASSWORD " + password + " ADMIN");
                    rs.close();
                }
                catch (Exception e) {
                    HsqlDBServiceImpl.getLogger().log(BasicLevel.ERROR, (Object)"Error while creating/adding user", (Throwable)e);
                }
            }
            try {
                st.close();
            }
            catch (Exception e) {
                if (!HsqlDBServiceImpl.getLogger().isLoggable(BasicLevel.DEBUG)) break block16;
                HsqlDBServiceImpl.getLogger().log(BasicLevel.DEBUG, (Object)"Error while closing statement object", (Throwable)e);
            }
        }
    }

    @Override
    protected void doStop() throws ServiceException {
        super.doStop();
        this.server.shutdown();
        HsqlDBServiceImpl.getLogger().log(BasicLevel.INFO, (Object)(this.server.getProductName() + " stopped."));
    }
}

