/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EjbRelationshipRoleDesc;
import org.ow2.jonas.deployment.ejb.EntityCmpDesc;
import org.ow2.jonas.deployment.ejb.FieldDesc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.deployment.ejb.MethodCmp2Desc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.ejbql.ParseException;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;
import org.ow2.jonas.deployment.ejb.xml.Query;
import org.ow2.jonas.lib.util.BeanNaming;

public abstract class EntityCmp2Desc
extends EntityCmpDesc {
    private ArrayList ejbRelationshipRoleDesc = new ArrayList();
    protected String abstractSchemaName;
    private static final String JORM_PACKAGE = "jorm";
    private String jormClassName = null;
    private String jormFQClassName = null;
    private String jormAccessorClassName = null;
    private String jormPKClassName = null;
    private String jormPNameGetterClassName = null;
    private String jormBinderClassName = null;
    protected String factoryClassName = null;
    protected DeploymentDescEjb2 dc2d = null;

    public EntityCmp2Desc(ClassLoader classLoader, Entity ent, AssemblyDescriptor asd, JonasEntity jEnt, DeploymentDescEjb2 dc2d, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, ent, asd, jEnt, jMDRList, fileName);
        this.dc2d = dc2d;
        if (ent.getAbstractSchemaName() == null || ent.getAbstractSchemaName().length() == 0) {
            throw new DeploymentDescException("abstract-schema-name must be provided for bean " + this.ejbName);
        }
        this.abstractSchemaName = ent.getAbstractSchemaName();
        if (this.fieldDesc.isEmpty()) {
            throw new DeploymentDescException("No cmp-field defined in bean " + this.ejbName);
        }
        for (String fn : this.fieldDesc.keySet()) {
            try {
                Field f = this.ejbClass.getField(fn);
                throw new DeploymentDescException("In cmp-version 2.x, field-name " + fn + " should not be defined in bean " + this.ejbName);
            }
            catch (NoSuchFieldException e) {
            }
            catch (SecurityException e) {
                throw new DeploymentDescException("Cannot use java reflexion on " + this.ejbClass.getName());
            }
            try {
                Method getter = null;
                try {
                    getter = this.ejbClass.getMethod(FieldDesc.getGetterName(fn), null);
                    ((FieldDesc)this.fieldDesc.get(fn)).setFieldType(getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    throw new DeploymentDescException("Getter method not found for field-name " + fn + " in bean " + this.ejbName, e);
                }
                try {
                    this.ejbClass.getMethod(FieldDesc.getSetterName(fn), getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    throw new DeploymentDescException("Setter method not found for field-name " + fn + " in bean " + this.ejbName, e);
                }
            }
            catch (SecurityException e) {
                throw new DeploymentDescException("Cannot use java reflexion on " + this.ejbClass.getName());
            }
        }
        if (jEnt.getIsModifiedMethodName() != null) {
            throw new DeploymentDescException("use of is-modified-method-name deprecated for CMP 2.x");
        }
        if (ent.getQueryList() != null) {
            for (Query q : ent.getQueryList()) {
                boolean foundMatch = false;
                Iterator j = this.getMethodDescIterator();
                while (j.hasNext()) {
                    String methName;
                    MethodDesc methd = (MethodDesc)j.next();
                    if (methd.matchPattern(null, methName = q.getQueryMethod().getMethodName(), q.getQueryMethod().getMethodParams()) == 0) continue;
                    foundMatch = true;
                    String query = q.getEjbQl();
                    if (!(methd instanceof MethodCmp2Desc)) {
                        throw new DeploymentDescException("ejbql query " + query + " can't apply to method " + methName + " in bean " + this.ejbName);
                    }
                    try {
                        ((MethodCmp2Desc)methd).setQuery(query);
                    }
                    catch (ParseException e) {
                        throw new DeploymentDescException("Invalid ejbql syntax for bean " + this.ejbName + ":\n" + e.getMessage(query));
                    }
                    if (q.getResultTypeMapping() == null) continue;
                    ((MethodCmp2Desc)methd).setResultTypeMapping(q.getResultTypeMapping());
                }
                if (foundMatch) continue;
                throw new DeploymentDescException("invalid query-method definition for bean " + this.ejbName + "\nno such method as " + MethodCmp2Desc.queryMethodElementToString(q.getQueryMethod()) + "\ncheck method name and method parameters");
            }
        }
        Iterator j = this.getMethodDescIterator();
        while (j.hasNext()) {
            MethodDesc md = (MethodDesc)j.next();
            if (!md.isFinder() && !md.isEjbSelect() || md.isFindByPrimaryKey() || ((MethodCmp2Desc)md).getQuery() != null) continue;
            throw new DeploymentDescException("query not defined for method " + MethodDesc.toString(md.getMethod()) + " of bean" + this.ejbName);
        }
        if (this.isUndefinedPK()) {
            FieldDesc fd = this.newFieldDescInstance();
            fd.setName("JONASAUTOPKFIELD");
            fd.setPrimaryKey(true);
            this.fieldDesc.put("JONASAUTOPKFIELD", fd);
            ((FieldDesc)this.fieldDesc.get("JONASAUTOPKFIELD")).setFieldType(Integer.class);
            ((FieldJdbcDesc)this.fieldDesc.get("JONASAUTOPKFIELD")).setJdbcFieldName(this.getJdbcAutomaticPkFieldName());
        }
    }

    public DeploymentDescEjb2 getDeploymentDescEjb2() {
        return this.dc2d;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    private String getJormCName() {
        if (this.jormClassName == null) {
            this.jormClassName = BeanNaming.firstToUpperCase(this.abstractSchemaName);
        }
        return this.jormClassName;
    }

    public String getJormClassName() {
        if (this.jormFQClassName == null) {
            this.jormFQClassName = BeanNaming.getClassName(JORM_PACKAGE, this.getJormCName());
        }
        return this.jormFQClassName;
    }

    public void addEjbRelationshipRoleDesc(EjbRelationshipRoleDesc ersrd) {
        this.ejbRelationshipRoleDesc.add(ersrd);
    }

    public Iterator getEjbRelationshipRoleDescIterator() {
        return this.ejbRelationshipRoleDesc.iterator();
    }

    public EjbRelationshipRoleDesc getEjbRelationshipRoleDesc(String cmr) {
        for (EjbRelationshipRoleDesc rsr : this.ejbRelationshipRoleDesc) {
            if (!rsr.hasCmrField() || !cmr.equals(rsr.getCmrFieldName())) continue;
            return rsr;
        }
        return null;
    }

    protected MethodDesc newMethodDescInstance(Method meth, Class classDef, int index) {
        return new MethodCmp2Desc(this, meth, classDef, index);
    }

    public String getJormAccessorClassName() {
        if (this.jormAccessorClassName == null) {
            this.jormAccessorClassName = BeanNaming.getClassName(JORM_PACKAGE, this.getJormCName() + "Accessor");
        }
        return this.jormAccessorClassName;
    }

    public String getJormBindingClassName() {
        return BeanNaming.getClassName(JORM_PACKAGE, this.getJormCName() + "Binding");
    }

    public String getJormStateClassName() {
        return BeanNaming.getClassName(JORM_PACKAGE, this.getJormCName() + "State");
    }

    public String getFactoryClassName() {
        return BeanNaming.getClassName(JORM_PACKAGE, "rdb." + this.getJormCName() + "Mapping");
    }

    public String getJormPKClassName() {
        if (!this.hasPrimaryKeyField() && this.jormPKClassName == null) {
            this.jormPKClassName = BeanNaming.getClassName(JORM_PACKAGE, BeanNaming.getBaseName(this.getPrimaryKeyClass().getName()));
        }
        return this.jormPKClassName;
    }

    public String getJormPNameGetterClassName() {
        if (!this.hasPrimaryKeyField() && this.jormPNameGetterClassName == null) {
            this.jormPNameGetterClassName = this.getJormPKClassName() + "PNG";
        }
        return this.jormPNameGetterClassName;
    }

    public String getJormBinderClassName() {
        if (this.jormBinderClassName == null) {
            this.jormBinderClassName = this.hasPrimaryKeyField() ? "org.objectweb.jorm.facility.naming.basidir.BasidBinder" : this.getJormPKClassName() + "Binder";
        }
        return this.jormBinderClassName;
    }

    public boolean needJormCoherenceHelper() {
        return this.ejbRelationshipRoleDesc.iterator().hasNext();
    }

    public String getJormCoherenceHelperItfName() {
        return "JOnAS" + this.ejbName + "CoherenceHelper";
    }

    public String getJormCoherenceHelperPackageName() {
        return BeanNaming.getPackageName(this.getFullDerivedBeanName());
    }

    public String getJormCoherenceHelperFQItfName() {
        String pn = this.getJormCoherenceHelperPackageName();
        return pn != null && pn.length() > 0 ? pn + "." + this.getJormCoherenceHelperItfName() : this.getJormCoherenceHelperItfName();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        Iterator i = this.ejbRelationshipRoleDesc.iterator();
        while (i.hasNext()) {
            ret.append("\nejbRelationshipRoleDesc[]=" + i.next());
        }
        ret.append("\ngetAbstractSchemaName()=" + this.getAbstractSchemaName());
        ret.append("\ngetJormAccessorClassName() = " + this.getJormAccessorClassName());
        ret.append("\nneedJormCoherenceHelper() = " + this.needJormCoherenceHelper());
        return ret.toString();
    }
}

