/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.eclipse.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.ow2.jonas.eclipse.compiler.CompilationContext;
import org.ow2.jonas.eclipse.compiler.CompilerError;
import org.ow2.jonas.eclipse.compiler.JOnASCompilationUnit;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASNameEnvironment
implements INameEnvironment {
    private static final Log log = LogFactory.getLog(JOnASNameEnvironment.class);
    private CompilationContext context;
    private List<CompilerError> errors;

    public JOnASNameEnvironment(CompilationContext context, List<CompilerError> errors) {
        this.context = context;
        this.errors = errors;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        String result = new String(CharOperation.concatWith(compoundTypeName, '.'));
        log.debug("------------- Entering: findType(type:{0})", result);
        return this.findType(result);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        String result = new String(CharOperation.concatWith(packageName, '.'));
        log.debug("------------- Entering: findType(package:{0}, typeName:{1})", result, new String(typeName));
        result = result + ".";
        result = result + new String(typeName);
        return this.findType(result);
    }

    private NameEnvironmentAnswer findType(String className) {
        try {
            log.debug("'" + className + "' processing", new Object[0]);
            String javaSource = className.replace(".", File.separator) + ".java";
            File f = new File(this.context.getSourceDirectory(), javaSource);
            if (f.exists()) {
                log.debug("Found matching java source file '{0}'", f);
                JOnASCompilationUnit compilationUnit = new JOnASCompilationUnit(className, f.getAbsolutePath(), this.context, this.errors);
                return new NameEnvironmentAnswer(compilationUnit, null);
            }
            String resourceName = className.replace('.', '/') + ".class";
            InputStream is = this.context.getContextualClassLoader().getResourceAsStream(resourceName);
            if (is == null) {
                log.debug("Didn't find the class resource '{0}'", resourceName);
                return null;
            }
            ClassFileReader classFileReader = ClassFileReader.read(is, resourceName);
            return new NameEnvironmentAnswer(classFileReader, null);
        }
        catch (IOException e) {
            this.errors.add(new CompilerError(className, e));
            return null;
        }
        catch (ClassFormatException e) {
            this.errors.add(new CompilerError(className, e));
            return null;
        }
    }

    @Override
    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        String result = "";
        if (parentPackageName != null) {
            result = new String(CharOperation.concatWith(parentPackageName, '.'));
        }
        log.debug("=============== Entering: isPackage(parent:{0}, name:{1})", result, new String(packageName));
        String str = new String(packageName);
        result = result + ".";
        result = result + str;
        return this.isPackage(result);
    }

    private boolean isPackage(String potentialPackage) {
        log.debug("isPackage({0})", potentialPackage);
        String javaSource = potentialPackage.replace(".", File.separator) + ".java";
        File f = new File(this.context.getSourceDirectory(), javaSource);
        if (f.exists()) {
            log.debug("Found a java file {0}", f);
            return false;
        }
        String resourceName = potentialPackage.replace('.', '/') + ".class";
        InputStream is = this.context.getContextualClassLoader().getResourceAsStream(resourceName);
        return is == null;
    }
}

