/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.eclipse.compiler.CompilationContext;
import org.ow2.jonas.eclipse.compiler.CompilerError;
import org.ow2.jonas.eclipse.compiler.JOnASCompiler;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.generator.AbsGenerator;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.util.I18n;

public abstract class Generator
extends AbsGenerator {
    private static I18n i18n = I18n.getInstance(Generator.class);

    public Generator(Config config) throws GenBaseException {
        super(config);
    }

    public abstract void generate() throws WsGenException;

    public void compile() throws WsGenException {
        ArrayList<String> sources = new ArrayList();
        sources = this.getJavaSources(this.getSources(), this.getSources());
        CompilationContext context = new CompilationContext();
        JClassLoader classLoader = new JClassLoader("WSGen", new URL[0], Thread.currentThread().getContextClassLoader());
        Generator.addClasspath(classLoader, this.getConfig().getClasspath());
        context.setContextualClassLoader(classLoader);
        context.setOutputDirectory(this.getClasses());
        context.setSourceDirectory(this.getSources());
        context.setSources(sources);
        JOnASCompiler compiler = new JOnASCompiler(context);
        List<CompilerError> errors = compiler.compile();
        if (!errors.isEmpty()) {
            for (CompilerError error : errors) {
                Generator.getLogger().log(BasicLevel.ERROR, (Object)error.toString());
            }
            throw new WsGenException("Failed when compiling classes");
        }
        Generator.getLogger().log(BasicLevel.INFO, (Object)"Sources classes successfully compiled with Eclipse compiler.");
        classLoader = null;
        context = null;
        compiler = null;
        System.gc();
    }

    private static void addClasspath(JClassLoader cl, String classpath) throws WsGenException {
        String[] elems = classpath.split(File.pathSeparator);
        for (int i = 0; i < elems.length; ++i) {
            try {
                cl.addURL(new File(elems[i]).toURL());
                continue;
            }
            catch (MalformedURLException e) {
                throw new WsGenException("Cannot create URL from '" + elems[i] + "'", e);
            }
        }
    }

    protected static I18n getI18n() {
        return i18n;
    }
}

