/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.modifier;

import java.io.File;
import java.util.List;
import java.util.jar.Attributes;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.Version;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsClientDDModifier;
import org.ow2.jonas.generators.wsgen.generator.GeneratorFactory;
import org.ow2.jonas.generators.wsgen.generator.WsClientGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientModifier
extends ArchiveModifier {
    private Client client;

    public ClientModifier(Client client) {
        super(client);
        this.client = client;
    }

    public Archive modify() throws GenBaseException {
        ClientModifier.getLogger().log(BasicLevel.INFO, (Object)("Processing Client " + this.client.getName()));
        Attributes main = this.client.getManifest().getMainAttributes();
        main.put(new Attributes.Name("WsGen-JOnAS-Version"), Version.getNumber());
        GeneratorFactory gf = GeneratorFactory.getInstance();
        Document jclient = this.client.getJonasClientDoc();
        List refs = this.client.getServiceRefDescs();
        for (ServiceRefDesc ref : refs) {
            Element base = null;
            if (jclient != null) {
                base = jclient.getDocumentElement();
            }
            WsClientDDModifier ddm = new WsClientDDModifier(ref.getServiceRefName(), jclient, base);
            WsClientGenerator g = gf.newGenerator(ref, ddm, this.client);
            g.generate();
            g.compile();
            g.addFiles(this.client);
            jclient = ddm.getDocument();
        }
        return this.save(gf.getConfiguration(), "clients" + File.separator + this.client.getRootFile().getName());
    }
}

