/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ha.internal;

import java.util.Stack;
import javax.ejb.EntityContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.ha.ReplicationManager;
import org.ow2.cmi.ha.ReplicationManagerImpl;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.cmi.ha.interceptor.jrmp.HAInterceptorInitializer;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.lib.ejb21.ha.JRepUtil;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

public class HaServiceImpl
extends AbsServiceImpl
implements HaService {
    private static final Logger logger = Log.getLogger("org.ow2.jonas.ha");
    private ReplicationManager replicationMgr;
    private HACurrent haCurrent;
    private CmiService cmiService;
    private int gcPeriod;
    private String datasource;
    private String jgroupsConf;
    private String jgroupsGroupname;
    private long reconnectionTimeout;

    public void setCmiService(CmiService cmiService) {
        this.cmiService = cmiService;
    }

    public void setGcPeriod(int gcPeriod) {
        this.gcPeriod = gcPeriod;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public void setJgroupsConf(String jgroupsConf) {
        this.jgroupsConf = jgroupsConf;
    }

    public void setJgroupsGroupname(String jgroupsGroupname) {
        this.jgroupsGroupname = jgroupsGroupname;
    }

    public void setReconnectionTimeout(long reconnectionTimeout) {
        this.reconnectionTimeout = reconnectionTimeout;
    }

    public void doStart() throws ServiceException {
        logger.log(BasicLevel.INFO, (Object)"Starting replication service...");
        try {
            this.replicationMgr = new ReplicationManagerImpl(this.gcPeriod, this.datasource, this.jgroupsConf, this.jgroupsGroupname, this.reconnectionTimeout);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Error during HA Service startup", (Throwable)e);
            throw new ServiceException("Error during HA Service startup", e);
        }
        this.haCurrent = HACurrent.getHACurrent();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("replicationMgr=" + this.replicationMgr));
            logger.log(BasicLevel.DEBUG, (Object)("haCurrent=" + this.haCurrent));
        }
        JRepUtil.setRepMgr(this.replicationMgr);
        try {
            ConfigurationRepository.addInterceptors("jrmp", HAInterceptorInitializer.class);
        }
        catch (ConfigurationException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot register the HA interceptors", (Throwable)e);
            throw new ServiceException("Cannot register the HA interceptors", e);
        }
        logger.log(BasicLevel.INFO, (Object)"Replication service started");
    }

    public void doStop() throws ServiceException {
        try {
            ConfigurationRepository.removeInterceptors("jrmp", HAInterceptorInitializer.class);
        }
        catch (ConfigurationException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unregister the HA interceptors", (Throwable)e);
            throw new ServiceException("Cannot unregister the HA interceptors", e);
        }
        this.replicationMgr.clear();
        logger.log(BasicLevel.INFO, (Object)"Replication service stopped");
    }

    public void replicateCommit(boolean committed) {
        RequestId reqId;
        Stack<RequestId> requests = this.haCurrent.getRequests();
        if (requests != null && requests.size() == 1 && (reqId = requests.peek()) != null) {
            try {
                this.replicationMgr.replicateCommit(reqId, committed);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)"Unable to replicate commit/abort", (Throwable)e);
            }
        }
    }

    public void replicate() {
        Stack<RequestId> requests = this.haCurrent.getRequests();
        if (requests != null && requests.size() == 1) {
            RequestId reqId = requests.peek();
            try {
                this.replicationMgr.replicate(reqId);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)"Unable to replicate", (Throwable)e);
            }
        }
    }

    public void addEntityBean(EntityContext jec) {
        Stack<RequestId> requests = this.haCurrent.getRequests();
        if (requests != null && !requests.isEmpty()) {
            RequestId rootId = (RequestId)requests.firstElement();
            JRepUtil.addEntityBean(jec, rootId);
        }
    }
}

