/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.io.FilenameFilter;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;

public class JOnASDeploymentPlanDeployer
implements DeploymentPlanDeployer {
    private IDeploymentPlanDeployer deploymentPlanDeployer = null;
    private ConfigurationManager configurationManager = null;
    private Log logger = LogFactory.getLog(JOnASDeploymentPlanDeployer.class);
    private static final String DEPLOYMENT_CONFIG_DIR = JProp.getConfDir() + File.separator + "deployment";

    public void deploy(String name) throws DeployerException {
        File file;
        String service = name;
        String baseName = this.getBaseName(service);
        if (baseName != null) {
            this.deploy(baseName);
            service = this.getImplementationName(service);
        }
        if (!(file = new File(DEPLOYMENT_CONFIG_DIR, service + ".xml")).exists()) {
            throw new DeployerException("Cannot deploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.deployDeploymentPlan(file);
    }

    public void undeploy(String name) throws DeployerException {
        File file;
        String service = name;
        String baseName = this.getBaseName(service);
        if (baseName != null) {
            this.undeploy(baseName);
            service = this.getImplementationName(service);
        }
        if (!(file = new File(DEPLOYMENT_CONFIG_DIR, service + ".xml")).exists()) {
            throw new DeployerException("Cannot undeploy the deployment plan '" + name + "', file '" + file + "' not found");
        }
        this.undeployDeploymentPlan(file);
    }

    private void deployDeploymentPlan(File file) throws DeployerException {
        this.logger.debug("Deploying the deployment plan for ''{0}''", file);
        IArchive archive = ArchiveManager.getInstance().getArchive(file);
        if (archive == null) {
            throw new DeployerException("Ignoring invalid file '" + file + "'");
        }
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(archive);
            this.deploymentPlanDeployer.deploy(deployable);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the deployment plan for '" + file + "'", e);
        }
    }

    private void undeployDeploymentPlan(File file) throws DeployerException {
        this.logger.debug("Undeploying the deployment plan for ''{0}''", file);
        IArchive archive = ArchiveManager.getInstance().getArchive(file);
        if (archive == null) {
            throw new DeployerException("Ignoring invalid file '" + file + "'");
        }
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(archive);
            this.deploymentPlanDeployer.undeploy(deployable);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the deployment plan for '" + file + "'", e);
        }
    }

    public void setDeploymentPlanDeployer(IDeploymentPlanDeployer deploymentPlanDeployer) {
        this.deploymentPlanDeployer = deploymentPlanDeployer;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    private String getImplementationName(String service) {
        String serviceClass = this.configurationManager.getServiceProperties(service).get("class");
        String implementationName = serviceClass.split("\\.")[4];
        return service + "-" + implementationName;
    }

    private String getBaseName(String service) {
        File configDir = new File(DEPLOYMENT_CONFIG_DIR);
        final String baseName = service + "-base";
        File[] base = configDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase(baseName.concat(".xml"));
            }
        });
        if (base.length == 1) {
            return baseName;
        }
        return null;
    }
}

