/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.security;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.ow2.jonas.deployment.web.ServletDesc;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.security.auth.JSigned;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.auth.callback.NoInputCallbackHandler;
import org.ow2.jonas.security.realm.factory.JResource;
import org.ow2.jonas.security.realm.factory.JResourceException;
import org.ow2.jonas.security.realm.principal.JUser;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Realm
extends RealmBase
implements Cloneable {
    private static final String NAME = Realm.class.getSimpleName();
    private static final String INFO = Realm.class.getName() + "/1.0";
    private static final String JAAS_CONFIG_NAME = "tomcat";
    private static StringManager sm = StringManager.getManager((String)"org.apache.catalina.realm");
    private static Log logger = LogFactory.getLog(Realm.class);
    private JResource jResource = null;
    private String resourceName = null;
    private SecurityService securityService = null;
    private PermissionManager permissionManager = null;
    private ThreadLocal<Request> lastRequestThread = new ThreadLocal();
    private Context context = null;
    private String realmName = NAME;

    public String getInfo() {
        return INFO;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        return super.findSecurityConstraints(request, context);
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        this.lastRequestThread.set(request);
        LoginConfig config = context.getLoginConfig();
        if (config != null && "FORM".equals(config.getAuthMethod())) {
            String requestURI = request.getDecodedRequestURI();
            String loginPage = context.getPath() + config.getLoginPage();
            if (loginPage.equals(requestURI)) {
                logger.debug("{0}: Allow access to login page {1}", this.realmName, loginPage);
                return true;
            }
            String errorPage = context.getPath() + config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                logger.debug("{0}: Allow access to error page {1}", this.realmName, errorPage);
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                logger.debug("{0}: Allow access to username/password submission", this.realmName);
                return true;
            }
        }
        Principal principal = request.getUserPrincipal();
        String[] roles = null;
        String principalName = null;
        if (principal instanceof GenericPrincipal) {
            roles = ((GenericPrincipal)principal).getRoles();
            principalName = principal.getName();
        }
        if (this.permissionManager == null) {
            logger.error("{0}: No permission manager is set. Realm used without using the JOnAS deployer but only Tomcat.", this.realmName);
            return false;
        }
        boolean hasResourcePermission = this.permissionManager.checkWebResourcePermission((HttpServletRequest)request, principalName, roles);
        if (!hasResourcePermission) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return hasResourcePermission;
    }

    public boolean hasRole(Principal principal, String role) {
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{0}: Principal = {1}", this.realmName, principal);
            logger.debug("{0}: Role = {1}", this.realmName, role);
        }
        if (this.context == null) {
            logger.error("{0}: Cannot find a servlet name for isUserInRole() as no context was found", this.realmName);
            return false;
        }
        Request req = this.lastRequestThread.get();
        if (req == null) {
            logger.error("{0}: Cannot find a servlet name for isUserInRole(). No previous request !", this.realmName);
            return false;
        }
        String servletName = this.findServletName(req);
        String[] roles = null;
        String principalName = null;
        if (principal instanceof GenericPrincipal) {
            roles = ((GenericPrincipal)principal).getRoles();
            principalName = principal.getName();
        }
        if (this.permissionManager == null) {
            logger.error("{0}: No permission manager is set. Using this realm without using the JOnAS deployer but only Tomcat.", this.realmName);
            return false;
        }
        boolean hasRole = this.permissionManager.checkWebRoleRefPermission((HttpServletRequest)req, servletName, principalName, roles, role);
        return hasRole;
    }

    private String findServletName(Request request) {
        if (request == null || request.getRequestURI() == null || request.getContextPath() == null) {
            return null;
        }
        String userPattern = request.getRequestURI().substring(request.getContextPath().length());
        if (logger.isDebugEnabled()) {
            logger.debug("{0}: User Pattern = {1}", this.realmName, userPattern);
        }
        String servletName = "";
        String[] patterns = this.context.findServletMappings();
        boolean foundServlet = false;
        String pattern = "";
        int i = 0;
        while (i < patterns.length && !foundServlet) {
            pattern = patterns[i];
            if (logger.isDebugEnabled()) {
                logger.debug("{0}: Pattern found = {1}", this.realmName, pattern);
                logger.debug("{0}: Servlet name for pattern = {1}", this.realmName, this.context.findServletMapping(pattern));
            }
            if (pattern.startsWith("*.") && userPattern.endsWith(pattern.substring(1))) {
                foundServlet = true;
                continue;
            }
            if (pattern.equals(userPattern)) {
                foundServlet = true;
                continue;
            }
            ++i;
        }
        if (foundServlet) {
            servletName = this.context.findServletMapping(pattern);
            if (servletName.equals("jsp")) {
                servletName = "";
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{0}: Found servlet name = {1}", this.realmName, servletName);
            }
        }
        return servletName;
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        this.lastRequestThread.set(request);
        if (request.getRequest().isSecure()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{0}: User data constraint already satisfied", this.realmName);
            }
            return true;
        }
        Principal principal = request.getUserPrincipal();
        String[] roles = null;
        String principalName = null;
        if (principal instanceof GenericPrincipal) {
            roles = ((GenericPrincipal)principal).getRoles();
            principalName = principal.getName();
        }
        for (int i = 0; i < constraints.length; ++i) {
            String queryString;
            SecurityConstraint constraint = constraints[i];
            String userConstraint = constraint.getUserConstraint();
            if (userConstraint == null || !userConstraint.equals("INTEGRAL") && !userConstraint.equals("CONFIDENTIAL")) continue;
            int redirectPort = request.getConnector().getRedirectPort();
            if (redirectPort <= 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{0}: SSL redirect is disabled", this.realmName);
                }
                response.sendError(403, request.getRequestURI());
                return false;
            }
            StringBuffer file = new StringBuffer();
            String protocol = "https";
            String host = request.getServerName();
            file.append(protocol).append("://");
            file.append(host).append(":").append(redirectPort);
            file.append(request.getRequestURI());
            String requestedSessionId = request.getRequestedSessionId();
            if (requestedSessionId != null && request.isRequestedSessionIdFromURL()) {
                file.append(";jsessionid=");
                file.append(requestedSessionId);
            }
            if ((queryString = request.getQueryString()) != null) {
                file.append('?');
                file.append(queryString);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{0}: Redirecting to {1}", this.realmName, file);
            }
            response.sendRedirect(file.toString());
            return false;
        }
        if (this.permissionManager == null) {
            logger.error("{0}: No permission manager is set. Realm used without using the JOnAS deployer but only Tomcat.", this.realmName);
            return false;
        }
        boolean hasUserDataPermission = this.permissionManager.checkWebUserDataPermission((HttpServletRequest)request, principalName, roles);
        return hasUserDataPermission;
    }

    public Principal authenticate(String username, String credentials) {
        if (this.jResource != null) {
            return this.authenticateResource(username, credentials);
        }
        return this.authenticateJAAS(username, credentials);
    }

    public Principal authenticateResource(String username, String credentials) {
        if (username == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{0}: No username so no authentication", this.realmName);
            }
            return null;
        }
        JUser user = null;
        try {
            user = this.jResource.findUser(username);
        }
        catch (Exception jre) {
            logger.error("{0}: Cannot find the user {1}", this.realmName, username, jre);
            return null;
        }
        if (user == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{0}: User {1} not found.", this.realmName, username);
            }
            return null;
        }
        boolean validated = this.jResource.isValidUser(user, credentials);
        if (!validated) {
            logger.error("{0}: The password for the user {1} is not valid", this.realmName, username);
            return null;
        }
        ArrayList<String> combinedRoles = null;
        try {
            combinedRoles = this.jResource.getArrayListCombinedRoles(user);
        }
        catch (JResourceException jre) {
            logger.error("{0}: Cannot get the roles from the user {1}", this.realmName, username, jre);
            return null;
        }
        GenericPrincipal principal = new GenericPrincipal((org.apache.catalina.Realm)this, user.getName(), user.getPassword(), combinedRoles);
        SecurityContext ctx = new SecurityContext(principal.getName(), combinedRoles);
        Request request = this.lastRequestThread.get();
        String servletName = this.findServletName(request);
        if (servletName != null) {
            WebContainerDeploymentDesc webDD = ((JOnASStandardContext)this.context).getWebDeploymentDescriptor();
            Collection<ServletDesc> servletDescList = webDD.getServletDescList();
            for (ServletDesc servletDesc : servletDescList) {
                if (!servletDesc.getServletName().equals(servletName)) continue;
                if (servletDesc.getServletRunAS() == null) break;
                String role = servletDesc.getServletRunAS().getRoleName();
                String principalName = webDD.getServletPrincipalName(servletName);
                if (principalName == null) {
                    principalName = role;
                }
                ctx.pushRunAs(role, principalName, new String[]{role});
                break;
            }
        }
        SecurityCurrent current = SecurityCurrent.getCurrent();
        current.setSecurityContext(ctx);
        return principal;
    }

    public Principal authenticateJAAS(String username, String credentials) {
        if (username == null) {
            logger.error("{0}: No username so no authentication", this.realmName);
            return null;
        }
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(JAAS_CONFIG_NAME, new NoInputCallbackHandler(username, credentials));
        }
        catch (LoginException e) {
            logger.error("{0}: LoginException for user {1}", this.realmName, username, e);
            return null;
        }
        Subject subject = null;
        try {
            loginContext.login();
            subject = loginContext.getSubject();
            if (subject == null) {
                logger.error("{0}: No subject for the user {1}", this.realmName, username);
                return null;
            }
        }
        catch (AccountExpiredException e) {
            logger.error("{0}: Account expired for the user {1}", this.realmName, username, e);
            return null;
        }
        catch (CredentialExpiredException e) {
            logger.error("{0}: Credential expired for the user {1}", this.realmName, username, e);
            return null;
        }
        catch (FailedLoginException e) {
            logger.error("{0}: Failed Login for the user {1}", this.realmName, username, e);
            return null;
        }
        catch (LoginException e) {
            logger.error("{0}: Login exception for the user {1}", this.realmName, username, e);
            return null;
        }
        Iterator<Object> credentialsIterator = subject.getPrivateCredentials().iterator();
        String credential = (String)credentialsIterator.next();
        Iterator<Principal> iterator = subject.getPrincipals(Principal.class).iterator();
        String userName = null;
        while (iterator.hasNext() && userName == null) {
            Principal principal = iterator.next();
            if (principal instanceof Group) continue;
            userName = principal.getName();
        }
        if (userName == null) {
            logger.error("{0}: No Username found in the subject", this.realmName);
            return null;
        }
        JSigned jSigned = null;
        Set<Group> groups = subject.getPrincipals(Group.class);
        ArrayList<String> roles = new ArrayList<String>();
        for (Group group : groups) {
            if (group instanceof JSigned) {
                jSigned = (JSigned)group;
                continue;
            }
            Enumeration e = group.members();
            while (e.hasMoreElements()) {
                Principal p = (Principal)e.nextElement();
                roles.add(p.getName());
            }
        }
        GenericPrincipal principal = new GenericPrincipal((org.apache.catalina.Realm)this, userName, credential, roles);
        SecurityContext ctx = new SecurityContext(userName, roles);
        if (jSigned != null) {
            ctx.setSignature(jSigned.getSignature());
        }
        SecurityCurrent current = SecurityCurrent.getCurrent();
        current.setSecurityContext(ctx);
        return principal;
    }

    public Principal authenticate(X509Certificate[] cert) {
        String dn = cert[0].getSubjectDN().getName();
        return this.authenticate(dn, JAAS_CONFIG_NAME);
    }

    protected String getName() {
        return NAME;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    public void setContext(Context context) {
        this.context = context;
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(NAME);
        sb.append(":");
        sb.append(this.resourceName);
        sb.append(":");
        if (context != null) {
            sb.append(context.getName());
        }
        sb.append("] ");
        this.realmName = sb.toString();
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public synchronized void start() throws LifecycleException {
        if (this.resourceName != null) {
            if (this.securityService == null) {
                throw new LifecycleException("Security service not set, cannot start");
            }
            this.jResource = this.securityService.getJResource(this.resourceName);
            if (this.jResource == null) {
                throw new LifecycleException("Can't retrieve resource '" + this.resourceName + "' from the security service");
            }
        }
        super.start();
    }

    public synchronized void stop() throws LifecycleException {
        super.stop();
        this.jResource = null;
    }

    public Object clone() throws CloneNotSupportedException {
        Realm jRealm = new Realm();
        jRealm.setResourceName(this.resourceName);
        jRealm.setSecurityService(this.securityService);
        return jRealm;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }
}

