/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.configuration.EngineConfigurationFactoryServlet;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.utils.XMLUtils;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.ws.axis.JAxisServlet;
import org.w3c.dom.Document;

public class JServletEngineConfigurationFactory
implements EngineConfigurationFactory {
    public static final String AXIS_SERVER_CONFIG_PARAM = "axis.serverConfigFile";
    public static final String SERVER_CONFIG_WSDD = "org/ow2/jonas/ws/axis/server-config.wsdd";
    private static Logger logger = Log.getLogger("org.ow2.jonas.ws");
    private String serverConfigFile;
    private EngineConfigurationFactory delegate;
    private ServletContext ctx;
    private ServletConfig cfg;

    protected JServletEngineConfigurationFactory(ServletConfig conf) {
        this.cfg = conf;
        this.ctx = conf.getServletContext();
        this.delegate = EngineConfigurationFactoryServlet.newFactory(conf);
    }

    public static EngineConfigurationFactory newFactory(Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof JAxisServlet) {
            JAxisServlet servlet = (JAxisServlet)param;
            return new JServletEngineConfigurationFactory(servlet.getServletConfig());
        }
        return null;
    }

    public EngineConfiguration getServerEngineConfig() {
        logger.log(BasicLevel.DEBUG, (Object)("Entering getServerEngineConfig for servlet " + this.cfg.getServletName()));
        try {
            InputStream is;
            this.serverConfigFile = this.cfg.getInitParameter(AXIS_SERVER_CONFIG_PARAM);
            logger.log(BasicLevel.DEBUG, (Object)("serverConfigFile=" + this.serverConfigFile));
            if (this.serverConfigFile == null) {
                return this.delegate.getServerEngineConfig();
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Loading server-config file '" + this.serverConfigFile + "'"));
            }
            String appWebInfPath = "/WEB-INF";
            Document deploy = null;
            String realWebInfPath = this.ctx.getRealPath(appWebInfPath);
            if (realWebInfPath == null || !new File(realWebInfPath, this.serverConfigFile).exists()) {
                String name = appWebInfPath + "/" + this.serverConfigFile;
                is = this.ctx.getResourceAsStream(name);
                if (is != null) {
                    deploy = XMLUtils.newDocument(is);
                }
                if (deploy == null) {
                    String err = "Cannot get config file '" + this.serverConfigFile + "' as Resource.";
                    logger.log(BasicLevel.ERROR, (Object)err);
                }
            }
            if (deploy == null && realWebInfPath != null) {
                try {
                    FileInputStream is2 = new FileInputStream(new File(realWebInfPath, this.serverConfigFile));
                    deploy = XMLUtils.newDocument(is2);
                }
                catch (IOException e) {
                    String err = "Cannot get config file '" + this.serverConfigFile + "' as File Resource.";
                    logger.log(BasicLevel.ERROR, (Object)err);
                }
            }
            if (deploy == null) {
                return this.delegate.getServerEngineConfig();
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            is = cl.getResourceAsStream(SERVER_CONFIG_WSDD);
            Document base = XMLUtils.newDocument(is);
            WSDDDeployment deployWSDD = new WSDDDeployment(deploy.getDocumentElement());
            WSDDDeployment configWSDD = new WSDDDeployment(base.getDocumentElement());
            WSDDService[] services = deployWSDD.getServices();
            for (int j = 0; j < services.length; ++j) {
                WSDDService service = services[j];
                service.setParameter("disablePrettyXML", "true");
            }
            deployWSDD.deployToRegistry(configWSDD);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                StringWriter sw = new StringWriter();
                SerializationContext ctx = new SerializationContext(sw);
                try {
                    configWSDD.writeToContext(ctx);
                }
                catch (Exception ioe) {
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot serialize Axis wsdd for servlet " + this.cfg.getServletName()));
                }
                logger.log(BasicLevel.DEBUG, (Object)sw.getBuffer().toString());
            }
            return configWSDD;
        }
        catch (Exception e) {
            String err = "Cannot configure axis server from '" + this.serverConfigFile + "'. Use axis default. Caused by : " + e.getMessage();
            e.printStackTrace();
            logger.log(BasicLevel.ERROR, (Object)err);
            return this.delegate.getServerEngineConfig();
        }
    }

    public EngineConfiguration getClientEngineConfig() {
        return null;
    }
}

