/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.handler.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import org.ow2.jonas.ws.jaxws.handler.builder.BindingUtils;
import org.ow2.jonas.ws.jaxws.handler.builder.HandlerBuilder;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandler;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChain;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerChainBuilder {
    public abstract List<Handler> buildHandlerChain(PortInfo var1, ClassLoader var2);

    public List<Handler> buildHandlerChain(IHandlerChains handlerChains, PortInfo info, ClassLoader loader) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        List<IHandlerChain> chains = handlerChains.getHandlerChains();
        for (IHandlerChain chain : chains) {
            QName portPattern = chain.getPortNamePattern();
            if (!this.matchesPattern(info.getPortName(), portPattern)) continue;
            QName servicePattern = chain.getServiceNamePattern();
            if (!this.matchesPattern(info.getServiceName(), servicePattern)) continue;
            List<String> bindings = chain.getProtocolBindings();
            if (!this.matchesBinding(info.getBindingID(), bindings)) continue;
            List<IHandler> handlerList = chain.getHandlers();
            for (IHandler pcHandler : handlerList) {
                HandlerBuilder builder = new HandlerBuilder(pcHandler, loader);
                Handler handler = builder.buildHandler();
                handlers.add(handler);
            }
        }
        return this.sortHandlers(handlers);
    }

    private boolean matchesBinding(String bindingID, List<String> bindings) {
        if (bindingID == null) {
            return true;
        }
        if (bindings == null || bindings.isEmpty()) {
            return true;
        }
        ArrayList<String> resolvedBindings = new ArrayList<String>();
        for (String binding : bindings) {
            resolvedBindings.add(BindingUtils.resolve(binding));
        }
        return resolvedBindings.contains(bindingID);
    }

    private boolean matchesPattern(QName name, QName pattern) {
        if (pattern == null) {
            return true;
        }
        if ("".equals(pattern.getNamespaceURI()) && "*".equals(pattern.getLocalPart())) {
            return true;
        }
        if (!pattern.getNamespaceURI().equals(name.getNamespaceURI())) {
            return false;
        }
        return Pattern.matches(pattern.getLocalPart(), name.getLocalPart());
    }

    protected List<Handler> sortHandlers(List<Handler> handlers) {
        ArrayList<Handler> logicalHandlers = new ArrayList<Handler>();
        ArrayList<Handler> protocolHandlers = new ArrayList<Handler>();
        if (handlers != null) {
            for (Handler handler : handlers) {
                if (handler instanceof LogicalHandler) {
                    logicalHandlers.add(handler);
                    continue;
                }
                protocolHandlers.add(handler);
            }
        }
        ArrayList<Handler> sortedHandlers = new ArrayList<Handler>();
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }
}

