/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.builder.webserviceref;

import java.io.IOException;
import java.io.Serializable;
import javax.naming.BinaryRefAddr;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.marshalling.Serialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceHelper {
    private static Log logger = LogFactory.getLog(ReferenceHelper.class);
    private Reference reference;

    public ReferenceHelper(Reference reference) {
        this.reference = reference;
    }

    public ReferenceHelper insert(String key, String value) {
        if (value != null) {
            this.reference.add(new StringRefAddr(key, value));
            logger.debug("String Reference Insertion ''{0}''->''{1}''", key, value);
        }
        return this;
    }

    public String extract(String key) {
        RefAddr addr = this.reference.get(key);
        if (addr != null && addr instanceof StringRefAddr) {
            StringRefAddr sra = (StringRefAddr)addr;
            return (String)sra.getContent();
        }
        return null;
    }

    public ReferenceHelper insert(String key, Serializable value) {
        if (value != null) {
            try {
                byte[] bytes = Serialization.storeObject(value);
                this.reference.add(new BinaryRefAddr(key, bytes));
                logger.debug("Binary Reference Insertion ''{0}''->''{1}''", key, value.toString());
            }
            catch (IOException e) {
                logger.warn("Unable to serialize ''{0}''", value.toString(), e);
            }
        }
        return this;
    }

    public <T> T extract(String key, Class<T> type) {
        RefAddr addr = this.reference.get(key);
        if (addr != null && addr instanceof BinaryRefAddr) {
            BinaryRefAddr binaryRefAddr = (BinaryRefAddr)addr;
            byte[] bytes = (byte[])binaryRefAddr.getContent();
            try {
                return type.cast(Serialization.loadObject(bytes, type.getClassLoader()));
            }
            catch (IOException e) {
                logger.warn("Unable to load object ''{0}''", key, e);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Unable to load object ''{0}'' using context classloader", key, e);
            }
        }
        return null;
    }
}

