/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlanFragment;
import org.ow2.util.plan.bindings.exceptions.InvalidDeploymentException;
import org.ow2.util.plan.fetcher.api.IResourceFetcher;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.fetcher.api.exceptions.FetcherFactoryException;
import org.ow2.util.plan.fetcher.api.exceptions.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFetcherFactoryManagerImpl
implements IResourceFetcherFactoryManager {
    private Map<Class<? extends DeploymentPlanFragment>, IResourceFetcherFactory> factories = new HashMap<Class<? extends DeploymentPlanFragment>, IResourceFetcherFactory>();

    @Override
    public void addResourceFetcherFactory(IResourceFetcherFactory factory) {
        this.factories.put(factory.getSupportedClass(), factory);
    }

    @Override
    public void removeResourceFetcherFactory(IResourceFetcherFactory factory) {
        this.factories.remove(factory.getSupportedClass());
    }

    @Override
    public IResourceFetcher getResourceFetcher(DeploymentPlanFragment deployment) throws ResourceNotFoundException, InvalidDeploymentException, FetcherFactoryException {
        if (deployment == null) {
            throw new InvalidDeploymentException("null deployment");
        }
        IResourceFetcherFactory factory = this.findFetcherFactoryForDeployment(deployment);
        if (factory == null) {
            throw new FetcherFactoryException("No resource fetcher factory for deployment class " + deployment.getClass());
        }
        IResourceFetcher fetcher = factory.getResourceFetcher(deployment);
        return fetcher;
    }

    @Override
    public IResourceFetcherFactory findFetcherFactoryForDeployment(DeploymentPlanFragment fragment) {
        IResourceFetcherFactory factory = this.factories.get(fragment.getClass());
        if (factory == null) {
            for (IResourceFetcherFactory loopFactory : this.factories.values()) {
                if (!loopFactory.getSupportedClass().isAssignableFrom(fragment.getClass())) continue;
                factory = loopFactory;
                break;
            }
        }
        return factory;
    }

    @Override
    public Iterator<IResourceFetcherFactory> iterator() {
        return this.factories.values().iterator();
    }
}

