/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories.model.login;

import java.util.Vector;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;

public abstract class LoginConfig {
    private String m_platformClass;
    private String m_username;
    private char[] m_encryptedPassword;
    private SecurableObjectHolder m_securableObjectHolder = new SecurableObjectHolder();
    private String m_tableQualifier;
    private String m_encryptionClass;
    private boolean m_externalConnectionPooling;
    private boolean m_externalTransactionController;
    private SequencingConfig m_sequencingConfig;
    private Vector m_propertyConfigs;

    public void setPlatformClass(String platformClass) {
        this.m_platformClass = platformClass;
    }

    public String getPlatformClass() {
        return this.m_platformClass;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setEncryptionClass(String encryptionClass) {
        this.m_encryptionClass = encryptionClass;
        this.m_securableObjectHolder.setEncryptionClassName(this.m_encryptionClass);
    }

    public String getEncryptionClass() {
        return this.m_encryptionClass;
    }

    public void setPassword(String password) {
        if (password == null) {
            this.m_encryptedPassword = null;
        } else if (password.length() == 0) {
            this.m_encryptedPassword = new char[0];
        } else {
            String encryptedPassword = this.m_securableObjectHolder.getSecurableObject().encryptPassword(password);
            this.m_encryptedPassword = encryptedPassword.toCharArray();
        }
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.m_encryptedPassword = (char[])(encryptedPassword != null ? encryptedPassword.toCharArray() : null);
    }

    public String getPassword() {
        String decryptedPassword = null;
        if (this.m_encryptedPassword != null) {
            String passwordString = new String(this.m_encryptedPassword);
            decryptedPassword = this.m_securableObjectHolder.getSecurableObject().decryptPassword(passwordString);
            if (decryptedPassword == null || decryptedPassword.equals(passwordString)) {
                this.setPassword(decryptedPassword);
            }
        }
        return decryptedPassword;
    }

    public String getEncryptedPassword() {
        if (this.m_encryptedPassword != null) {
            return new String(this.m_encryptedPassword);
        }
        return null;
    }

    public void setTableQualifier(String tableQualifier) {
        this.m_tableQualifier = tableQualifier;
    }

    public String getTableQualifier() {
        return this.m_tableQualifier;
    }

    public void setExternalConnectionPooling(boolean externalConnectionPooling) {
        this.m_externalConnectionPooling = externalConnectionPooling;
    }

    public boolean getExternalConnectionPooling() {
        return this.m_externalConnectionPooling;
    }

    public void setExternalTransactionController(boolean externalTransactionController) {
        this.m_externalTransactionController = externalTransactionController;
    }

    public boolean getExternalTransactionController() {
        return this.m_externalTransactionController;
    }

    public void setSequencingConfig(SequencingConfig sequencingConfig) {
        this.m_sequencingConfig = sequencingConfig;
    }

    public SequencingConfig getSequencingConfig() {
        return this.m_sequencingConfig;
    }

    public void setPropertyConfigs(Vector propertyConfigs) {
        this.m_propertyConfigs = propertyConfigs;
    }

    public Vector getPropertyConfigs() {
        return this.m_propertyConfigs;
    }
}

