/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer;

import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.asm.AnnotationVisitor;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.ClassWriter;
import org.ow2.easybeans.asm.FieldVisitor;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Opcodes;
import org.ow2.easybeans.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonClassGenerator
implements Opcodes {
    public static final String ARRAY_OBJECTS = "[Ljava/lang/Object;";
    public static final String JAVA_LANG_OBJECT = "Ljava/lang/Object;";
    public static final String VOID_METHOD_JAVA_LANG_OBJECT = "(Ljava/lang/Object;)V";
    public static final String JAVA_LANG_EXCEPTION = "Ljava/lang/Exception;";
    public static final String JAVA_LANG_REFLECT_METHOD = "Ljava/lang/reflect/Method;";
    public static final String EASYBEANS_FACTORY = Type.getDescriptor(Factory.class);
    public static final int GENERATED_CLASS_VERSION = 49;
    private ClassWriter cw;
    private FieldVisitor fv = null;

    public CommonClassGenerator(ClassWriter cw) {
        this.cw = cw;
    }

    protected void addAttribute(int access, String name, String desc) {
        this.addAttribute(access, name, desc, null);
    }

    protected void addAttribute(int access, String name, String desc, Object value) {
        this.fv = this.cw.visitField(access, name, desc, null, value);
        this.fv.visitEnd();
    }

    public static String encodeClassDesc(String className) {
        return "L" + className + ";";
    }

    public static String encodeArrayClassDesc(String className) {
        return "[L" + className + ";";
    }

    public ClassWriter getCW() {
        return this.cw;
    }

    public static int putFieldLoadOpCode(int sortCode) {
        switch (sortCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 21;
            }
            case 6: {
                return 23;
            }
            case 7: {
                return 22;
            }
            case 8: {
                return 24;
            }
        }
        return 25;
    }

    public static void transformPrimitiveIntoObject(Type type, MethodVisitor mv) {
        switch (type.getSort()) {
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
        }
    }

    public static void transformObjectIntoPrimitive(Type type, MethodVisitor mv) {
        switch (type.getSort()) {
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Byte");
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Short");
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Integer");
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Float");
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Double");
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            case 0: {
                mv.visitInsn(87);
                break;
            }
            case 9: {
                mv.visitTypeInsn(192, type.getDescriptor());
                break;
            }
            case 10: {
                mv.visitTypeInsn(192, type.getInternalName());
                break;
            }
        }
    }

    public static void addReturnType(Type type, MethodVisitor mv) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(172);
                break;
            }
            case 6: {
                mv.visitInsn(174);
                break;
            }
            case 7: {
                mv.visitInsn(173);
                break;
            }
            case 8: {
                mv.visitInsn(175);
                break;
            }
            case 0: {
                mv.visitInsn(177);
                break;
            }
            case 9: 
            case 10: {
                mv.visitInsn(176);
                break;
            }
        }
    }

    public static void visitClassType(Type type, MethodVisitor mv) {
        switch (type.getSort()) {
            case 1: {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 3: {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 2: {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 4: {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 5: {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 6: {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 7: {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
                break;
            }
            case 8: {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
                break;
            }
            default: {
                mv.visitLdcInsn(type);
            }
        }
    }

    public static void returnsObject(Type returnType, MethodVisitor mv) {
        if (returnType.equals(Type.VOID_TYPE)) {
            mv.visitInsn(1);
        } else {
            CommonClassGenerator.transformPrimitiveIntoObject(returnType, mv);
        }
        mv.visitInsn(176);
    }

    public static void addFieldGettersSetters(ClassVisitor cv, String beanClassName, String fieldName, Class<?> clazz) {
        String className = Type.getDescriptor(clazz);
        CommonClassGenerator.addFieldGettersSetters(cv, beanClassName, fieldName, className);
    }

    public static void addFieldGettersSetters(ClassVisitor cv, String beanClassName, String fieldName, String className) {
        Type type = Type.getType(className);
        FieldVisitor fv = cv.visitField(2, fieldName, className, null, null);
        fv.visitEnd();
        String appendName = fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        String getterName = "get" + appendName;
        MethodVisitor mv = cv.visitMethod(1, getterName, "()" + className, null, null);
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, beanClassName, fieldName, className);
        CommonClassGenerator.addReturnType(type, mv);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        String setterName = "set" + appendName;
        mv = cv.visitMethod(1, setterName, "(" + className + ")V", null, null);
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
        mv.visitVarInsn(opCode, 1);
        mv.visitFieldInsn(181, beanClassName, fieldName, className);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static void addNullGetter(ClassVisitor cv, String getterName, Class<?> clazz) {
        String returnedClassName = Type.getDescriptor(clazz);
        MethodVisitor mv = cv.visitMethod(1, getterName, "()" + returnedClassName, null, null);
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public static void addAnnotationsOnGeneratedMethod(MethodVisitor methodVisitor) {
        AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation("Ljavax/jws/WebMethod;", true);
        annotationVisitor.visit("exclude", Boolean.TRUE);
        annotationVisitor.visitEnd();
    }
}

