/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.classpath.ModelListener;
import aQute.bnd.plugin.Activator;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.BundleContext;

public class Central
implements IResourceChangeListener {
    static Central CENTRAL = new Central();
    static IWorkspace iworkspace;
    final Map<IJavaProject, Project> javaProjectToModel = new HashMap<IJavaProject, Project>();
    final List<ModelListener> listeners = new ArrayList<ModelListener>();
    Workspace workspace;

    private Central() {
        CENTRAL = this;
        iworkspace = ResourcesPlugin.getWorkspace();
        iworkspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    public static synchronized Central getCentral() {
        return CENTRAL;
    }

    public void stop(BundleContext context) throws Exception {
    }

    public Project getModel(IJavaProject project) {
        try {
            Project model = this.javaProjectToModel.get(project);
            if (model == null) {
                File projectDir = project.getProject().getLocation().makeAbsolute().toFile();
                model = Workspace.getProject(projectDir);
                if (this.workspace == null) {
                    model.getWorkspace();
                }
                if (model != null) {
                    this.javaProjectToModel.put(project, model);
                }
            }
            return model;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        try {
            final HashSet changed = new HashSet();
            rootDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    try {
                        File file = delta.getResource().getLocation().toFile();
                        File parent = file.getParentFile();
                        if (parent != null && parent.equals(Central.this.getWorkspace().getBase())) {
                            if (Central.this.workspace.isPresent(file.getName())) {
                                Project project = Central.this.workspace.getProject(file.getName());
                                changed.add(project);
                            } else if (file.getName().equals("cnf") && Central.this.workspace.refresh()) {
                                changed.addAll(Central.this.workspace.getCurrentProjects());
                            }
                            return false;
                        }
                        return true;
                    }
                    catch (Exception e) {
                        throw new CoreException((IStatus)new Status(4, "aQute.bmaker", "During checking project changes", (Throwable)e));
                    }
                }
            });
            for (Project p : changed) {
                if (!p.refresh()) continue;
                this.changed(p);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().error("While handling changes", e);
            e.printStackTrace();
        }
    }

    private Processor getWorkspace() throws Exception {
        if (this.workspace != null) {
            return this.workspace;
        }
        this.workspace = Workspace.getWorkspace(iworkspace.getRoot().getLocation().toFile());
        return this.workspace;
    }

    private void changed(Project model) {
        model.setChanged();
        for (ModelListener m : this.listeners) {
            try {
                m.modelChanged(model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addModelListener(ModelListener m) {
        if (!this.listeners.contains(m)) {
            this.listeners.add(m);
        }
    }

    public void removeModelListener(ModelListener m) {
        this.listeners.remove(m);
    }

    public IJavaProject getJavaProject(Project model) {
        IProject[] iProjectArray = iworkspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject ij;
            IProject iproj = iProjectArray[n2];
            if (iproj.getName().equals(model.getName()) && (ij = JavaCore.create((IProject)iproj)) != null && ij.exists()) {
                return ij;
            }
            ++n2;
        }
        return null;
    }
}

