/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.header;

import aQute.libg.generics.Create;
import aQute.libg.qtokens.QuotedTokenizer;
import aQute.libg.reporter.Reporter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiHeader {
    public static Map<String, Map<String, String>> parseHeader(String value) {
        return OSGiHeader.parseHeader(value, null);
    }

    public static Map<String, Map<String, String>> parseHeader(String value, Reporter logger) {
        if (value == null || value.trim().length() == 0) {
            return Create.map();
        }
        Map<String, Map<String, String>> result = Create.map();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        char del = '\u0000';
        do {
            boolean hadAttribute = false;
            Map<String, String> clause = Create.map();
            List<String> aliases = Create.list();
            String name = qt.nextToken(",;");
            del = qt.getSeparator();
            if (name == null || name.length() == 0) {
                if (logger != null && logger.isPedantic()) {
                    logger.warning("Empty clause, usually caused by repeating a comma without any name field or by having spaces after the backslash of a property file: " + value);
                }
                if (name != null) continue;
                break;
            }
            name = name.trim();
            aliases.add(name);
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute && logger != null) {
                        logger.error("Header contains name field after attribute or directive: " + adname + " from " + value + ". Name fields must be consecutive, separated by a ';' like a;b;c;x=3;y=4");
                    }
                    if (adname == null || adname.length() <= 0) continue;
                    aliases.add(adname.trim());
                    continue;
                }
                String advalue = qt.nextToken();
                if (clause.containsKey(adname) && logger != null && logger.isPedantic()) {
                    logger.warning("Duplicate attribute/directive name " + adname + " in " + value + ". This attribute/directive will be ignored");
                }
                if (advalue == null) {
                    if (logger != null) {
                        logger.error("No value after '=' sign for attribute " + adname);
                    }
                    advalue = "";
                }
                clause.put(adname.trim(), advalue.trim());
                del = qt.getSeparator();
                hadAttribute = true;
            }
            for (String clauseName : aliases) {
                if (result.containsKey(clauseName)) {
                    if (logger != null && logger.isPedantic()) {
                        logger.warning("Duplicate name " + clauseName + " used in header: '" + clauseName + "'. Duplicate names are specially marked in Bnd with a ~ at the end (which is stripped at printing time).");
                    }
                    while (result.containsKey(clauseName)) {
                        clauseName = String.valueOf(clauseName) + "~";
                    }
                }
                result.put(clauseName, clause);
            }
        } while (del == ',');
        return result;
    }
}

