/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.jndi.context;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;
import org.ow2.cmi.admin.MBeanUtils;
import org.ow2.cmi.config.CMIConfig;
import org.ow2.cmi.config.CMIConfigException;
import org.ow2.cmi.config.CMIConfigurator;
import org.ow2.cmi.config.JNDIConfig;
import org.ow2.cmi.config.ProtocolConfig;
import org.ow2.cmi.config.ProviderUrls;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManagerException;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactoryException;
import org.ow2.cmi.controller.factory.server.ClusterViewManagerFactoryConfig;
import org.ow2.cmi.controller.server.ProtocolNotFoundException;
import org.ow2.cmi.controller.server.ServerClusterViewManager;
import org.ow2.cmi.jndi.context.CMIContext;
import org.ow2.cmi.jndi.context.CMIContextException;
import org.ow2.cmi.jndi.context.CMINamingException;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CMIInitialContextFactory
implements InitialContextFactory {
    private static Log logger = LogFactory.getLog(CMIInitialContextFactory.class);

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws CMINamingException {
        JNDIConfig jndiConfig;
        boolean replicationEnabled;
        ClusterViewManagerFactory clusterViewManagerFactory = ClusterViewManagerFactory.getFactory();
        ClusterViewManager clusterViewManager = clusterViewManagerFactory.getClusterViewManager();
        CMIConfig<?> cmiConfig = null;
        ServerId registryId = null;
        String wrappedFactoryName = null;
        String protocol = null;
        List<ServerRef> serverRefs = null;
        if (clusterViewManager != null) {
            replicationEnabled = clusterViewManager instanceof ServerClusterViewManager;
            if (replicationEnabled) {
                Set<String> protocols;
                try {
                    cmiConfig = CMIConfigurator.findAndExtractCMIConfig(environment, true);
                }
                catch (CMIConfigException e) {
                    logger.error((Object)"Unable to retrieve the CMI configuration", new Object[]{e});
                    throw new CMINamingException("Unable to retrieve the CMI configuration", e);
                }
                protocol = JNDIConfig.getCurrentProtocolName();
                if (protocol == null && (protocols = clusterViewManager.getProtocols()).size() == 1) {
                    protocol = (String)protocols.toArray()[0];
                }
                if (protocol != null && ((ServerClusterViewManager)clusterViewManager).hasProtocol(protocol)) {
                    try {
                        wrappedFactoryName = ((ServerClusterViewManager)clusterViewManager).getInitialContextFactoryName(protocol);
                        registryId = ((ServerClusterViewManager)clusterViewManager).getRefOnLocalRegistry(protocol);
                    }
                    catch (ProtocolNotFoundException e) {
                        logger.error((Object)"Unable to retrieve the protocol config", new Object[]{e});
                        throw new CMINamingException("Unable to retrieve the protocol config", e);
                    }
                } else {
                    jndiConfig = cmiConfig.getJNDIConfig();
                    if (jndiConfig == null) {
                        logger.error((Object)"JNDI config missing!", new Object[0]);
                        throw new CMINamingException("JNDI config missing!");
                    }
                    Set<ProtocolConfig> protocolConfigs = jndiConfig.getProtocolConfigs();
                    if (protocolConfigs == null) {
                        logger.error((Object)"Protocol configs missing!", new Object[0]);
                        throw new CMINamingException("Protocol configs missing!");
                    }
                    ProtocolConfig currentProtocolConfig = null;
                    if (protocol != null) {
                        for (ProtocolConfig protocolConfig : protocolConfigs) {
                            if (!protocolConfig.getName().equals(protocol)) continue;
                            currentProtocolConfig = protocolConfig;
                        }
                    } else if (protocolConfigs.size() == 1) {
                        currentProtocolConfig = (ProtocolConfig)protocolConfigs.toArray()[0];
                        protocol = currentProtocolConfig.getName();
                    }
                    if (currentProtocolConfig == null) {
                        logger.error((Object)"Protocol config missing!", new Object[0]);
                        throw new CMINamingException("Protocol config missing!");
                    }
                    wrappedFactoryName = currentProtocolConfig.getInitialContextFactoryName();
                    if (wrappedFactoryName == null) {
                        logger.error((Object)("Missing the initial context factory for protocol " + protocol), new Object[0]);
                        throw new CMINamingException("Missing the initial context factory for protocol " + protocol);
                    }
                    if (wrappedFactoryName.equals(CMIInitialContextFactory.class.getName())) {
                        logger.error((Object)"A CMI context cannot wrap an other CMI context!!", new Object[0]);
                        throw new CMINamingException("A CMI context cannot wrap an other CMI context!!");
                    }
                    String localRegistry = currentProtocolConfig.getLocalRegistryUrl();
                    if (localRegistry == null) {
                        logger.error((Object)"Server cluster view manager requires a local registry!", new Object[0]);
                        throw new CMINamingException("Server cluster view manager requires a local registry!");
                    }
                    try {
                        registryId = new ServerId(MBeanUtils.getMBeanDomainName(), MBeanUtils.getMBeanServerName(), protocol, localRegistry);
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)"The following provider URL is malformed {0}", new Object[]{localRegistry, e});
                        throw new CMINamingException("The following provider URL is malformed " + localRegistry, e);
                    }
                    catch (UnknownHostException e) {
                        logger.error((Object)"The host name of the provider URL {0} cannot be resolved", new Object[]{localRegistry, e});
                        throw new CMINamingException("The host name of the provider URL " + localRegistry + " cannot be resolved", e);
                    }
                }
            } else {
                protocol = ((ClientClusterViewManager)clusterViewManager).getProtocolName();
                wrappedFactoryName = ((ClientClusterViewManager)clusterViewManager).getInitialContextFactoryName();
                serverRefs = ((ClientClusterViewManager)clusterViewManager).getProviderURLs();
            }
        } else {
            try {
                cmiConfig = CMIConfigurator.findAndExtractCMIConfig(environment, false);
            }
            catch (CMIConfigException e) {
                logger.error((Object)"Unable to retrieve the CMI configuration", new Object[]{e});
                throw new CMINamingException("Unable to retrieve the CMI configuration", e);
            }
            Object clusterViewManagerFactoryConfig = cmiConfig.getClusterViewManagerFactoryConfig();
            replicationEnabled = clusterViewManagerFactoryConfig instanceof ClusterViewManagerFactoryConfig;
            if (replicationEnabled && clusterViewManagerFactoryConfig == null) {
                logger.error((Object)"Unable to retrieve the CMI configuration", new Object[0]);
                throw new CMINamingException("Unable to retrieve the CMI configuration");
            }
            protocol = JNDIConfig.getCurrentProtocolName();
            jndiConfig = cmiConfig.getJNDIConfig();
            if (jndiConfig == null) {
                logger.error((Object)"JNDI config missing!", new Object[0]);
                throw new CMINamingException("JNDI config missing!");
            }
            Set<ProtocolConfig> protocolConfigs = jndiConfig.getProtocolConfigs();
            if (protocolConfigs == null) {
                logger.error((Object)"Protocol configs missing!", new Object[0]);
                throw new CMINamingException("Protocol configs missing!");
            }
            ProtocolConfig currentProtocolConfig = null;
            for (ProtocolConfig protocolConfig : protocolConfigs) {
                if (!protocolConfig.getName().equals(protocol)) continue;
                currentProtocolConfig = protocolConfig;
            }
            if (currentProtocolConfig == null) {
                logger.error((Object)"Protocol config missing!", new Object[0]);
                throw new CMINamingException("Protocol config missing!");
            }
            wrappedFactoryName = currentProtocolConfig.getInitialContextFactoryName();
            if (wrappedFactoryName == null) {
                logger.error((Object)("Missing the initial context factory for protocol " + protocol), new Object[0]);
                throw new CMINamingException("Missing the initial context factory for protocol " + protocol);
            }
            ProviderUrls providerURLs = currentProtocolConfig.getProviderUrls();
            if (!replicationEnabled && providerURLs != null && !providerURLs.getProviderUrls().isEmpty()) {
                try {
                    serverRefs = CMIConfigurator.extractServerRefs(protocol, providerURLs.getProviderUrls());
                }
                catch (CMIConfigException e) {
                    logger.error((Object)("Unable to extract some server refs from the provider URL " + providerURLs.getProviderUrls()), new Object[]{e});
                    throw new CMINamingException("Unable to extract some server refs from the provider URL " + providerURLs.getProviderUrls(), e);
                }
            } else if (!replicationEnabled) {
                logger.error((Object)("Missing the initial provider URLs for protocol " + protocol), new Object[0]);
                throw new CMINamingException("Missing the initial provider URLs for protocol " + protocol);
            }
            if (replicationEnabled) {
                String localRegistry = currentProtocolConfig.getLocalRegistryUrl();
                if (localRegistry == null) {
                    logger.error((Object)"Server cluster view manager requires a local registry!", new Object[0]);
                    throw new CMINamingException("Server cluster view manager requires a local registry!");
                }
                try {
                    registryId = new ServerId(MBeanUtils.getMBeanDomainName(), MBeanUtils.getMBeanServerName(), protocol, localRegistry);
                }
                catch (MalformedURLException e) {
                    logger.error((Object)"The following provider URL is malformed {0}", new Object[]{localRegistry, e});
                    throw new CMINamingException("The following provider URL is malformed " + localRegistry, e);
                }
                catch (UnknownHostException e) {
                    logger.error((Object)"The host name of the provider URL {0} cannot be resolved", new Object[]{localRegistry, e});
                    throw new CMINamingException("The host name of the provider URL " + localRegistry + " cannot be resolved", e);
                }
            }
        }
        if (clusterViewManager == null) {
            if (cmiConfig == null) {
                logger.error((Object)"No CMI configuration", new Object[0]);
                throw new CMINamingException("No CMI configuration");
            }
            try {
                CMIConfigurator.configure(clusterViewManagerFactory, cmiConfig);
            }
            catch (CMIConfigException e) {
                logger.error((Object)"Unable to configure the cluster view manager factory", new Object[]{e});
                throw new CMINamingException("Unable to configure the cluster view manager factory", e);
            }
            try {
                clusterViewManager = clusterViewManagerFactory.create();
            }
            catch (ClusterViewManagerFactoryException e) {
                logger.error((Object)"Unable to get the cluster view manager", new Object[]{e});
                throw new CMINamingException("Unable to get the cluster view manager", e);
            }
        }
        if (clusterViewManager != null && clusterViewManager.getState().equals((Object)ClusterViewManager.State.STOPPED) && cmiConfig != null && cmiConfig.getClusterViewManagerFactoryConfig() != null && ((org.ow2.cmi.controller.factory.ClusterViewManagerFactoryConfig)cmiConfig.getClusterViewManagerFactoryConfig()).isAutoStarted()) {
            try {
                clusterViewManager.start();
            }
            catch (ClusterViewManagerException e) {
                logger.error((Object)"Unable to start the cluster view manager", new Object[]{e});
                throw new CMINamingException("Unable to start the cluster view manager", e);
            }
        }
        if (wrappedFactoryName == null || protocol == null) {
            logger.error((Object)"Unable to build a CMI context!!", new Object[0]);
            throw new CMINamingException("Unable to build a CMI context!!");
        }
        CMIContext cmiContext = new CMIContext(clusterViewManager, registryId, wrappedFactoryName, protocol, serverRefs);
        if (replicationEnabled) {
            try {
                cmiContext.register();
            }
            catch (CMIContextException e) {
                logger.error((Object)"Cannot register the context", new Object[]{e});
                throw new CMINamingException("Cannot register the context", e);
            }
        }
        return cmiContext;
    }
}

