/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.MapKey;
import javax.persistence.OrderBy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAccessor
extends RelationshipAccessor {
    private static final String ASCENDING = "ASC";
    private static final String DESCENDING = "DESC";
    private String m_mapKey;
    private String m_mappedBy;
    private String m_orderBy;
    private JoinTableMetadata m_joinTable;

    protected CollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected CollectionAccessor(Annotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        Object mapKey;
        Object orderBy;
        String string = this.m_mappedBy = annotation == null ? "" : (String)MetadataHelper.invokeMethod("mappedBy", annotation);
        if (this.isAnnotationPresent(JoinTable.class)) {
            this.m_joinTable = new JoinTableMetadata((Annotation)this.getAnnotation(JoinTable.class), accessibleObject);
        }
        if ((orderBy = this.getAnnotation(OrderBy.class)) != null) {
            this.m_orderBy = (String)MetadataHelper.invokeMethod("value", orderBy);
        }
        if ((mapKey = this.getAnnotation(MapKey.class)) != null) {
            this.m_mapKey = (String)MetadataHelper.invokeMethod("name", mapKey);
        }
    }

    protected void addManyToManyRelationKeyFields(List<JoinColumnMetadata> joinColumns, ManyToManyMapping mapping, String defaultFieldName, MetadataDescriptor descriptor, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        for (JoinColumnMetadata joinColumn : joinColumns) {
            String defaultPKFieldName = descriptor.getPrimaryKeyFieldName();
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX));
            pkField.setTable(descriptor.getPrimaryKeyTable());
            DatabaseField fkField = joinColumn.getForeignKeyField();
            String defaultFKFieldName = defaultFieldName + "_" + defaultPKFieldName;
            fkField.setName(this.getName(fkField, defaultFKFieldName, FK_CTX));
            fkField.setTable(mapping.getRelationTable());
            if (isSource) {
                mapping.addSourceRelationKeyField(fkField, pkField);
                continue;
            }
            mapping.addTargetRelationKeyField(fkField, pkField);
        }
    }

    @Override
    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"LAZY");
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    public String getMapKey() {
        return this.m_mapKey;
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetEntity(this.getAttributeName(), this.getJavaClass());
                }
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    public boolean isCollectionAccessor() {
        return true;
    }

    public boolean isMapCollectionAccessor() {
        return this.getRawClass().equals(Map.class);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_joinTable, accessibleObject);
    }

    @Override
    public void process() {
        if (!this.getAccessibleObject().isSupportedCollectionClass(this.getDescriptor())) {
            throw ValidationException.invalidCollectionTypeForRelationship(this.getJavaClass(), this.getRawClass(), this.getAttributeName());
        }
    }

    protected void process(CollectionMapping mapping) {
        mapping.setIsReadOnly(false);
        mapping.setIsLazy(this.isLazy());
        mapping.setIsPrivateOwned(this.isPrivateOwned());
        mapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.processOrderBy(mapping);
        String mapKey = this.processMapKey(mapping);
        this.setIndirectionPolicy(mapping, mapKey, this.usesIndirection());
        this.processReturnInsertAndUpdate();
    }

    protected void processJoinTable(ManyToManyMapping mapping) {
        if (this.m_joinTable == null) {
            this.m_joinTable = new JoinTableMetadata(null, this.getAccessibleObject());
        }
        String defaultName = this.getDescriptor().getPrimaryTableName() + "_" + this.getReferenceDescriptor().getPrimaryTableName();
        this.processTable(this.m_joinTable, defaultName);
        mapping.setRelationTable(this.m_joinTable.getDatabaseTable());
        String defaultSourceFieldName = this.getReferenceDescriptor().hasBiDirectionalManyToManyAccessorFor(this.getJavaClassName(), this.getAttributeName()) ? this.getReferenceDescriptor().getBiDirectionalManyToManyAccessor(this.getJavaClassName(), this.getAttributeName()).getAttributeName() : this.getDescriptor().getAlias();
        this.addManyToManyRelationKeyFields(this.processJoinColumns(this.m_joinTable.getJoinColumns(), this.getDescriptor()), mapping, defaultSourceFieldName, this.getDescriptor(), true);
        String defaultTargetFieldName = this.getAttributeName();
        this.addManyToManyRelationKeyFields(this.processJoinColumns(this.m_joinTable.getInverseJoinColumns(), this.getReferenceDescriptor()), mapping, defaultTargetFieldName, this.getReferenceDescriptor(), false);
    }

    protected String processMapKey(CollectionMapping mapping) {
        String mapKeyMethod = null;
        if (this.isMapCollectionAccessor()) {
            MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
            if (this.m_mapKey != null && !this.m_mapKey.equals("") || !referenceDescriptor.hasCompositePrimaryKey()) {
                String string = referenceDescriptor.getIdAttributeName();
                this.getLogger();
                String fieldOrPropertyName = this.getName(this.m_mapKey, string, "metadata_default_map_key_attribute_name");
                MappingAccessor referenceAccessor = referenceDescriptor.getAccessorFor(fieldOrPropertyName);
                if (referenceAccessor == null) {
                    throw ValidationException.couldNotFindMapKey(fieldOrPropertyName, referenceDescriptor.getJavaClass(), mapping);
                }
                mapKeyMethod = referenceAccessor.getAccessibleObjectName();
            }
        }
        return mapKeyMethod;
    }

    protected void processOrderBy(CollectionMapping mapping) {
        block10: {
            if (this.m_orderBy == null) break block10;
            MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
            if (this.m_orderBy.equals("")) {
                List<String> orderByAttributes = referenceDescriptor.getIdOrderByAttributeNames();
                if (referenceDescriptor.hasEmbeddedIdAttribute()) {
                    String embeddedIdAttributeName = referenceDescriptor.getEmbeddedIdAttributeName();
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addAggregateOrderBy(embeddedIdAttributeName, orderByAttribute, false);
                    }
                } else {
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addOrderBy(orderByAttribute, false);
                    }
                }
            } else {
                StringTokenizer commaTokenizer = new StringTokenizer(this.m_orderBy, ",");
                while (commaTokenizer.hasMoreTokens()) {
                    String ordering;
                    StringTokenizer spaceTokenizer = new StringTokenizer(commaTokenizer.nextToken());
                    String propertyOrFieldName = spaceTokenizer.nextToken();
                    MappingAccessor referenceAccessor = referenceDescriptor.getAccessorFor(propertyOrFieldName);
                    if (referenceAccessor == null) {
                        throw ValidationException.invalidOrderByValue(propertyOrFieldName, referenceDescriptor.getJavaClass(), this.getAccessibleObjectName(), this.getJavaClass());
                    }
                    String attributeName = referenceAccessor.getAttributeName();
                    String string = ordering = spaceTokenizer.hasMoreTokens() ? spaceTokenizer.nextToken() : ASCENDING;
                    if (referenceAccessor.isEmbedded()) {
                        for (String orderByAttributeName : referenceDescriptor.getOrderByAttributeNames()) {
                            mapping.addAggregateOrderBy(attributeName, orderByAttributeName, ordering.equals(DESCENDING));
                        }
                        continue;
                    }
                    mapping.addOrderBy(attributeName, ordering.equals(DESCENDING));
                }
            }
        }
    }

    public void setJoinTable(JoinTableMetadata joinTable) {
        this.m_joinTable = joinTable;
    }

    public void setMapKey(String mapKey) {
        this.m_mapKey = mapKey;
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }

    public void setOrderBy(String orderBy) {
        this.m_orderBy = orderBy;
    }
}

