/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.DynamicClassWriter;

public class SDOClassLoader
extends ClassLoader {
    private ClassLoader delegateLoader;
    private Map generatedClasses;
    private HelperContext aHelperContext;

    public SDOClassLoader(ClassLoader delegateLoader, HelperContext aContext) {
        this.aHelperContext = aContext;
        this.delegateLoader = delegateLoader;
        this.generatedClasses = new HashMap();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class<?> javaClass = null;
        javaClass = (Class<?>)this.generatedClasses.get(className);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            javaClass = this.delegateLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (NoClassDefFoundError error) {
            throw error;
        }
        return javaClass;
    }

    public Class loadClass(String className, SDOType type) throws ClassNotFoundException {
        Class javaClass;
        block5: {
            javaClass = null;
            javaClass = (Class)this.generatedClasses.get(className);
            if (javaClass != null) {
                return javaClass;
            }
            try {
                javaClass = this.delegateLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                javaClass = this.createGeneric(className, type);
                if (javaClass == null) {
                    throw e;
                }
            }
            catch (NoClassDefFoundError error) {
                javaClass = this.createGeneric(className, type);
                if (javaClass != null) break block5;
                throw error;
            }
        }
        return javaClass;
    }

    public Class createGeneric(String className, SDOType type) {
        Class<?> javaClass = (Class<?>)this.generatedClasses.get(className);
        if (javaClass != null) {
            return javaClass;
        }
        if (className == null) {
            return null;
        }
        DynamicClassWriter dcWriter = new DynamicClassWriter(className, type, this.aHelperContext);
        byte[] bytes = dcWriter.createClass();
        javaClass = this.defineClass(className, bytes, 0, bytes.length);
        this.generatedClasses.put(className, javaClass);
        return javaClass;
    }

    public void setDelegateLoader(ClassLoader delegateLoader) {
        this.delegateLoader = delegateLoader;
    }

    public ClassLoader getDelegateLoader() {
        return this.delegateLoader;
    }

    public URL getResource(String name) {
        return this.delegateLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.delegateLoader.getResourceAsStream(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return this.delegateLoader.getResources(name);
    }
}

