/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.filter.Filter;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer
extends Processor {
    static Pattern doNotCopy = Pattern.compile("CVS|.svn");
    static String version;
    static Pattern versionPattern;
    final Map<String, Map<String, String>> contained = Analyzer.newHashMap();
    final Map<String, Map<String, String>> referred = Analyzer.newHashMap();
    final Map<String, Set<String>> uses = Analyzer.newHashMap();
    Map<String, Clazz> classspace;
    Map<String, Map<String, String>> exports;
    Map<String, Map<String, String>> imports;
    Map<String, Map<String, String>> bundleClasspath;
    final Map<String, Map<String, String>> ignored = Analyzer.newHashMap();
    Jar dot;
    Map<String, Map<String, String>> classpathExports;
    String activator;
    final List<Jar> classpath = this.newList();
    static Properties bndInfo;
    boolean analyzed;
    String bsn;
    static final Pattern REFERENCE;
    boolean firstUse = true;
    static Pattern fuzzyVersion;
    static Pattern fuzzyVersionRange;
    static Pattern fuzzyModifier;
    static Pattern nummeric;
    static Pattern PACKAGEINFO_PATTERN;

    static {
        versionPattern = Pattern.compile("(\\d+\\.\\d+)\\.\\d+.*");
        REFERENCE = Pattern.compile("([^(]+)(\\(.+\\))?");
        fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
        fuzzyVersionRange = Pattern.compile("(\\(|\\[)\\s*([-\\da-zA-Z.]+)\\s*,\\s*([-\\da-zA-Z.]+)\\s*(\\]|\\))", 32);
        fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);
        nummeric = Pattern.compile("\\d*");
        PACKAGEINFO_PATTERN = Pattern.compile("version\\s+([^\\s]*)\\s*");
    }

    public Analyzer(Processor parent) {
        super(parent);
    }

    public Analyzer() {
    }

    public static Properties getManifest(File dirOrJar) throws IOException {
        Analyzer analyzer = new Analyzer();
        analyzer.setJar(dirOrJar);
        Properties properties = new Properties();
        properties.put("Import-Package", "*");
        properties.put("Export-Package", "*");
        analyzer.setProperties(properties);
        Manifest m = analyzer.calcManifest();
        Properties result = new Properties();
        for (Attributes.Name name : m.getMainAttributes().keySet()) {
            result.put(name.toString(), m.getMainAttributes().getValue(name));
        }
        return result;
    }

    public void analyze() throws IOException {
        if (!this.analyzed) {
            int n;
            this.analyzed = true;
            this.classpathExports = Analyzer.newHashMap();
            this.activator = this.getProperty("Bundle-Activator");
            this.bundleClasspath = this.parseHeader(this.getProperty("Bundle-ClassPath"));
            this.analyzeClasspath();
            this.classspace = this.analyzeBundleClasspath(this.dot, this.bundleClasspath, this.contained, this.referred, this.uses);
            if (this.activator != null && (n = this.activator.lastIndexOf(46)) > 0) {
                this.referred.put(this.activator.substring(0, n), new LinkedHashMap());
            }
            this.referred.keySet().removeAll((Collection)this.contained.keySet());
            if (this.referred.containsKey(".")) {
                this.error("The default package '.' is not permitted by the Import-Package syntax. \nThe following package(s) import from the default package " + this.getUsedBy("."));
            }
            Map<String, Map<String, String>> exportInstructions = this.parseHeader(this.getProperty("Export-Package"));
            Map<String, Map<String, String>> additionalExportInstructions = this.parseHeader(this.getProperty("-exportcontents"));
            exportInstructions.putAll(additionalExportInstructions);
            Map<String, Map<String, String>> importInstructions = this.parseHeader(this.getImportPackages());
            Map<String, Map<String, String>> dynamicImports = this.parseHeader(this.getProperty("DynamicImport-Package"));
            if (dynamicImports != null) {
                this.referred.keySet().removeAll((Collection)dynamicImports.keySet());
            }
            Map<String, Map<String, String>> superfluous = Analyzer.newHashMap();
            for (String instr : exportInstructions.keySet()) {
                if (instr.startsWith("!")) continue;
                superfluous.put(instr, exportInstructions.get(instr));
            }
            this.exports = Analyzer.merge("export-package", exportInstructions, this.contained, superfluous.keySet());
            Iterator<Object> i = superfluous.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String pack = (String)entry.getKey();
                if (pack.endsWith("~")) {
                    i.remove();
                    continue;
                }
                if (!this.isMetaData(pack)) continue;
                this.exports.put(pack, (Map)entry.getValue());
                i.remove();
            }
            if (!superfluous.isEmpty()) {
                this.warning("Superfluous export-package instructions: " + superfluous.keySet());
            }
            Map<String, Map<String, String>> referredAndExported = this.newMap(this.referred);
            referredAndExported.putAll(this.addExportsToImports(this.exports));
            TreeSet<String> extra = new TreeSet<String>((Collection)importInstructions.keySet());
            this.imports = Analyzer.merge("import-package", importInstructions, referredAndExported, extra);
            for (String p : extra) {
                if (p.startsWith("!") || p.indexOf(42) >= 0 || p.indexOf(63) >= 0 || p.indexOf(91) >= 0) {
                    if (this.isResourceOnly()) continue;
                    this.warning("Did not find matching referal for " + p);
                    continue;
                }
                Map<String, String> map = importInstructions.get(p);
                this.imports.put(p, map);
            }
            this.augmentImports();
            this.doUses(this.exports, this.uses, this.imports);
        }
    }

    Set<Instruction> removeMarkedDuplicates(Collection<Instruction> superfluous) {
        HashSet<Instruction> result = new HashSet<Instruction>();
        for (Instruction instr : superfluous) {
            if (instr.getPattern().endsWith("~")) continue;
            result.add(instr);
        }
        return result;
    }

    protected String getImportPackages() {
        return this.getProperty("Import-Package");
    }

    boolean isResourceOnly() {
        return this.getProperty("-resourceonly", "false").equalsIgnoreCase("true");
    }

    Set<String> getUsedBy(String pack) {
        Set<String> set = this.newSet();
        for (Map.Entry<String, Set<String>> entry : this.uses.entrySet()) {
            Set<String> used = entry.getValue();
            if (!used.contains(pack)) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public Manifest calcManifest() throws IOException {
        String exportHeader;
        this.analyze();
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        main.putValue("Bundle-ManifestVersion", "2");
        boolean noExtraHeaders = "true".equalsIgnoreCase(this.getProperty("-noextraheaders"));
        if (!noExtraHeaders) {
            main.putValue("Created-By", String.valueOf(System.getProperty("java.version")) + " (" + System.getProperty("java.vendor") + ")");
            main.putValue("Tool", "Bnd-" + this.getVersion());
            main.putValue("Bnd-LastModified", "" + System.currentTimeMillis());
        }
        if ((exportHeader = Analyzer.printClauses(this.exports, "uses:|include:|exclude:|mandatory:|-import:", true)).length() > 0) {
            main.putValue("Export-Package", exportHeader);
        } else {
            main.remove("Export-Package");
        }
        Map<String, Map<String, String>> temp = Analyzer.removeKeys(this.imports, "java.");
        if (!temp.isEmpty()) {
            main.putValue("Import-Package", Analyzer.printClauses(temp, "resolution:"));
        } else {
            main.remove("Import-Package");
        }
        temp = this.newMap(this.contained);
        temp.keySet().removeAll((Collection)this.exports.keySet());
        if (!temp.isEmpty()) {
            main.putValue("Private-Package", Analyzer.printClauses(temp, ""));
        } else {
            main.remove("Private-Package");
        }
        if (!this.ignored.isEmpty()) {
            main.putValue("Ignore-Package", Analyzer.printClauses(this.ignored, ""));
        } else {
            main.remove("Ignore-Package");
        }
        if (this.bundleClasspath != null && !this.bundleClasspath.isEmpty()) {
            main.putValue("Bundle-ClassPath", Analyzer.printClauses(this.bundleClasspath, ""));
        } else {
            main.remove("Bundle-ClassPath");
        }
        Map<String, Map<String, String>> l = this.doServiceComponent(this.getProperty("Service-Component"));
        if (!l.isEmpty()) {
            main.putValue("Service-Component", Analyzer.printClauses(l, ""));
        } else {
            main.remove("Service-Component");
        }
        Enumeration<?> h = this.getProperties().propertyNames();
        while (h.hasMoreElements()) {
            String value;
            String header = (String)h.nextElement();
            if (header.trim().length() == 0) {
                this.warning("Empty property set with value: " + this.getProperties().getProperty(header));
                continue;
            }
            if (!Character.isUpperCase(header.charAt(0)) || header.equals("Bundle-ClassPath") || header.equals("Export-Package") || header.equals("Import-Package") || !Verifier.HEADER_PATTERN.matcher(header).matches() || (value = this.getProperty(header)) == null || main.getValue(header) != null) continue;
            if (value.trim().length() == 0) {
                main.remove(header);
                continue;
            }
            main.putValue(header, value);
        }
        String bsn = this.getBsn();
        if (main.getValue("Bundle-SymbolicName") == null) {
            main.putValue("Bundle-SymbolicName", bsn);
        }
        if (main.getValue("Bundle-Name") == null) {
            main.putValue("Bundle-Name", bsn);
        }
        if (main.getValue("Bundle-Version") == null) {
            main.putValue("Bundle-Version", "0");
        }
        this.merge(manifest, this.dot.getManifest());
        Map<String, Map<String, String>> removes = this.parseHeader(this.getProperty("-removeheaders"));
        for (String header : removes.keySet()) {
            Iterator<Object> j = main.keySet().iterator();
            while (j.hasNext()) {
                Attributes.Name attr = (Attributes.Name)j.next();
                if (!attr.toString().matches(header)) continue;
                j.remove();
                this.progress("Removing header: " + header);
            }
        }
        this.dot.setManifest(manifest);
        return manifest;
    }

    public String getBsn() {
        String value = this.getProperty("Bundle-SymbolicName");
        if (value == null) {
            if (this.getPropertiesFile() != null) {
                value = this.getPropertiesFile().getName();
            }
            if (value == null || value.equals("bnd.bnd")) {
                value = this.getBase().getName();
            } else if (value.endsWith(".bnd")) {
                value = value.substring(0, value.length() - 4);
            }
        }
        if (value == null) {
            return "untitled";
        }
        int n = value.indexOf(59);
        if (n > 0) {
            value = value.substring(0, n);
        }
        return value.trim();
    }

    public String calculateExportsFromContents(Jar bundle) {
        String ddel = "";
        StringBuffer sb = new StringBuffer();
        Map<String, Map<String, Resource>> map = bundle.getDirectories();
        for (String directory : map.keySet()) {
            if (directory.equals("META-INF") || directory.startsWith("META-INF/") || directory.equals("OSGI-OPT") || directory.startsWith("OSGI-OPT/") || directory.equals("/")) continue;
            if (directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
            directory = directory.replace('/', '.');
            sb.append(ddel);
            sb.append(directory);
            ddel = ",";
        }
        return sb.toString();
    }

    public Map<String, Map<String, String>> doServiceComponent(String serviceComponent) throws IOException {
        Map<String, Map<String, String>> list = Analyzer.newMap();
        Map<String, Map<String, String>> sc = this.parseHeader(serviceComponent);
        if (!sc.isEmpty()) {
            for (Map.Entry<String, Map<String, String>> entry : sc.entrySet()) {
                String name = entry.getKey();
                Map<String, String> info = entry.getValue();
                if (name == null) {
                    this.error("No name in Service-Component header: " + info);
                    continue;
                }
                if (this.dot.exists(name)) {
                    list.put(name, info);
                    continue;
                }
                if (!this.checkClass(name)) {
                    this.error("Not found Service-Component header: " + name);
                    continue;
                }
                Resource resource = this.createComponentResource(name, info);
                this.dot.putResource("OSGI-INF/" + name + ".xml", resource);
                Map empty = Collections.emptyMap();
                list.put("OSGI-INF/" + name + ".xml", empty);
            }
        }
        return list;
    }

    public Map<String, Map<String, String>> getBundleClasspath() {
        return this.bundleClasspath;
    }

    public Map<String, Map<String, String>> getContained() {
        return this.contained;
    }

    public Map<String, Map<String, String>> getExports() {
        return this.exports;
    }

    public Map<String, Map<String, String>> getImports() {
        return this.imports;
    }

    public Jar getJar() {
        return this.dot;
    }

    public Map<String, Map<String, String>> getReferred() {
        return this.referred;
    }

    public Set<String> getUnreachable() {
        HashSet<String> unreachable = new HashSet<String>((Collection)this.uses.keySet());
        for (String packageName : this.exports.keySet()) {
            this.removeTransitive(packageName, unreachable);
        }
        if (this.activator != null) {
            String pack = this.activator.substring(0, this.activator.lastIndexOf(46));
            this.removeTransitive(pack, unreachable);
        }
        return unreachable;
    }

    public Map<String, Set<String>> getUses() {
        return this.uses;
    }

    public String getVersion() {
        return this.getBndInfo("version", "<unknown version>");
    }

    public long getBndLastModified() {
        String time = this.getBndInfo("modified", "0");
        try {
            return Long.parseLong(time);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String getBndInfo(String key, String defaultValue) {
        if (bndInfo == null) {
            bndInfo = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream("bnd.info");
                if (in != null) {
                    bndInfo.load(in);
                    in.close();
                }
            }
            catch (IOException ioe) {
                this.warning("Could not read bnd.info in " + this.getClass().getPackage() + ioe);
            }
        }
        return bndInfo.getProperty(key, defaultValue);
    }

    public void mergeManifest(Manifest manifest) throws IOException {
        if (manifest != null) {
            Attributes attributes = manifest.getMainAttributes();
            for (Attributes.Name name : attributes.keySet()) {
                String key = name.toString();
                if (key.startsWith("-") || this.getProperty(key) != null) continue;
                this.setProperty(key, (String)attributes.get(name));
            }
        }
    }

    @Override
    public void setBase(File file) {
        super.setBase(file);
        this.getProperties().put("project.dir", this.getBase().getAbsolutePath());
    }

    public void setClasspath(File[] classpath) throws IOException {
        ArrayList<Jar> list = new ArrayList<Jar>();
        int i = 0;
        while (i < classpath.length) {
            if (classpath[i].exists()) {
                Jar current = new Jar(classpath[i]);
                list.add(current);
            } else {
                this.error("Missing file on classpath: " + classpath[i]);
            }
            ++i;
        }
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            this.addClasspath((Jar)i2.next());
        }
    }

    public void setClasspath(Jar[] classpath) {
        int i = 0;
        while (i < classpath.length) {
            this.addClasspath(classpath[i]);
            ++i;
        }
    }

    public void setClasspath(String[] classpath) {
        int i = 0;
        while (i < classpath.length) {
            Jar jar = this.getJarFromName(classpath[i], " setting classpath");
            if (jar != null) {
                this.addClasspath(jar);
            }
            ++i;
        }
    }

    public Jar setJar(File jar) throws IOException {
        Jar jarx = new Jar(jar);
        this.addClose(jarx);
        return this.setJar(jarx);
    }

    public Jar setJar(Jar jar) {
        this.dot = jar;
        return jar;
    }

    @Override
    protected void begin() {
        super.begin();
        this.updateModified(this.getBndLastModified(), "bnd last modified");
        String doNotCopy = this.getProperty("-donotcopy");
        if (doNotCopy != null) {
            Analyzer.doNotCopy = Pattern.compile(doNotCopy);
        }
        this.verifyManifestHeadersCase(this.getProperties());
    }

    boolean checkClass(String interfaceName) {
        String path = String.valueOf(interfaceName.replace('.', '/')) + ".class";
        if (this.classspace.containsKey(path)) {
            return true;
        }
        String pack = interfaceName;
        int n = pack.lastIndexOf(46);
        pack = n > 0 ? pack.substring(0, n) : ".";
        return this.imports.containsKey(pack);
    }

    Resource createComponentResource(String name, Map<String, String> info) throws IOException {
        String enabled;
        String immediate;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        pw.println("<?xml version='1.0' encoding='utf-8'?>");
        pw.print("<component name='" + name + "'");
        String factory = info.get("factory:");
        if (factory != null) {
            pw.print(" factory='" + factory + "'");
        }
        if ((immediate = info.get("immediate:")) != null) {
            pw.print(" immediate='" + immediate + "'");
        }
        if ((enabled = info.get("enabled:")) != null) {
            pw.print(" enabled='" + enabled + "'");
        }
        pw.println(">");
        pw.println("  <implementation class='" + name + "'/>");
        String provides = info.get("provide:");
        boolean servicefactory = Boolean.getBoolean(String.valueOf(info.get("servicefactory:")));
        this.provides(pw, provides, servicefactory);
        this.properties(pw, info);
        this.reference(info, pw);
        pw.println("</component>");
        pw.close();
        byte[] data = out.toByteArray();
        out.close();
        return new EmbeddedResource(data, 0L);
    }

    /*
     * Unable to fully structure code
     */
    Jar getJarFromName(String name, String from) {
        file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.getBase(), name);
        }
        if (file.exists()) {
            try {
                jar = new Jar(file);
                this.addClose(jar);
                return jar;
            }
            catch (Exception e) {
                this.error("Exception in parsing jar file for " + from + ": " + name + " " + e);
            }
        }
        try {
            url = new URL(name);
            jar = new Jar(this.fileName(url.getPath()));
            this.addClose(jar);
            connection = url.openConnection();
            in = connection.getInputStream();
            lastModified = connection.getLastModified();
            if (lastModified == 0L) {
                lastModified = System.currentTimeMillis();
            }
            EmbeddedResource.build(jar, in, lastModified);
            in.close();
            return jar;
        }
        catch (IOException ee) {
            ** for (entry : this.getClasspath())
        }
lbl-1000:
        // 1 sources

        {
            if (entry.source == null || !entry.source.getName().equals(name)) continue;
            return entry;
        }
lbl27:
        // 1 sources

        return null;
    }

    private String fileName(String path) {
        int n = path.lastIndexOf(47);
        if (n > 0) {
            return path.substring(n + 1);
        }
        return path;
    }

    void merge(Manifest result, Manifest old) throws IOException {
        if (old != null) {
            for (Map.Entry<Object, Object> entry : old.getMainAttributes().entrySet()) {
                Attributes.Name name = (Attributes.Name)entry.getKey();
                String value = (String)entry.getValue();
                if (name.toString().equalsIgnoreCase("Created-By")) {
                    name = new Attributes.Name("Originally-Created-By");
                }
                if (result.getMainAttributes().containsKey(name)) continue;
                result.getMainAttributes().put(name, value);
            }
            Map<String, Attributes> oldEntries = old.getEntries();
            Map<String, Attributes> newEntries = result.getEntries();
            for (Map.Entry<String, Attributes> entry : oldEntries.entrySet()) {
                if (newEntries.containsKey(entry.getKey())) continue;
                newEntries.put(entry.getKey(), entry.getValue());
            }
        }
    }

    void properties(PrintWriter pw, Map<String, String> info) {
        Collection<String> properties = Analyzer.split(info.get("properties:"));
        for (String clause : properties) {
            String[] parts;
            int n = clause.indexOf(61);
            if (n <= 0) {
                this.error("Not a valid property in service component: " + clause);
                continue;
            }
            String type = null;
            String name = clause.substring(0, n);
            if (name.indexOf(64) >= 0) {
                String[] parts2 = name.split("@");
                name = parts2[1];
                type = parts2[0];
            }
            String value = clause.substring(n + 1).trim();
            pw.print("<property name='");
            pw.print(name);
            pw.print("'");
            if (type != null) {
                if (VALID_PROPERTY_TYPES.matcher(type).matches()) {
                    pw.print(" type='");
                    pw.print(type);
                    pw.print("'");
                } else {
                    this.warning("Invalid property type '" + type + "' for property " + name);
                }
            }
            if ((parts = value.split("\\s*(\\||\\n)\\s*")).length > 1) {
                pw.println(">");
                String[] stringArray = parts;
                int n2 = parts.length;
                int n3 = 0;
                while (n3 < n2) {
                    String part = stringArray[n3];
                    pw.println(part);
                    ++n3;
                }
                pw.println("</property>");
                continue;
            }
            pw.print(" value='");
            pw.print(parts[0]);
            pw.print("'/>");
        }
    }

    void provides(PrintWriter pw, String provides, boolean servicefactory) {
        if (provides != null) {
            if (!servicefactory) {
                pw.println("  <service>");
            } else {
                pw.println("  <service servicefactory='true'>");
            }
            StringTokenizer st = new StringTokenizer(provides, ",");
            while (st.hasMoreTokens()) {
                String interfaceName = st.nextToken();
                pw.println("    <provide interface='" + interfaceName + "'/>");
                if (this.checkClass(interfaceName)) continue;
                this.error("Component definition provides a class that is neither imported nor contained: " + interfaceName);
            }
            pw.println("  </service>");
        }
    }

    void reference(Map<String, String> info, PrintWriter pw) {
        Collection<String> dynamic = Analyzer.split(info.get("dynamic:"));
        Collection<String> optional = Analyzer.split(info.get("optional:"));
        Collection<String> multiple = Analyzer.split(info.get("multiple:"));
        for (Map.Entry<String, String> ref : info.entrySet()) {
            char c;
            String referenceName = ref.getKey();
            String target = null;
            String interfaceName = ref.getValue();
            if (interfaceName == null || interfaceName.length() == 0) {
                this.error("Invalid Interface Name for references in Service Component: " + referenceName + "=" + interfaceName);
            }
            if ("?+*~".indexOf(c = interfaceName.charAt(interfaceName.length() - 1)) >= 0) {
                if (c == '?' || c == '*' || c == '~') {
                    optional.add(referenceName);
                }
                if (c == '+' || c == '*') {
                    multiple.add(referenceName);
                }
                if (c == '+' || c == '*' || c == '?') {
                    dynamic.add(referenceName);
                }
                interfaceName = interfaceName.substring(0, interfaceName.length() - 1);
            }
            if (referenceName.endsWith(":")) {
                if (SET_COMPONENT_DIRECTIVES.contains(referenceName)) continue;
                this.error("Unrecognized directive in Service-Component header: " + referenceName);
                continue;
            }
            Matcher m = REFERENCE.matcher(interfaceName);
            if (m.matches()) {
                interfaceName = m.group(1);
                target = m.group(2);
            }
            if (!this.checkClass(interfaceName)) {
                this.error("Component definition refers to a class that is neither imported nor contained: " + interfaceName);
            }
            pw.print("  <reference name='" + referenceName + "' interface='" + interfaceName + "'");
            String cardinality = optional.contains(referenceName) ? "0" : "1";
            cardinality = String.valueOf(cardinality) + "..";
            cardinality = String.valueOf(cardinality) + (multiple.contains(referenceName) ? "n" : "1");
            if (!cardinality.equals("1..1")) {
                pw.print(" cardinality='" + cardinality + "'");
            }
            if (Character.isLowerCase(referenceName.charAt(0))) {
                String z = String.valueOf(referenceName.substring(0, 1).toUpperCase()) + referenceName.substring(1);
                pw.print(" bind='set" + z + "'");
                pw.print(" unbind='unset" + z + "'");
            }
            if (dynamic.contains(referenceName)) {
                pw.print(" policy='dynamic'");
            }
            if (target != null) {
                Filter filter = new Filter(target);
                if (filter.verify() == null) {
                    pw.print(" target='" + filter.toString() + "'");
                } else {
                    this.error("Target for " + referenceName + " is not a correct filter: " + target + " " + filter.verify());
                }
            }
            pw.println("/>");
        }
    }

    String stem(String name) {
        int n = name.lastIndexOf(46);
        if (n > 0) {
            return name.substring(0, n);
        }
        return name;
    }

    void verifyManifestHeadersCase(Properties properties) {
        block0: for (String string : properties.keySet()) {
            int j = 0;
            while (j < headers.length) {
                if (!headers[j].equals(string) && headers[j].equalsIgnoreCase(string)) {
                    this.warning("Using a standard OSGi header with the wrong case (bnd is case sensitive!), using: " + string + " and expecting: " + headers[j]);
                    continue block0;
                }
                ++j;
            }
        }
    }

    Map<String, Map<String, String>> addExportsToImports(Map<String, Map<String, String>> exports) {
        Map<String, Map<String, String>> importsFromExports = Analyzer.newHashMap();
        for (Map.Entry<String, Map<String, String>> packageEntry : exports.entrySet()) {
            String packageName = packageEntry.getKey();
            Map<String, String> parameters = packageEntry.getValue();
            String noimport = parameters.get("-noimport:");
            if (noimport != null && noimport.equalsIgnoreCase("true")) continue;
            if (parameters.containsKey("version")) {
                parameters = this.newMap(parameters);
                parameters.remove("version");
            }
            importsFromExports.put(packageName, parameters);
        }
        return importsFromExports;
    }

    void analyzeClasspath() throws IOException {
        this.classpathExports = Analyzer.newHashMap();
        for (Jar current : this.getClasspath()) {
            this.checkManifest(current);
            for (String dir : current.getDirectories().keySet()) {
                Resource resource = current.getResource(String.valueOf(dir) + "/packageinfo");
                if (resource == null) continue;
                InputStream in = resource.openInputStream();
                String version = Analyzer.parsePackageInfo(in);
                in.close();
                this.setPackageInfo(dir, "version", version);
            }
        }
    }

    void checkManifest(Jar jar) {
        try {
            Map<String, Map<String, String>> exported;
            String exportHeader;
            Manifest m = jar.getManifest();
            if (m != null && (exportHeader = m.getMainAttributes().getValue("Export-Package")) != null && (exported = this.parseHeader(exportHeader)) != null) {
                this.classpathExports.putAll(exported);
            }
        }
        catch (Exception e) {
            this.warning("Erroneous Manifest for " + jar + " " + e);
        }
    }

    void augmentImports() {
        for (String packageName : this.imports.keySet()) {
            this.setProperty("@package", packageName);
            try {
                Map<String, String> importAttributes = this.imports.get(packageName);
                Map<String, String> exporterAttributes = this.classpathExports.get(packageName);
                if (exporterAttributes == null) {
                    exporterAttributes = this.exports.get(packageName);
                }
                if (exporterAttributes != null) {
                    this.augmentVersion(importAttributes, exporterAttributes);
                    this.augmentMandatory(importAttributes, exporterAttributes);
                    if (exporterAttributes.containsKey("-import:")) {
                        importAttributes.put("-import:", exporterAttributes.get("-import:"));
                    }
                }
                for (String key : importAttributes.keySet()) {
                    String value = importAttributes.get(key);
                    if (value.indexOf(36) < 0) continue;
                    value = this.getReplacer().process(value);
                    importAttributes.put(key, value);
                }
                String remove = importAttributes.remove("remove-attribute:");
                Instruction removeInstr = null;
                if (remove != null) {
                    removeInstr = Instruction.getPattern(remove);
                }
                Iterator<Map.Entry<String, String>> i = importAttributes.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, String> entry = i.next();
                    if (entry.getValue().equals("!")) {
                        i.remove();
                        continue;
                    }
                    if (removeInstr == null || !removeInstr.matches(entry.getKey())) continue;
                    i.remove();
                }
            }
            finally {
                this.unsetProperty("@package");
            }
        }
    }

    private void augmentMandatory(Map<String, String> currentAttributes, Map<String, String> exporter) {
        String mandatory = exporter.get("mandatory:");
        if (mandatory != null) {
            String[] attrs = mandatory.split("\\s*,\\s*");
            int i = 0;
            while (i < attrs.length) {
                if (!currentAttributes.containsKey(attrs[i])) {
                    currentAttributes.put(attrs[i], exporter.get(attrs[i]));
                }
                ++i;
            }
        }
    }

    private void augmentVersion(Map<String, String> currentAttributes, Map<String, String> exporter) {
        String exportVersion = exporter.get("version");
        if (exportVersion == null) {
            exportVersion = exporter.get("specification-version");
        }
        if (exportVersion == null) {
            return;
        }
        exportVersion = Analyzer.cleanupVersion(exportVersion);
        this.setProperty("@", exportVersion);
        String importRange = currentAttributes.get("version");
        if (importRange != null) {
            importRange = Analyzer.cleanupVersion(importRange);
            importRange = this.getReplacer().process(importRange);
        } else {
            importRange = this.getVersionPolicy();
        }
        this.unsetProperty("@");
        currentAttributes.put("version", importRange);
    }

    void doUses(Map<String, Map<String, String>> exports, Map<String, Set<String>> uses, Map<String, Map<String, String>> imports) {
        if ("true".equalsIgnoreCase(this.getProperty("-nouses"))) {
            return;
        }
        for (String packageName : exports.keySet()) {
            Set<String> usedPackages;
            Map<String, String> clause = exports.get(packageName);
            String override = clause.get("uses:");
            if (override == null) {
                override = "<<USES>>";
            }
            if ((usedPackages = uses.get(packageName)) == null) continue;
            HashSet sharedPackages = new HashSet();
            sharedPackages.addAll(imports.keySet());
            sharedPackages.addAll(exports.keySet());
            usedPackages.retainAll(sharedPackages);
            usedPackages.remove(packageName);
            StringBuffer sb = new StringBuffer();
            String del = "";
            for (String usedPackage : usedPackages) {
                if (usedPackage.startsWith("java.")) continue;
                sb.append(del);
                sb.append(usedPackage);
                del = ",";
            }
            if ((override = override.replaceAll("<<USES>>", sb.toString()).trim()).endsWith(",")) {
                override = override.substring(0, override.length() - 1);
            }
            if (override.startsWith(",")) {
                override = override.substring(1);
            }
            if (override.length() <= 0) continue;
            clause.put("uses:", override);
        }
    }

    void removeTransitive(String name, Set<String> unreachable) {
        if (!unreachable.contains(name)) {
            return;
        }
        unreachable.remove(name);
        Set<String> ref = this.uses.get(name);
        if (ref != null) {
            for (String element : ref) {
                this.removeTransitive(element, unreachable);
            }
        }
    }

    void setPackageInfo(String dir, String key, String value) {
        if (value != null) {
            String pack = dir.replace('/', '.');
            Map<String, String> map = this.classpathExports.get(pack);
            if (map == null) {
                map = new HashMap<String, String>();
                this.classpathExports.put(pack, map);
            }
            map.put(key, value);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.dot != null) {
            this.dot.close();
        }
        if (this.classpath != null) {
            for (Jar jar : this.classpath) {
                jar.close();
            }
        }
    }

    public String _findpath(String[] args) {
        return this.findPath("findpath", args, true);
    }

    public String _findname(String[] args) {
        return this.findPath("findname", args, false);
    }

    String findPath(String name, String[] args, boolean fullPathName) {
        if (args.length > 3) {
            this.warning("Invalid nr of arguments to " + name + " " + Arrays.asList(args) + ", syntax: ${" + name + " (; reg-expr (; replacement)? )? }");
            return null;
        }
        String regexp = ".*";
        String replace = null;
        switch (args.length) {
            case 3: {
                replace = args[2];
            }
            case 2: {
                regexp = args[1];
            }
        }
        StringBuffer sb = new StringBuffer();
        String del = "";
        Pattern expr = Pattern.compile(regexp);
        for (String path : this.dot.getResources().keySet()) {
            Matcher m;
            int n;
            if (!fullPathName && (n = path.lastIndexOf(47)) >= 0) {
                path = path.substring(n + 1);
            }
            if (!(m = expr.matcher(path)).matches()) continue;
            if (replace != null) {
                path = m.replaceAll(replace);
            }
            sb.append(del);
            sb.append(path);
            del = ", ";
        }
        return sb.toString();
    }

    public void putAll(Map<String, String> additional, boolean force) {
        for (Map.Entry<String, String> entry : additional.entrySet()) {
            if (!force && this.getProperties().get(entry.getKey()) != null) continue;
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public List<Jar> getClasspath() {
        if (this.firstUse) {
            this.firstUse = false;
            String cp = this.getProperty("-classpath");
            if (cp != null) {
                for (String s : Analyzer.split(cp)) {
                    Jar jar = this.getJarFromName(s, "getting classpath");
                    if (jar == null) continue;
                    this.addClasspath(jar);
                }
            }
        }
        return this.classpath;
    }

    public void addClasspath(Jar jar) {
        if (this.isPedantic() && jar.getResources().isEmpty()) {
            this.warning("There is an empty jar or directory on the classpath: " + jar.getName());
        }
        this.classpath.add(jar);
    }

    public void addClasspath(File cp) throws IOException {
        if (!cp.exists()) {
            this.warning("File on classpath that does not exist: " + cp);
        }
        Jar jar = new Jar(cp);
        this.addClose(jar);
        this.classpath.add(jar);
    }

    @Override
    public void clear() {
        this.classpath.clear();
    }

    public Jar getTarget() {
        return this.dot;
    }

    public Map<String, Clazz> analyzeBundleClasspath(Jar dot, Map<String, Map<String, String>> bundleClasspath, Map<String, Map<String, String>> contained, Map<String, Map<String, String>> referred, Map<String, Set<String>> uses) throws IOException {
        HashMap<String, Clazz> classSpace = new HashMap<String, Clazz>();
        if (bundleClasspath.isEmpty()) {
            this.analyzeJar(dot, "", classSpace, contained, referred, uses);
        } else {
            for (String path : bundleClasspath.keySet()) {
                if (path.equals(".")) {
                    this.analyzeJar(dot, "", classSpace, contained, referred, uses);
                    continue;
                }
                Resource resource = dot.getResource(path);
                if (resource != null) {
                    try {
                        Jar jar = new Jar(path);
                        this.addClose(jar);
                        EmbeddedResource.build(jar, resource);
                        this.analyzeJar(jar, "", classSpace, contained, referred, uses);
                    }
                    catch (Exception e) {
                        this.warning("Invalid bundle classpath entry: " + path + " " + e);
                    }
                    continue;
                }
                if (dot.getDirectories().containsKey(path)) {
                    this.analyzeJar(dot, path, classSpace, contained, referred, uses);
                    continue;
                }
                this.warning("No sub JAR or directory " + path);
            }
        }
        return classSpace;
    }

    private void analyzeJar(Jar jar, String prefix, Map<String, Clazz> classSpace, Map<String, Map<String, String>> contained, Map<String, Map<String, String>> referred, Map<String, Set<String>> uses) throws IOException {
        for (String path : jar.getResources().keySet()) {
            Clazz clazz;
            InputStream in;
            if (!path.startsWith(prefix)) continue;
            String relativePath = path.substring(prefix.length());
            String pack = this.getPackage(relativePath);
            if (!(pack == null || contained.containsKey(pack) || pack.equals(".") || this.isMetaData(relativePath))) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                contained.put(pack, map);
                Resource pinfo = jar.getResource(String.valueOf(prefix) + pack.replace('.', '/') + "/packageinfo");
                if (pinfo != null) {
                    in = pinfo.openInputStream();
                    String version = Analyzer.parsePackageInfo(in);
                    in.close();
                    if (version != null) {
                        map.put("version", version);
                    }
                }
            }
            if (!path.endsWith(".class")) continue;
            Resource resource = jar.getResource(path);
            try {
                in = resource.openInputStream();
                clazz = new Clazz(relativePath, in);
                in.close();
            }
            catch (Throwable e) {
                this.error("Invalid class file: " + relativePath, e);
                e.printStackTrace();
                continue;
            }
            String calculatedPath = String.valueOf(clazz.getClassName()) + ".class";
            if (!calculatedPath.equals(relativePath)) {
                this.error("Class in different directory than declared. Path from class name is " + calculatedPath + " but the path in the jar is " + relativePath + " from " + jar);
            }
            classSpace.put(relativePath, clazz);
            referred.putAll(clazz.getReferred());
            Set<String> t = uses.get(pack);
            if (t == null) {
                t = new LinkedHashSet<String>();
                uses.put(pack, t);
            }
            t.addAll((Collection<String>)clazz.getReferred().keySet());
            t.remove(pack);
        }
        for (AnalyzerPlugin plugin : this.getPlugins(AnalyzerPlugin.class)) {
            if (!(plugin instanceof AnalyzerPlugin)) continue;
            AnalyzerPlugin analyzer = plugin;
            try {
                analyzer.analyzeJar(this, jar, prefix, classSpace, contained, referred, uses);
            }
            catch (Exception e) {
                this.error("Plugin Analyzer " + analyzer + " throws exception " + e);
                e.printStackTrace();
            }
        }
    }

    public static String cleanupVersion(String version) {
        Matcher m = fuzzyVersionRange.matcher(version);
        if (m.matches()) {
            String prefix = m.group(1);
            String first = m.group(2);
            String last = m.group(3);
            String suffix = m.group(4);
            return String.valueOf(prefix) + Analyzer.cleanupVersion(first) + "," + Analyzer.cleanupVersion(last) + suffix;
        }
        m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuffer result = new StringBuffer();
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            Analyzer.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        Analyzer.cleanupModifier(result, qualifier);
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    Analyzer.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = fuzzyModifier.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(2);
        }
        int i = 0;
        while (i < modifier.length()) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
            }
            ++i;
        }
    }

    boolean isMetaData(String pack) {
        int i = 0;
        while (i < METAPACKAGES.length) {
            if (pack.startsWith(METAPACKAGES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    static String parsePackageInfo(InputStream jar) throws IOException {
        try {
            byte[] buf = EmbeddedResource.collect(jar);
            String line = new String(buf).trim();
            Matcher m = PACKAGEINFO_PATTERN.matcher(line);
            if (m.matches()) {
                return m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getVersionPolicy() {
        return this.getProperty("-versionpolicy", "${version;==;${@}}");
    }
}

