/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SessionIDMessage;

public class JvmRouteSessionIDBinderListener
extends ClusterListener {
    protected static final String info = "org.apache.catalina.ha.session.JvmRouteSessionIDBinderListener/1.1";
    protected boolean started = false;
    private long numberOfSessions = 0L;

    public String getInfo() {
        return info;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.getCluster().addClusterListener(this);
        this.started = true;
        if (log.isInfoEnabled()) {
            log.info(this.sm.getString("jvmRoute.clusterListener.started"));
        }
    }

    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        if (log.isInfoEnabled()) {
            log.info(this.sm.getString("jvmRoute.clusterListener.stopped"));
        }
    }

    public void messageReceived(ClusterMessage msg) {
        if (msg instanceof SessionIDMessage && msg != null) {
            SessionIDMessage sessionmsg = (SessionIDMessage)msg;
            if (log.isDebugEnabled()) {
                log.debug(this.sm.getString("jvmRoute.receiveMessage.sessionIDChanged", sessionmsg.getOrignalSessionID(), sessionmsg.getBackupSessionID(), sessionmsg.getContextPath()));
            }
            Container container = this.getCluster().getContainer();
            Container host = null;
            host = container instanceof Engine ? container.findChild(sessionmsg.getHost()) : container;
            if (host != null) {
                Context context = (Context)host.findChild(sessionmsg.getContextPath());
                if (context != null) {
                    try {
                        Session session = context.getManager().findSession(sessionmsg.getOrignalSessionID());
                        if (session != null) {
                            session.setId(sessionmsg.getBackupSessionID());
                        } else if (log.isInfoEnabled()) {
                            log.info(this.sm.getString("jvmRoute.lostSession", sessionmsg.getOrignalSessionID(), sessionmsg.getContextPath()));
                        }
                    }
                    catch (IOException e) {
                        log.error(e);
                    }
                } else if (log.isErrorEnabled()) {
                    log.error(this.sm.getString("jvmRoute.contextNotFound", sessionmsg.getContextPath(), ((StandardEngine)host.getParent()).getJvmRoute()));
                }
            } else if (log.isErrorEnabled()) {
                log.error(this.sm.getString("jvmRoute.hostNotFound", sessionmsg.getContextPath()));
            }
        }
    }

    public boolean accept(ClusterMessage msg) {
        return msg instanceof SessionIDMessage;
    }
}

